/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.PatternEditor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPText;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPPattern
extends SPText<IPropertyDescriptor> {
    private Button btn;

    public SPPattern(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    protected int getStyle() {
        return 2048;
    }

    @Override
    protected void createComponent(Composite parent) {
        parent = this.section.getWidgetFactory().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 1;
        layout.marginRight = 5;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        super.createComponent(parent);
        this.btn = this.section.getWidgetFactory().createButton(parent, "...", 8);
        this.btn.setToolTipText(this.pDescriptor.getDescription());
        this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternEditor wizard = new PatternEditor();
                wizard.setValue(SPPattern.this.ftext.getText());
                WizardDialog dialog = new WizardDialog(SPPattern.this.ftext.getShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0) {
                    SPPattern.this.handleTextChanged(SPPattern.this.section, SPPattern.this.pDescriptor.getId(), wizard.getValue());
                }
            }
        });
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        super.setData(pnode, b);
        this.btn.setEnabled(pnode.isEditable());
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        this.setData(pnode, resolvedValue);
        if (this.ftext != null && !this.ftext.isDisposed()) {
            if (elementValue != null) {
                this.ftext.setForeground(ColorConstants.black);
                this.ftext.setToolTipText(this.pDescriptor.getDescription());
                if (this.getLabel() != null) {
                    this.getLabel().setToolTipText(this.pDescriptor.getDescription());
                    this.getLabel().setForeground(ColorConstants.black);
                }
            } else {
                this.ftext.setForeground(UIUtils.INHERITED_COLOR);
                this.ftext.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
                if (this.getLabel() != null) {
                    this.getLabel().setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
                    this.getLabel().setForeground(UIUtils.INHERITED_COLOR);
                }
            }
        }
    }

    @Override
    public Control getControl() {
        return this.btn.getParent();
    }
}

