/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IPropertiesHolder;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.descriptors.AbstractJSSCellEditorValidator;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.report.util.PHolderUtil;
import com.jaspersoft.studio.property.section.report.util.Unit;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class SPPixel
extends ASPropertyWidget<PixelPropertyDescriptor> {
    public static final int NONE = 0;
    public static final int PERSISTENT = 2;
    public static final Map<String, MeasureUnit> unitsMap = new HashMap<String, MeasureUnit>();
    public static final MeasureUnit[] units = new MeasureUnit[]{new MeasureUnit("pixel", "px", 0), new MeasureUnit("inch", "inch", 2), new MeasureUnit("cm", "cm", 3), new MeasureUnit("mm", "mm", 2)};
    public static final String[] autocompleteValues;
    private Text insertField;
    private String defaultValue;
    private Menu popUpMenu;
    private String localValue;
    private int style;
    private JasperReportsConfiguration jConfig;
    private String lastSetValue;
    private String lastSetText;
    private boolean editHappened = false;
    private Unit uunit;
    private APropertyNode pnode;

    static {
        unitsMap.put("pixel", units[0]);
        unitsMap.put("inch", units[1]);
        unitsMap.put("cm", units[2]);
        unitsMap.put("mm", units[3]);
        autocompleteValues = new String[]{"centimeters", "millimeters", "inches", "pixels"};
    }

    @Override
    protected void handleFocusLost() {
        super.handleFocusLost();
        if (UIUtil.isMacAndEclipse4() && !this.editHappened) {
            this.insertField.setText(Misc.nvl((String)this.lastSetText));
        }
        if (this.lastSetValue == null || !this.lastSetValue.equals(this.insertField.getText())) {
            this.updateValue();
        }
        if (UIUtil.isMacAndEclipse4()) {
            this.editHappened = false;
        }
    }

    public SPPixel(Composite parent, AbstractSection section, PixelPropertyDescriptor pDescriptor) {
        this(parent, section, pDescriptor, 2);
    }

    public SPPixel(Composite parent, AbstractSection section, PixelPropertyDescriptor pDescriptor, int style) {
        super(parent, section, pDescriptor);
        this.style = style;
        this.localValue = this.getLocalValue();
        this.jConfig = section.getElement().getJasperConfiguration();
    }

    private String getMeasureUnit(String value) {
        String[] results = value.split("[^a-z]");
        if (results.length == 0) {
            return null;
        }
        String measure = results[results.length - 1].trim();
        if (measure.isEmpty()) {
            return null;
        }
        return measure;
    }

    private static String truncateDouble(double number, int numDigits) {
        return String.format("%." + numDigits + "f", new BigDecimal(number).setScale(numDigits, RoundingMode.CEILING).doubleValue());
    }

    protected Command getChangePropertyCommand(Object property, Object newValue, APropertyNode n) {
        Object oldValue = n.getPropertyValue(property);
        if (oldValue == null && newValue != null || oldValue != null && newValue == null || newValue != null && !newValue.equals(oldValue)) {
            SetValueCommand setCommand = new SetValueCommand(n.getDisplayText());
            setCommand.setTarget(n);
            setCommand.setPropertyId(property);
            setCommand.setPropertyValue(newValue);
            return setCommand;
        }
        return null;
    }

    private Long getNewValue(Double percentage, APropertyNode pnode, String property) {
        String oldValue = pnode.getPropertyActualValue(property).toString();
        Integer oldNumericValue = Integer.parseInt(oldValue);
        Double newValueLong = oldNumericValue.doubleValue() * percentage / 100.0;
        return Math.round(newValueLong);
    }

    private void percentageResize() {
        String text = this.insertField.getText().trim().toLowerCase();
        int percPosition = text.indexOf(37);
        if (percPosition > 0) {
            try {
                Double value = Double.parseDouble(text.substring(0, percPosition));
                CommandStack cs = this.section.getEditDomain().getCommandStack();
                JSSCompoundCommand cc = new JSSCompoundCommand("Set " + ((PixelPropertyDescriptor)this.pDescriptor).getId(), null);
                for (APropertyNode item : this.section.getElements()) {
                    try {
                        cc.setReferenceNodeIfNull(item);
                        Long newValue = this.getNewValue(value, this.pnode, ((PixelPropertyDescriptor)this.pDescriptor).getId().toString());
                        Command c = this.getChangePropertyCommand(((PixelPropertyDescriptor)this.pDescriptor).getId(), newValue.intValue(), item);
                        if (c != null) {
                            cc.add(c);
                        }
                        if (((PixelPropertyDescriptor)this.pDescriptor).getId().equals("height") && this.section.getElements().size() > 1 && (c = this.getChangePropertyCommand("y", (newValue = this.getNewValue(value, item, "y")).intValue(), item)) != null) {
                            cc.add(c);
                        }
                        if (!((PixelPropertyDescriptor)this.pDescriptor).getId().equals("width") || this.section.getElements().size() <= 1 || (c = this.getChangePropertyCommand("x", (newValue = this.getNewValue(value, item, "x")).intValue(), item)) == null) continue;
                        cc.add(c);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                cs.execute((Command)cc);
                APropertyNode firstNode = this.section.getElements().get(0);
                this.setData(firstNode, firstNode.getPropertyActualValue(((PixelPropertyDescriptor)this.pDescriptor).getId()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected void setNullValue() {
        this.section.changeProperty(((PixelPropertyDescriptor)this.pDescriptor).getId(), null);
        this.insertField.setBackground(null);
        this.insertField.setToolTipText(this.getTooltip());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getErrorMessages() {
        String value;
        MeasureUnit unit;
        String text = this.insertField.getText().trim().toLowerCase();
        String key = this.getMeasureUnit(text);
        if (key == null) {
            unit = this.getDefaultMeasure();
            value = text;
        } else {
            unit = unitsMap.get(Unit.getKeyFromAlias(key));
            value = text.substring(0, text.indexOf(key));
        }
        if (unit == null) return Messages.SPPixel_errorMeasureUnit;
        try {
            String convertedValue = unit.doConversionFromThis(unitsMap.get("pixel"), value);
            AbstractJSSCellEditorValidator validator = ((PixelPropertyDescriptor)this.pDescriptor).getValidator();
            if (validator == null) return null;
            Integer newValue = this.getIntegerValue(convertedValue);
            String errorMessage = null;
            for (APropertyNode item : this.section.getElements()) {
                validator.setTargetNode(item);
                errorMessage = validator.isValid(newValue);
                if (errorMessage == null) continue;
                return errorMessage;
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return Messages.common_this_is_not_an_integer_number;
        }
        catch (Unit.PixelConversionException ex) {
            return ex.getMessage();
        }
    }

    private APropertyNode getPropertiesHolder(APropertyNode node) {
        if (node.getValue() != null && node.getValue() instanceof JRPropertiesHolder) {
            return node;
        }
        if (node instanceof IPropertiesHolder) {
            return ((IPropertiesHolder)((Object)node)).getPropertiesHolder();
        }
        return null;
    }

    private void absoluteResize() {
        block13: {
            String value;
            MeasureUnit unit;
            String text = this.insertField.getText().trim().toLowerCase();
            String key = this.getMeasureUnit(text);
            if (key == null) {
                unit = this.getDefaultMeasure();
                value = text;
            } else {
                unit = unitsMap.get(Unit.getKeyFromAlias(key));
                value = text.substring(0, text.indexOf(key));
            }
            if (unit != null) {
                this.setLocalValue(unit.getKeyName());
                try {
                    Integer newValue;
                    AbstractJSSCellEditorValidator validator;
                    JSSCompoundCommand commands = new JSSCompoundCommand(this.section.getElement());
                    String convertedValue = unit.doConversionFromThis(unitsMap.get("pixel"), value);
                    if (this.jConfig != null && ((Boolean)Misc.nvl((Object)this.jConfig.getPropertyBoolean("com.jaspersoft.studio.unit.keep.unit"), (Object)true)).booleanValue()) {
                        for (APropertyNode item : this.section.getElements()) {
                            JRPropertiesMap pmap;
                            APropertyNode pholder = this.getPropertiesHolder(item);
                            if (pholder == null || (pmap = (JRPropertiesMap)pholder.getPropertyValue("PROPERTY_MAP")) == null || !this.setLocalValue(pmap, unit.getUnitName())) continue;
                            SetValueCommand cmd = new SetValueCommand();
                            cmd.setTarget(pholder);
                            cmd.setPropertyId("PROPERTY_MAP");
                            cmd.setPropertyValue(pmap);
                            commands.add(cmd);
                        }
                    }
                    if ((validator = ((PixelPropertyDescriptor)this.pDescriptor).getValidator()) != null) {
                        newValue = this.getIntegerValue(convertedValue);
                        String errorMessage = null;
                        for (APropertyNode item : this.section.getElements()) {
                            validator.setTargetNode(item);
                            errorMessage = validator.isValid(newValue);
                            if (errorMessage != null) break;
                            Command changeCommand = this.section.getChangePropertyCommand(((PixelPropertyDescriptor)this.pDescriptor).getId(), newValue, item);
                            if (changeCommand == null) continue;
                            commands.add(changeCommand);
                        }
                        validator.setTargetNode(this.section.getElement());
                        if (errorMessage != null) {
                            this.setErrorStatus(errorMessage);
                        } else {
                            this.section.runCommand(commands);
                            this.clearErrorStatus();
                        }
                        break block13;
                    }
                    newValue = this.getIntegerValue(convertedValue);
                    this.section.changeProperty(((PixelPropertyDescriptor)this.pDescriptor).getId(), newValue, commands.getCommands());
                    this.clearErrorStatus();
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorStatus(Messages.common_this_is_not_an_integer_number);
                }
                catch (Unit.PixelConversionException ex) {
                    this.setErrorStatus(ex.getMessage());
                }
            } else {
                this.setErrorStatus(Messages.SPPixel_errorMeasureUnit);
            }
        }
    }

    protected void clearErrorStatus() {
        Object currentValue = this.section.getElement().getPropertyActualValue(((PixelPropertyDescriptor)this.pDescriptor).getId());
        this.setData(this.section.getElement(), currentValue);
        this.insertField.setBackground(null);
        this.insertField.setToolTipText(this.getTooltip());
    }

    private String getTooltip() {
        Object obj;
        String t = ((PixelPropertyDescriptor)this.pDescriptor).getDescription();
        if (this.pnode != null && (obj = this.pnode.getPropertyValue(((PixelPropertyDescriptor)this.pDescriptor).getId())) != null) {
            t = obj + " px\n" + t;
        }
        return t;
    }

    protected void setErrorStatus(String message) {
        if (message != null) {
            this.insertField.setBackground(ColorConstants.red);
            this.insertField.setToolTipText(message);
        } else {
            this.insertField.setBackground(null);
            this.insertField.setToolTipText(this.getTooltip());
        }
    }

    private Integer getIntegerValue(String valueText) {
        if (valueText != null && !valueText.trim().isEmpty()) {
            return (int)Math.round(Double.parseDouble(valueText)) - this.getPixelOffset();
        }
        return null;
    }

    private void updateValue() {
        if (this.insertField.getText().contains("%")) {
            this.percentageResize();
        } else {
            this.absoluteResize();
        }
    }

    protected MeasureUnit getDefaultMeasure() {
        MeasureUnit mu = null;
        mu = this.localValue != null && unitsMap.containsKey(this.localValue) ? unitsMap.get(this.localValue) : unitsMap.get(Unit.getKeyFromAlias(this.defaultValue));
        if (mu == null) {
            mu = units[0];
        }
        return mu;
    }

    public void setText(String value) {
        MeasureUnit defaultMeasure = this.getDefaultMeasure();
        this.setUUnit(value, "pixel");
        double dValue = this.uunit.getValue(defaultMeasure.getKeyName());
        this.insertField.setBackground(null);
        if (this.jConfig != null && ((Boolean)Misc.nvl((Object)this.jConfig.getPropertyBoolean("com.jaspersoft.studio.unit.keep.unit"), (Object)true)).booleanValue()) {
            this.insertField.setText(SPPixel.truncateDouble(dValue, defaultMeasure.getPrecision()).concat(" ".concat(defaultMeasure.getUnitName())));
        } else {
            this.insertField.setText(value.concat(" px"));
        }
        this.lastSetValue = this.insertField.getText();
    }

    public String getText() {
        String text = this.insertField.getText().trim().toLowerCase();
        String key = this.getMeasureUnit(text);
        MeasureUnit unit = unitsMap.get(Unit.getKeyFromAlias(key));
        if (unit != null) {
            String value = text.substring(0, text.indexOf(key));
            if (value.trim().isEmpty()) {
                return null;
            }
            this.setUUnit(value, unit.getKeyName());
            Double dValue = this.uunit.getValue("pixel");
            return String.valueOf(dValue.longValue());
        }
        return null;
    }

    private void setUUnit(String value, String u) {
        if (this.uunit == null) {
            this.uunit = new Unit(SPPixel.parseDouble(value), u);
        } else {
            this.uunit.setValue(SPPixel.parseDouble(value), u);
        }
    }

    private static double parseDouble(String v) {
        if ((v = v.replaceAll("[^-?\\d,\\.]++", "")).matches(".+\\.\\d+,\\d+$")) {
            return Double.parseDouble(v.replaceAll("\\.", "").replaceAll(",", "."));
        }
        if (v.matches(".+,\\d+\\.\\d+$")) {
            return Double.parseDouble(v.replaceAll(",", ""));
        }
        return Double.parseDouble(v.replaceAll(",", "."));
    }

    protected void setWidth(Composite parent, int chars) {
        int w = SPPixel.getCharWidth((Control)this.insertField) * chars;
        if (parent.getLayout() instanceof RowLayout) {
            RowData rd = new RowData();
            rd.width = w;
            this.insertField.setLayoutData((Object)rd);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData rd = new GridData();
            rd.widthHint = w;
            this.insertField.setLayoutData((Object)rd);
        }
    }

    protected void openPopupMenu() {
        if (this.jConfig != null && ((Boolean)Misc.nvl((Object)this.jConfig.getPropertyBoolean("com.jaspersoft.studio.unit.keep.unit"), (Object)true)).booleanValue()) {
            if (this.popUpMenu == null) {
                this.createPopupMenu();
            }
            if (!this.popUpMenu.isDisposed()) {
                if (this.popUpMenu.isVisible()) {
                    this.popUpMenu.setVisible(false);
                } else {
                    this.locatePopupMenu();
                    this.popUpMenu.setVisible(true);
                }
            }
        }
    }

    protected void locatePopupMenu() {
        Rectangle r;
        if (this.getControl() instanceof Composite) {
            r = ((Composite)this.getControl()).getClientArea();
        } else {
            r = this.getControl().getBounds();
            r.y = 0;
            r.x = 0;
        }
        Point loc = this.getControl().toDisplay(r.x, r.y);
        loc.y += r.height;
        this.popUpMenu.setLocation(loc);
    }

    protected void createPopupMenu() {
        this.popUpMenu = new Menu((Control)this.insertField);
        int i = 0;
        while (i < units.length) {
            MeasureUnit key = units[i];
            MenuItem item = new MenuItem(this.popUpMenu, 8);
            item.setText(key.getUnitName());
            item.addSelectionListener((SelectionListener)new MenuAction(key.getKeyName()));
            ++i;
        }
    }

    private String getLocalValue() {
        APropertyNode pholder;
        Object node = this.section.getElement().getValue();
        if (node instanceof APropertyNode && (pholder = this.getPropertiesHolder((APropertyNode)node)) != null) {
            return PHolderUtil.getUnit((JRPropertiesHolder)pholder.getValue(), ((PixelPropertyDescriptor)this.pDescriptor).getId().toString(), null);
        }
        return null;
    }

    private boolean setLocalValue(String newLocal) {
        JRPropertiesMap nodeMap;
        APropertyNode pholder;
        APropertyNode node = this.section.getElement();
        if (node instanceof APropertyNode && (pholder = this.getPropertiesHolder(node)) != null && (nodeMap = (JRPropertiesMap)pholder.getPropertyValue("PROPERTY_MAP")) != null && this.setLocalValue(nodeMap, newLocal)) {
            SetValueCommand cmd = new SetValueCommand();
            cmd.setTarget(pholder);
            cmd.setPropertyId("PROPERTY_MAP");
            cmd.setPropertyValue(nodeMap);
            JSSCompoundCommand commands = new JSSCompoundCommand(pholder);
            commands.add(cmd);
            this.section.runCommand(commands);
            return true;
        }
        return false;
    }

    private boolean setLocalValue(JRPropertiesMap nodeMap, String newLocal) {
        this.localValue = newLocal;
        if (this.isLocalPersistent()) {
            String dunit = MReport.getMeasureUnit(this.jConfig, this.jConfig.getJasperDesign());
            return PHolderUtil.setProperty(false, nodeMap, ((PixelPropertyDescriptor)this.pDescriptor).getId().toString(), newLocal, dunit);
        }
        return false;
    }

    @Override
    protected void createComponent(Composite parent) {
        int tstyle = 2048;
        if (this.pDescriptor instanceof PixelPropertyDescriptor && ((PixelPropertyDescriptor)this.pDescriptor).isReadOnly()) {
            tstyle |= 8;
        }
        this.insertField = new Text(parent, tstyle){
            private Color ownBackgroundColor;

            protected void checkSubclass() {
            }

            public void setBackground(Color color) {
                if (!ModelUtils.safeEquals(color, this.ownBackgroundColor) || color == null) {
                    if (this.isFocusControl() && UIUtil.isMacAndEclipse4()) {
                        this.setEnabled(false);
                        super.setBackground(color);
                        this.setEnabled(true);
                        this.setFocus();
                    } else {
                        super.setBackground(color);
                    }
                    this.ownBackgroundColor = color;
                }
            }
        };
        if (UIUtil.isMacAndEclipse4()) {
            this.insertField.addModifyListener(e -> {
                this.editHappened = true;
                this.lastSetText = this.insertField.getText();
            });
        }
        this.insertField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    SPPixel.this.updateValue();
                }
            }
        });
        this.insertField.addMouseListener((MouseListener)new MouseClickListener());
        this.insertField.setToolTipText(this.getTooltip());
        new AutoCompleteField((Control)this.insertField, (IControlContentAdapter)new AutoCompleteMeasure(), autocompleteValues);
        this.setWidth(parent, 10);
        UIUtils.getDisplay().asyncExec(() -> {
            IPropertyChangeListener listener = event -> {
                if (event.getProperty().equals("com.jaspersoft.studio.unit.keep.unit")) {
                    this.refresh();
                }
            };
            this.jConfig.getPrefStore().addPropertyChangeListener(listener);
            this.insertField.addDisposeListener(e -> this.jConfig.getPrefStore().removePropertyChangeListener(listener));
        });
    }

    public void setDataNumber(Number f) {
        if (f != null) {
            int oldpos = this.insertField.getCaretPosition();
            this.setText(f.toString());
            if (this.insertField.getText().length() >= oldpos) {
                this.insertField.setSelection(oldpos, oldpos);
            }
        } else {
            this.insertField.setText("");
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        this.pnode = pnode;
        this.createContextualMenu(pnode);
        this.insertField.setEnabled(pnode.isEditable());
        if (this.jConfig != null && ((Boolean)Misc.nvl((Object)this.jConfig.getPropertyBoolean("com.jaspersoft.studio.unit.keep.unit"), (Object)true)).booleanValue()) {
            this.defaultValue = MReport.getMeasureUnit(this.jConfig, this.jConfig.getJasperDesign());
            APropertyNode pholder = this.getPropertiesHolder(pnode);
            if (pholder != null) {
                this.localValue = PHolderUtil.getUnit((JRPropertiesHolder)pholder.getValue(), ((PixelPropertyDescriptor)this.pDescriptor).getId().toString(), this.defaultValue);
            }
        } else {
            this.defaultValue = "px";
        }
        Integer n = value != null ? Integer.valueOf(Integer.parseInt(value.toString()) + this.getPixelOffset()) : null;
        this.setDataNumber(n);
        String errorMessage = this.getErrorMessages();
        this.setErrorStatus(errorMessage);
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        this.setData(pnode, resolvedValue);
        if (this.insertField != null && !this.insertField.isDisposed()) {
            if (elementValue != null) {
                this.insertField.setForeground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_FOREGROUND"));
                this.insertField.setToolTipText(this.getTooltip());
                if (this.getLabel() != null) {
                    this.getLabel().setToolTipText(((PixelPropertyDescriptor)this.pDescriptor).getDescription());
                    this.getLabel().setForeground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_FOREGROUND"));
                }
            } else {
                this.insertField.setForeground(UIUtils.INHERITED_COLOR);
                this.insertField.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.getTooltip());
                if (this.getLabel() != null) {
                    this.getLabel().setToolTipText(String.valueOf(Messages.common_inherited_attribute) + ((PixelPropertyDescriptor)this.pDescriptor).getDescription());
                    this.getLabel().setForeground(UIUtils.INHERITED_COLOR);
                }
            }
        }
    }

    public boolean isLocalPersistent() {
        return (this.style & 2) == 2;
    }

    @Override
    public Control getControl() {
        return this.insertField;
    }

    protected int getPixelOffset() {
        return 0;
    }

    private class AutoCompleteMeasure
    extends TextContentAdapter {
        private AutoCompleteMeasure() {
        }

        public String getControlContents(Control control) {
            String text = SPPixel.this.insertField.getText().trim().toLowerCase();
            String measureUnit = SPPixel.this.getMeasureUnit(text);
            if (SPPixel.this.insertField.getCaretPosition() == text.length() && measureUnit != null) {
                return measureUnit;
            }
            return "";
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            String textField = SPPixel.this.insertField.getText().trim().toLowerCase();
            String key = SPPixel.this.getMeasureUnit(textField);
            String value = textField.substring(0, textField.indexOf(key));
            ((Text)control).setText(value.concat(text));
            ((Text)control).setSelection(cursorPosition, cursorPosition);
        }
    }

    public static class MeasureUnit {
        private String unitName;
        private String keyName;
        private int precision;

        public MeasureUnit(String unitName) {
            this(unitName, unitName, 2);
        }

        public MeasureUnit(String keyName, String unitName, int precision) {
            this.unitName = unitName;
            this.keyName = keyName;
            this.precision = precision;
        }

        public int getPrecision() {
            return this.precision;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }

        public String doConversionFromThis(MeasureUnit targetUnit, String value) throws Unit.PixelConversionException {
            if (value == null || value.isEmpty()) {
                return null;
            }
            return String.valueOf(new Unit(SPPixel.parseDouble(value), this.keyName).getValue(targetUnit.getKeyName()));
        }
    }

    private class MenuAction
    extends SelectionAdapter {
        private String value;

        public MenuAction(String value) {
            this.value = value;
        }

        public void widgetSelected(SelectionEvent e) {
            String pixelValue = SPPixel.this.getText();
            SPPixel.this.setLocalValue(this.value);
            SPPixel.this.setText(pixelValue);
        }
    }

    private class MouseClickListener
    extends MouseAdapter {
        private MouseClickListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            String measureUnitAlias = SPPixel.this.insertField.getSelectionText().trim().toLowerCase();
            String measureUnitName = Unit.getKeyFromAlias(measureUnitAlias);
            if (measureUnitName != null) {
                SPPixel.this.openPopupMenu();
            }
        }
    }
}

