/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPRWCombo<T extends IPropertyDescriptor>
extends ASPropertyWidget<T> {
    protected CCombo combo;
    protected APropertyNode pnode;
    protected boolean refresh = false;

    public SPRWCombo(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    protected void createComponent(Composite parent) {
        this.combo = new CCombo(parent, 0x800800){

            protected void checkSubclass() {
            }

            public void setLayoutData(Object layoutData) {
                Object newData = layoutData;
                if (newData instanceof GridData) {
                    GridData newGridData = (GridData)newData;
                    if (newGridData.grabExcessHorizontalSpace && newGridData.horizontalAlignment == 4 && newGridData.widthHint == -1) {
                        int w = SPRWCombo.getCharWidth((Control)this) * 15;
                        if (w > 50) {
                            w = 50;
                        }
                        newGridData.widthHint = w;
                    }
                }
                super.setLayoutData(newData);
            }
        };
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData();
            gd.minimumWidth = 100;
            this.combo.setLayoutData((Object)gd);
        }
        this.setNewItems((RWComboBoxPropertyDescriptor)this.pDescriptor);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SPRWCombo.this.refresh) {
                    return;
                }
                if (SPRWCombo.this.combo.getSelectionIndex() >= 0) {
                    SPRWCombo.this.section.changeProperty(SPRWCombo.this.pDescriptor.getId(), SPRWCombo.this.combo.getItem(SPRWCombo.this.combo.getSelectionIndex()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SPRWCombo.this.refresh) {
                    return;
                }
                SPRWCombo.this.section.changeProperty(SPRWCombo.this.pDescriptor.getId(), SPRWCombo.this.combo.getText());
            }
        });
        this.combo.setToolTipText(this.pDescriptor.getDescription());
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        if (elementValue == null) {
            this.combo.setForeground(UIUtils.INHERITED_COLOR);
            this.combo.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
            if (this.getLabel() != null) {
                this.getLabel().setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
                this.getLabel().setForeground(UIUtils.INHERITED_COLOR);
            }
        } else {
            this.combo.setForeground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_FOREGROUND"));
            this.combo.setToolTipText(this.pDescriptor.getDescription());
            if (this.getLabel() != null) {
                this.getLabel().setToolTipText(this.pDescriptor.getDescription());
                this.getLabel().setForeground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_FOREGROUND"));
            }
        }
        this.setData(pnode, resolvedValue);
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.createContextualMenu(pnode);
        this.refresh = true;
        this.pnode = pnode;
        RWComboBoxPropertyDescriptor pd = (RWComboBoxPropertyDescriptor)this.pDescriptor;
        String str = (String)b;
        this.setComboSelection(str, pd.isCaseSensitive());
        this.combo.setEnabled(pnode.isEditable());
        this.refresh = false;
    }

    protected void setComboSelection(String str, boolean isCaseSensitive) {
        Point oldSel = this.combo.getSelection();
        int oldLenght = this.combo.getText().length();
        String[] items = this.combo.getItems();
        int selection = -1;
        int i = 0;
        while (i < items.length) {
            if (Misc.compare((String)items[i], (String)str, (boolean)isCaseSensitive)) {
                selection = i;
                break;
            }
            ++i;
        }
        if (selection != -1) {
            this.combo.select(selection);
            this.combo.setText(items[selection]);
        } else {
            this.combo.setText(Misc.nvl((String)str));
        }
        String t = this.combo.getText();
        if (oldSel.y - oldSel.x == t.length()) {
            int stringLength = t.length();
            this.combo.setSelection(new Point(stringLength, stringLength));
        } else {
            int stringLength = Math.min(t.length() - (oldLenght - oldSel.y), t.length());
            this.combo.setSelection(new Point(stringLength, stringLength));
        }
        this.combo.getParent().layout(true);
    }

    public String[] getItems() {
        return this.combo.getItems();
    }

    public void setNewItems(RWComboBoxPropertyDescriptor pd) {
        this.refresh = true;
        String[] newItems = pd.getItems();
        if (!ModelUtils.safeEquals(newItems, this.combo.getItems())) {
            String oldSelection = this.combo.getText();
            this.combo.setItems(newItems);
            this.setComboSelection(oldSelection, pd.isCaseSensitive());
        }
        this.refresh = false;
    }
}

