/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPText;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPResourceType<T extends IPropertyDescriptor>
extends SPText<T> {
    private Button btn;

    public SPResourceType(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
        this.btn.setEnabled(!readonly);
    }

    protected SelectionAdapter buttonPressed() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile file;
                FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(SPResourceType.this.ftext.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle(Messages.ResourceCellEditor_open_resource);
                dialog.setInitialPattern("*.properties");
                if (dialog.open() == 0 && (file = (IFile)dialog.getFirstResult()) != null) {
                    SPResourceType.this.handleTextChanged(SPResourceType.this.section, SPResourceType.this.pDescriptor.getId(), SPResourceType.this.convertFile2Value(file));
                }
            }
        };
    }

    @Override
    protected int getStyle() {
        return 2048;
    }

    @Override
    protected void createComponent(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        super.createComponent(container);
        GridData textData = new GridData(768);
        textData.minimumWidth = 50;
        this.ftext.setLayoutData(textData);
        this.btn = this.section.getWidgetFactory().createButton(container, "...", 8);
        this.btn.addSelectionListener((SelectionListener)this.buttonPressed());
    }

    protected String convertFile2Value(IFile f) {
        return f.getProjectRelativePath().toOSString();
    }

    @Override
    public Control getControl() {
        return this.btn.getParent();
    }

    @Override
    protected void handleTextChanged(AbstractSection section, Object property, String text) {
        if (text != null && text.trim().isEmpty()) {
            text = null;
        }
        section.changeProperty(property, text);
    }
}

