/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.statistics.heartbeat;

import com.google.gson.Gson;
import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.statistics.UsageManager;
import com.jaspersoft.studio.statistics.heartbeat.CommunityLogin;
import com.jaspersoft.studio.statistics.heartbeat.CommunityLoginQRCodeDialog;
import com.jaspersoft.studio.statistics.messages.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class CommunityLoginDialog
extends Dialog {
    private static final String COMMUNITY_REGISTRATION_URL = "https://community.jaspersoft.com/register/";
    private static final String COMMUNITY_RECOVER_PASSWORD_URL = "https://community.jaspersoft.com/lostpassword/";
    private static final String DEFAULT_COMMUNITY_EULA_URL = "https://community.jaspersoft.com/policies/jss-eula/";
    private static final String WEB_LOGIN_VERIFICATION_URL = "https://heartbeat.cloud.jaspersoft.com/login.php";
    public static final int QUIT_JASPERSOFT_STUDIO_ID = 1;
    public static final int LOGIN_ID = 2;
    public static final int JOIN_COMMUNITY_ID = 3;
    public static final int USE_OFFLINE_LOGIN_ID = 4;
    private Composite body;
    private Text passwordTxt;
    private Text usernameTxt;
    private Button loginButton;
    private Button agreeCheckbox;
    private String userEmail = null;
    private String eulaURL = "https://community.jaspersoft.com/policies/jss-eula/";
    private String verificationCode = "";

    public CommunityLoginDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public CommunityLoginDialog(Shell parentShell, String eulaURL) {
        super(parentShell);
        this.setShellStyle(67696);
        if (eulaURL != null) {
            this.eulaURL = eulaURL;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.horizontalSpacing = 0;
        gl_container.verticalSpacing = 0;
        gl_container.marginWidth = 0;
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        Composite headerCmp = new Composite(container, 0);
        headerCmp.setLayout((Layout)new GridLayout(1, false));
        headerCmp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        headerCmp.setBackground(SWTResourceManager.getColor((int)1));
        Label headerLogo = new Label(headerCmp, 0);
        headerLogo.setAlignment(0x1000000);
        headerLogo.setImage(ResourceManager.getPluginImage((String)"com.jaspersoft.studio", (String)"resources/js_community_400.png"));
        headerLogo.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        Label sep1 = new Label(container, 258);
        sep1.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite bodyCmp = this.getDialogBody(container);
        bodyCmp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label sep2 = new Label(container, 0x1000102);
        GridData sep2GD = new GridData(4, 1024, true, false, 1, 1);
        sep2GD.verticalIndent = 20;
        sep2.setLayoutData((Object)sep2GD);
        return container;
    }

    public Composite getDialogBody(Composite parent) {
        this.body = new Composite(parent, 0);
        GridData bodyGD = new GridData(4, 4, true, true);
        this.body.setLayoutData((Object)bodyGD);
        GridLayout bodyLayout = new GridLayout(2, false);
        bodyLayout.marginWidth = 20;
        this.body.setLayout((Layout)bodyLayout);
        int horizIndent = 0;
        int vertIndent = 20;
        Label welcomeLbl = new Label(this.body, 0);
        welcomeLbl.setText(Messages.CommunityLoginDialog_WelcomeMsg);
        welcomeLbl.setFont(SWTResourceManager.getBoldFont((Font)welcomeLbl.getFont()));
        GridData welcomeGD = new GridData(16384, 4, false, false, 2, 1);
        welcomeGD.verticalIndent = vertIndent;
        welcomeGD.horizontalIndent = horizIndent;
        welcomeLbl.setLayoutData((Object)welcomeGD);
        Label detailsLbl1 = new Label(this.body, 0);
        detailsLbl1.setText(Messages.CommunityLoginDialog_LoginInstructionsMsg);
        GridData details1GD = new GridData(16384, 4, false, false, 2, 1);
        details1GD.verticalIndent = vertIndent;
        details1GD.horizontalIndent = horizIndent;
        detailsLbl1.setLayoutData((Object)details1GD);
        Label usernameEmailLbl = new Label(this.body, 0);
        usernameEmailLbl.setText(Messages.CommunityLoginDialog_EmailLblTxt);
        GridData usernameEmailLblGD = new GridData(16384, 4, false, false, 2, 1);
        usernameEmailLblGD.verticalIndent = vertIndent;
        usernameEmailLblGD.horizontalIndent = horizIndent;
        usernameEmailLbl.setLayoutData((Object)usernameEmailLblGD);
        this.usernameTxt = new Text(this.body, 2048);
        this.usernameTxt.setText("");
        GridData usernameGD = new GridData(4, 4, true, false, 2, 1);
        usernameGD.widthHint = 500;
        usernameGD.heightHint = 20;
        usernameGD.horizontalIndent = horizIndent;
        this.usernameTxt.setLayoutData((Object)usernameGD);
        this.usernameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommunityLoginDialog.this.loginButton.setEnabled(CommunityLoginDialog.this.isLoginButtonEnabled());
            }
        });
        Label passwordLbl = new Label(this.body, 0);
        passwordLbl.setText(Messages.CommunityLoginDialog_PasswordLblTxt);
        GridData passwordLblGD = new GridData(16384, 4, false, false, 2, 1);
        passwordLblGD.verticalIndent = vertIndent;
        passwordLblGD.horizontalIndent = horizIndent;
        passwordLbl.setLayoutData((Object)passwordLblGD);
        this.passwordTxt = new Text(this.body, 0x400800);
        this.passwordTxt.setText("");
        GridData passwordGD = new GridData(4, 4, true, false, 2, 1);
        passwordGD.widthHint = 500;
        passwordGD.heightHint = 20;
        passwordGD.horizontalIndent = horizIndent;
        this.passwordTxt.setLayoutData((Object)passwordGD);
        this.passwordTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommunityLoginDialog.this.loginButton.setEnabled(CommunityLoginDialog.this.isLoginButtonEnabled());
            }
        });
        Link forgotPasswd = new Link(this.body, 0);
        GridData forgotPasswdGD = new GridData(131072, 4, true, false, 2, 1);
        forgotPasswdGD.horizontalIndent = horizIndent;
        forgotPasswd.setLayoutData((Object)forgotPasswdGD);
        forgotPasswd.setText(Messages.CommunityLoginDialog_ForgotPasswordTxt);
        forgotPasswd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtils.openRawLink((String)CommunityLoginDialog.COMMUNITY_RECOVER_PASSWORD_URL);
            }
        });
        Link joinCommunity = new Link(this.body, 0);
        GridData joinCommunityGridData = new GridData(16384, 4, true, false, 2, 1);
        joinCommunityGridData.horizontalIndent = horizIndent;
        joinCommunityGridData.verticalIndent = vertIndent;
        joinCommunity.setLayoutData((Object)joinCommunityGridData);
        joinCommunity.setText(Messages.CommunityLoginDialog_NotCommunityMemberInfoMsg);
        joinCommunity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtils.openRawLink((String)CommunityLoginDialog.COMMUNITY_REGISTRATION_URL);
            }
        });
        this.agreeCheckbox = new Button(this.body, 32);
        GridData agreeCheckGD = new GridData(16384, 0x1000000, false, false);
        agreeCheckGD.horizontalIndent = horizIndent;
        agreeCheckGD.verticalIndent = vertIndent;
        this.agreeCheckbox.setLayoutData((Object)agreeCheckGD);
        this.agreeCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommunityLoginDialog.this.loginButton.setEnabled(CommunityLoginDialog.this.isLoginButtonEnabled());
            }
        });
        this.agreeCheckbox.setSelection(false);
        Link agreementLinks = new Link(this.body, 0);
        GridData agreementLinksGD = new GridData(16384, 0x1000000, true, false);
        agreementLinksGD.verticalIndent = vertIndent;
        agreementLinks.setLayoutData((Object)agreementLinksGD);
        agreementLinks.setText(NLS.bind((String)"I agree to the <a>{0}</a>", (Object)"End User License Agreement"));
        agreementLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("End User License Agreement".equals(e.text)) {
                    BrowserUtils.openRawLink((String)CommunityLoginDialog.this.eulaURL);
                }
            }
        });
        Label detailsLblNoInternet = new Label(this.body, 0);
        detailsLblNoInternet.setText(Messages.CommunityLoginDialog_NotInternetInfoMsg);
        GridData detailsLblNoInternetGD = new GridData(16384, 4, false, false, 2, 1);
        detailsLblNoInternetGD.verticalIndent = vertIndent;
        detailsLblNoInternetGD.horizontalIndent = horizIndent;
        detailsLblNoInternet.setLayoutData((Object)detailsLblNoInternetGD);
        return this.body;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.CommunityLoginDialog_QuitStudioButtonTxt, false);
        this.createButton(parent, 4, Messages.CommunityLoginDialog_AlternativeLoginMethodButtonTxt, false);
        this.loginButton = this.createButton(parent, 2, Messages.CommunityLoginDialog_LoginButtonTxt, true);
        this.loginButton.setEnabled(false);
    }

    protected void buttonPressed(int buttonId) {
        block12: {
            CommunityLoginQRCodeDialog d;
            int result;
            if (1 == buttonId) {
                this.cancelPressed();
            } else if (2 == buttonId) {
                String usernameString = this.usernameTxt.getText();
                String passwordString = this.passwordTxt.getText();
                if (StringUtils.isNullOrEmpty((String)usernameString.trim()) || StringUtils.isNullOrEmpty((String)passwordString.trim())) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.CommunityLoginDialog_ErrorDialogTitle, (String)Messages.CommunityLoginDialog_CredentialsEmptyError);
                } else {
                    try {
                        boolean verifyCredentials = CommunityLogin.INSTANCE.verifyCredentials(usernameString, passwordString);
                        if (verifyCredentials) {
                            this.setUserEmail(usernameString);
                            this.okPressed();
                            break block12;
                        }
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.CommunityLoginDialog_ErrorDialogTitle, (String)Messages.CommunityLoginDialog_CredentialsInvalidError);
                    }
                    catch (Exception e) {
                        UIUtils.showError((String)Messages.CommunityLoginDialog_GenericErrorMsg, (Throwable)e);
                    }
                }
            } else if (3 == buttonId) {
                BrowserUtils.openRawLink((String)COMMUNITY_REGISTRATION_URL);
            } else if (4 == buttonId && (result = (d = new CommunityLoginQRCodeDialog(this.getShell(), this.generateLoginUrl(), this.verificationCode)).open()) == 0) {
                this.setUserEmail(null);
                this.okPressed();
            }
        }
    }

    protected String getDialogTitle() {
        return Messages.CommunityLoginDialog_Title;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected boolean isResizable() {
        return true;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    private boolean isLoginButtonEnabled() {
        return !StringUtils.isNullOrEmpty((String)this.usernameTxt.getText().trim()) && !StringUtils.isNullOrEmpty((String)this.passwordTxt.getText().trim()) && this.agreeCheckbox.getSelection();
    }

    private String generateLoginUrl() {
        UsageManager usageManager = JaspersoftStudioPlugin.getInstance().getUsageManager();
        Properties props = usageManager.getInstallationProperties();
        props.setProperty("jss_installation_uuid", ConfigurationManager.getInstallationUUID());
        if (this.verificationCode.isEmpty()) {
            SecureRandom rand = new SecureRandom();
            int i = 0;
            while (i < 6) {
                this.verificationCode = String.valueOf(this.verificationCode) + rand.nextInt(10);
                ++i;
            }
        }
        props.setProperty("code", this.verificationCode);
        Gson gsonObj = new Gson();
        String json = gsonObj.toJson((Object)props);
        String encryptedString = "";
        try {
            encryptedString = this.encrypt(json);
            String url = "https://heartbeat.cloud.jaspersoft.com/login.php?token=" + URLEncoder.encode(encryptedString, Charset.forName("UTF-8"));
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encrypt(String msg) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecureRandom sr = new SecureRandom();
        byte[] keyBytes = new byte[32];
        sr.nextBytes(keyBytes);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
        byte[] ivBytes = new byte[cipher.getBlockSize()];
        sr.nextBytes(ivBytes);
        String ivPart = Base64.getEncoder().encodeToString(ivBytes);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(1, (Key)secretKey, iv);
        byte[] encryptedMessage = cipher.doFinal(msg.getBytes(StandardCharsets.UTF_8));
        String messagePart = Base64.getEncoder().encodeToString(encryptedMessage);
        Cipher encrypt = Cipher.getInstance("RSA");
        encrypt.init(1, this.loadPublicKey());
        byte[] encryptedKey = encrypt.doFinal(keyBytes);
        String keyPart = Base64.getEncoder().encodeToString(encryptedKey);
        return String.valueOf(messagePart) + "-" + keyPart + "-" + ivPart;
    }

    public PublicKey loadPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("public_key.der");
        byte[] keyBytes = is.readAllBytes();
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }
}

