/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view.text;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import com.jaspersoft.studio.property.color.chooser.ColorDialog;
import com.jaspersoft.studio.property.descriptor.color.ColorLabelProvider;
import com.jaspersoft.studio.style.view.text.BordersWidget;
import com.jaspersoft.studio.style.view.text.PreviewGenerator;
import com.jaspersoft.studio.style.view.text.TextStyle;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceCache;

public class TextStyleWizardPage
extends JSSHelpWizardPage {
    private TextStyle element = null;
    private Combo fontName;
    private Combo fontSize;
    private ToolItem bold;
    private ToolItem italic;
    private ToolItem underline;
    private ToolItem strikeTrought;
    private ToolItem leftHAlignment;
    private ToolItem rightHAlignment;
    private ToolItem centerHAlignment;
    private ToolItem justifiedHAlignment;
    private ToolItem topVAlignment;
    private ToolItem bottomVAlignment;
    private ToolItem middleVAlignment;
    private Text description;
    private ToolItem rotationNone;
    private ToolItem rotationUpsideDown;
    private ToolItem rotationLeft;
    private ToolItem rotationRight;
    private BordersWidget bordersWidget;
    private ToolItem forecolor;
    private ToolItem backcolor;
    private Button transparent;
    private Composite preview;
    private ColorLabelProvider colorLabelProvider = new ColorLabelProvider(null);
    private ResourceCache imagesCache = new ResourceCache();
    private boolean settingData = false;
    private Point previewDefaultSize = new Point(400, 50);
    private ModifyListener valueModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TextStyleWizardPage.this.refreshEvent();
        }
    };
    private SelectionAdapter valueSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TextStyleWizardPage.this.refreshEvent();
        }
    };
    private SelectionAdapter disableAllOtherButtons = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ToolItem selectedItem = (ToolItem)e.widget;
            ToolItem[] toolItemArray = selectedItem.getParent().getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                if (item != selectedItem) {
                    item.setSelection(false);
                }
                ++n2;
            }
            TextStyleWizardPage.this.refreshEvent();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshEvent() {
        TextStyleWizardPage textStyleWizardPage = this;
        synchronized (textStyleWizardPage) {
            if (!this.settingData && !this.fontSize.getText().isEmpty()) {
                this.updateStyle();
                this.refreshPreview();
            }
        }
    }

    protected TextStyleWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.TextStyleWizardPage_pageTitle);
        this.setDescription(Messages.TextStyleWizardPage_pageDescription);
    }

    protected TextStyleWizardPage(String pageName, TextStyle templateToOpen) {
        this(pageName);
        if (templateToOpen != null) {
            this.element = templateToOpen.clone();
            String text = this.element.getDescription();
            if (text == null || text.isEmpty()) {
                text = Messages.TextStyleView_sampleText;
            }
            this.element.setDescription(text);
        }
    }

    public void setElement(TextStyle element) {
        if (element != null) {
            this.element = element.clone();
            String text = this.element.getDescription();
            if (text == null || text.isEmpty()) {
                text = Messages.TextStyleView_sampleText;
            }
            this.element.setDescription(text);
            this.setData();
        }
    }

    public void createControl(Composite parent) {
        if (this.element == null) {
            this.element = this.createDefaultElement();
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite descriptionArea = new Composite(container, 0);
        descriptionArea.setLayout((Layout)new GridLayout(2, false));
        descriptionArea.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        new Label(descriptionArea, 0).setText(Messages.TextStyleView_sampleText);
        this.description = new Text(descriptionArea, 2048);
        this.description.setLayoutData((Object)new GridData(768));
        this.description.addModifyListener(this.valueModifyListener);
        Composite leftArea = new Composite(container, 0);
        leftArea.setLayout((Layout)new GridLayout(1, false));
        leftArea.setLayoutData((Object)new GridData(1808));
        Group fontAttributes = new Group(leftArea, 0);
        fontAttributes.setLayout((Layout)new GridLayout(1, false));
        fontAttributes.setLayoutData((Object)new GridData(1808));
        fontAttributes.setText(Messages.common_font);
        this.createFontSection((Composite)fontAttributes);
        this.createAlignments((Composite)fontAttributes);
        this.createRotation((Composite)fontAttributes);
        Group colorAttributes = new Group(leftArea, 0);
        colorAttributes.setLayout((Layout)new GridLayout(1, false));
        colorAttributes.setLayoutData((Object)new GridData(1808));
        colorAttributes.setText(Messages.ColorsSection_colorSectionTitle);
        this.createColors((Composite)colorAttributes);
        Composite rightArea = new Composite(container, 0);
        rightArea.setLayout((Layout)new GridLayout(1, false));
        rightArea.setLayoutData((Object)new GridData(1808));
        this.bordersWidget = new BordersWidget(rightArea, 0, this.element);
        this.bordersWidget.setLayoutData(new GridData(1808));
        this.bordersWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextStyleWizardPage.this.refreshPreview();
            }
        });
        Group previewArea = new Group(container, 0);
        previewArea.setText(Messages.TextStyleWizardPage_previewLabel);
        previewArea.setLayout((Layout)new GridLayout(1, false));
        previewArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.preview = new Composite((Composite)previewArea, 0);
        GridData previewData = new GridData();
        previewData.widthHint = this.previewDefaultSize.x;
        previewData.heightHint = this.previewDefaultSize.y;
        previewData.horizontalAlignment = 0x1000000;
        previewData.verticalAlignment = 4;
        previewData.grabExcessHorizontalSpace = true;
        previewData.grabExcessVerticalSpace = true;
        this.preview.setLayoutData((Object)previewData);
        previewArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TextStyleWizardPage.this.refreshPreview();
            }
        });
        this.setControl((Control)container);
        this.setData();
    }

    private void refreshPreview() {
        Rectangle bounds = this.preview.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        if (width < 1 || height < 1) {
            width = this.previewDefaultSize.x;
            height = this.previewDefaultSize.y;
        }
        this.preview.setBackgroundImage(this.imagesCache.getImage(PreviewGenerator.generatePreview(this.element, width, height, this.preview.getBackground().getRGB())));
    }

    public void dispose() {
        this.updateStyle();
        super.dispose();
        this.colorLabelProvider.dispose();
        this.imagesCache.dispose();
    }

    private void updateStyle() {
        JRFont font = this.element.getFont();
        font.setBold(Boolean.valueOf(this.bold.getSelection()));
        font.setItalic(Boolean.valueOf(this.italic.getSelection()));
        font.setUnderline(Boolean.valueOf(this.underline.getSelection()));
        font.setStrikeThrough(Boolean.valueOf(this.strikeTrought.getSelection()));
        font.setFontName(this.fontName.getText());
        String fontSizeText = this.fontSize.getText();
        font.setFontSize(StringUtils.safeParseAsFloat((String)fontSizeText));
        this.element.setHorizontalAlignmen(this.getHorizonltalAlignment());
        this.element.setVerticalAlignmen(this.getVerticalAlignment());
        this.element.setRotation(this.getRotation());
        this.element.setBackGround((AlfaRGB)this.backcolor.getData());
        this.element.setForeGround((AlfaRGB)this.forecolor.getData());
        this.element.setTransparent(this.transparent.getSelection());
        this.element.setDescription(this.description.getText());
    }

    private void createFontSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(2));
        this.fontName = new Combo(container, 0);
        this.fontName.setItems(FontUtils.stringToItems(TextStyleWizardPage.getFontNames()));
        this.fontName.setLayoutData((Object)new GridData(768));
        this.fontName.addModifyListener(this.valueModifyListener);
        this.fontSize = new Combo(container, 0);
        this.fontSize.setItems(ModelUtils.FONT_SIZES);
        this.fontSize.addModifyListener(this.valueModifyListener);
        Composite styleButtons = new Composite(container, 0);
        styleButtons.setLayout((Layout)new GridLayout(1, false));
        ToolBar bar = new ToolBar(styleButtons, 0);
        this.bold = new ToolItem(bar, 32);
        this.bold.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/edit-bold.png"));
        this.bold.addSelectionListener((SelectionListener)this.valueSelectionListener);
        this.italic = new ToolItem(bar, 32);
        this.italic.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/edit-italic.png"));
        this.italic.addSelectionListener((SelectionListener)this.valueSelectionListener);
        this.underline = new ToolItem(bar, 32);
        this.underline.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/edit-underline.png"));
        this.underline.addSelectionListener((SelectionListener)this.valueSelectionListener);
        this.strikeTrought = new ToolItem(bar, 32);
        this.strikeTrought.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/edit-strike.png"));
        this.strikeTrought.addSelectionListener((SelectionListener)this.valueSelectionListener);
    }

    private void createAlignments(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        new Label(container, 0).setText(Messages.AlignSection_common_align);
        ToolBar toolBar = new ToolBar(container, 8519744);
        this.leftHAlignment = new ToolItem(toolBar, 32);
        this.leftHAlignment.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/left_align.gif"));
        this.leftHAlignment.setToolTipText(Messages.TextStyleWizardPage_alignLeftTooltip);
        this.leftHAlignment.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        this.centerHAlignment = new ToolItem(toolBar, 32);
        this.centerHAlignment.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/center_align.gif"));
        this.centerHAlignment.setToolTipText(Messages.TextStyleWizardPage_alignCenterTooltip);
        this.centerHAlignment.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        this.rightHAlignment = new ToolItem(toolBar, 32);
        this.rightHAlignment.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/right_align.gif"));
        this.rightHAlignment.setToolTipText(Messages.TextStyleWizardPage_alignRightTooltip);
        this.rightHAlignment.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        this.justifiedHAlignment = new ToolItem(toolBar, 32);
        this.justifiedHAlignment.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/justified_align.gif"));
        this.justifiedHAlignment.setToolTipText(Messages.TextStyleWizardPage_justifyHTooltip);
        this.justifiedHAlignment.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        toolBar = new ToolBar(container, 8519744);
        this.topVAlignment = new ToolItem(toolBar, 32);
        this.topVAlignment.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment-top.png"));
        this.topVAlignment.setToolTipText(Messages.TextStyleWizardPage_alignTopTooltip);
        this.topVAlignment.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        this.middleVAlignment = new ToolItem(toolBar, 32);
        this.middleVAlignment.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment-middle.png"));
        this.middleVAlignment.setToolTipText(Messages.TextStyleWizardPage_alignMiddleTooltip);
        this.middleVAlignment.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        this.bottomVAlignment = new ToolItem(toolBar, 32);
        this.bottomVAlignment.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment.png"));
        this.bottomVAlignment.setToolTipText(Messages.TextStyleWizardPage_alignBottomTooltip);
        this.bottomVAlignment.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
    }

    private void createRotation(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(768));
        new Label(container, 0).setText(Messages.common_rotation);
        ToolBar toolBar = new ToolBar(container, 8519744);
        this.rotationNone = new ToolItem(toolBar, 32);
        this.rotationNone.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/text-direction-none.png"));
        this.rotationNone.setToolTipText(Messages.TextStyleWizardPage_rotationNoneTooltip);
        this.rotationNone.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        this.rotationLeft = new ToolItem(toolBar, 32);
        this.rotationLeft.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/text-direction-left.png"));
        this.rotationLeft.setToolTipText(Messages.TextStyleWizardPage_rotationLeftTooltip);
        this.rotationLeft.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        this.rotationRight = new ToolItem(toolBar, 32);
        this.rotationRight.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/text-direction-right.png"));
        this.rotationRight.setToolTipText(Messages.TextStyleWizardPage_rotationRightTooltip);
        this.rotationRight.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
        this.rotationUpsideDown = new ToolItem(toolBar, 32);
        this.rotationUpsideDown.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/text-direction-updown.png"));
        this.rotationUpsideDown.setToolTipText(Messages.TextStyleWizardPage_upsideDownTooltip);
        this.rotationUpsideDown.addSelectionListener((SelectionListener)this.disableAllOtherButtons);
    }

    private void createColors(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(768));
        new Label(container, 0).setText(Messages.common_forecolor);
        ToolBar toolBar = new ToolBar(container, 0x804040);
        toolBar.setBackground(parent.getBackground());
        this.forecolor = this.createColorButton(toolBar);
        toolBar.pack();
        new Label(container, 0).setText(Messages.common_backcolor);
        toolBar = new ToolBar(container, 0x804040);
        toolBar.setBackground(parent.getBackground());
        this.backcolor = this.createColorButton(toolBar);
        this.transparent = new Button(container, 32);
        this.transparent.setText(Messages.common_opaque);
        this.transparent.addSelectionListener((SelectionListener)this.valueSelectionListener);
    }

    private HorizontalTextAlignEnum getHorizonltalAlignment() {
        if (this.rightHAlignment.getSelection()) {
            return HorizontalTextAlignEnum.RIGHT;
        }
        if (this.centerHAlignment.getSelection()) {
            return HorizontalTextAlignEnum.CENTER;
        }
        if (this.justifiedHAlignment.getSelection()) {
            return HorizontalTextAlignEnum.JUSTIFIED;
        }
        return HorizontalTextAlignEnum.LEFT;
    }

    private void setHorizonltalAlignment() {
        HorizontalTextAlignEnum align = this.element.getHorizontalAlignmen();
        if (HorizontalTextAlignEnum.RIGHT.equals((Object)align)) {
            this.rightHAlignment.setSelection(true);
        } else if (HorizontalTextAlignEnum.CENTER.equals((Object)align)) {
            this.centerHAlignment.setSelection(true);
        } else if (HorizontalTextAlignEnum.JUSTIFIED.equals((Object)align)) {
            this.justifiedHAlignment.setSelection(true);
        } else {
            this.leftHAlignment.setSelection(true);
        }
    }

    private VerticalTextAlignEnum getVerticalAlignment() {
        if (this.middleVAlignment.getSelection()) {
            return VerticalTextAlignEnum.MIDDLE;
        }
        if (this.bottomVAlignment.getSelection()) {
            return VerticalTextAlignEnum.BOTTOM;
        }
        return VerticalTextAlignEnum.TOP;
    }

    private void setVerticalAlignment() {
        VerticalTextAlignEnum align = this.element.getVerticalAlignmen();
        if (VerticalTextAlignEnum.MIDDLE.equals((Object)align)) {
            this.middleVAlignment.setSelection(true);
        } else if (VerticalTextAlignEnum.BOTTOM.equals((Object)align)) {
            this.bottomVAlignment.setSelection(true);
        } else {
            this.topVAlignment.setSelection(true);
        }
    }

    private RotationEnum getRotation() {
        if (this.rotationLeft.getSelection()) {
            return RotationEnum.LEFT;
        }
        if (this.rotationRight.getSelection()) {
            return RotationEnum.RIGHT;
        }
        if (this.rotationUpsideDown.getSelection()) {
            return RotationEnum.UPSIDE_DOWN;
        }
        return RotationEnum.NONE;
    }

    private void setRotation() {
        RotationEnum align = this.element.getRotation();
        if (RotationEnum.LEFT.equals((Object)align)) {
            this.rotationLeft.setSelection(true);
        } else if (RotationEnum.RIGHT.equals((Object)align)) {
            this.rotationRight.setSelection(true);
        } else if (RotationEnum.UPSIDE_DOWN.equals((Object)align)) {
            this.rotationUpsideDown.setSelection(true);
        } else {
            this.rotationNone.setSelection(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setData() {
        TextStyleWizardPage textStyleWizardPage = this;
        synchronized (textStyleWizardPage) {
            this.settingData = true;
            JRFont font = this.element.getFont();
            this.fontName.setText(Misc.nvl((String)font.getOwnFontName()));
            this.fontSize.setText(Misc.nvl((Object)font.getOwnFontsize(), (String)""));
            this.bold.setSelection(font.isOwnBold().booleanValue());
            this.italic.setSelection(font.isOwnItalic().booleanValue());
            this.underline.setSelection(font.isOwnUnderline().booleanValue());
            this.strikeTrought.setSelection(font.isOwnStrikeThrough().booleanValue());
            this.description.setText(this.element.getDescription());
            this.setHorizonltalAlignment();
            this.setVerticalAlignment();
            this.setRotation();
            this.setColors();
            this.transparent.setSelection(this.element.isTransparent().booleanValue());
            this.bordersWidget.refresh();
            this.settingData = false;
        }
    }

    private void setColors() {
        AlfaRGB foreColor = this.element.getForeGround();
        this.forecolor.setData((Object)foreColor);
        this.forecolor.setImage(this.colorLabelProvider.getImage(foreColor));
        AlfaRGB backColor = this.element.getBackGround();
        this.backcolor.setData((Object)backColor);
        this.backcolor.setImage(this.colorLabelProvider.getImage(backColor));
    }

    private static List<String[]> getFontNames() {
        ArrayList<String[]> classes = new ArrayList<String[]>();
        ArrayList<String> elements = new ArrayList<String>();
        classes.add(elements.toArray(new String[elements.size()]));
        elements = new ArrayList();
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            elements.add(name);
            ++i;
        }
        classes.add(elements.toArray(new String[elements.size()]));
        return classes;
    }

    private TextStyle createDefaultElement() {
        TextStyle defaultTextStyle = new TextStyle();
        defaultTextStyle.setBackGround(AlfaRGB.getFullyOpaque(new RGB(255, 255, 255)));
        defaultTextStyle.setForeGround(AlfaRGB.getFullyOpaque(new RGB(0, 0, 0)));
        defaultTextStyle.setHorizontalAlignmen(HorizontalTextAlignEnum.LEFT);
        defaultTextStyle.setVerticalAlignmen(VerticalTextAlignEnum.TOP);
        defaultTextStyle.setTransparent(true);
        defaultTextStyle.setRotation(RotationEnum.NONE);
        JRBaseFont font = new JRBaseFont();
        font.setFontName("Arial");
        font.setFontSize(Float.valueOf(8.0f));
        font.setBold(Boolean.valueOf(false));
        font.setItalic(Boolean.valueOf(false));
        font.setUnderline(Boolean.valueOf(false));
        font.setStrikeThrough(Boolean.valueOf(false));
        defaultTextStyle.setFont((JRFont)font);
        JRBaseLineBox box = new JRBaseLineBox(null);
        box.setPadding(null);
        box.setTopPadding(Integer.valueOf(0));
        box.setBottomPadding(Integer.valueOf(0));
        box.setLeftPadding(Integer.valueOf(0));
        box.setRightPadding(Integer.valueOf(0));
        defaultTextStyle.setBorders((JRLineBox)box);
        defaultTextStyle.setDescription(Messages.TextStyleView_sampleText);
        return defaultTextStyle;
    }

    private ToolItem createColorButton(ToolBar toolBar) {
        final ToolItem button = new ToolItem(toolBar, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(button.getParent().getShell());
                cd.setText(Messages.TextStyleWizardPage_colorLabel);
                AlfaRGB rgb = (AlfaRGB)button.getData();
                cd.setRGB(rgb == null ? null : rgb);
                AlfaRGB newColor = cd.openAlfaRGB();
                if (newColor != null) {
                    button.setData((Object)newColor);
                    button.setImage(TextStyleWizardPage.this.colorLabelProvider.getImage(newColor));
                    TextStyleWizardPage.this.updateStyle();
                    TextStyleWizardPage.this.refreshPreview();
                }
            }
        });
        return button;
    }

    public TextStyle getStyle() {
        return this.element;
    }

    @Override
    protected String getContextName() {
        return null;
    }
}

