/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.binding;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DateTimeObservableValue
extends AbstractObservableValue {
    private final DateTime dateTime;
    protected Date oldValue;
    Listener listener = new Listener(){

        public void handleEvent(Event event) {
            Date newValue = DateTimeObservableValue.this.dateTimeToDate();
            if (!newValue.equals(DateTimeObservableValue.this.oldValue)) {
                DateTimeObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)DateTimeObservableValue.this.oldValue, (Object)newValue));
                DateTimeObservableValue.this.oldValue = newValue;
            }
        }
    };

    public DateTimeObservableValue(DateTime dateTime) {
        this.dateTime = dateTime;
        this.dateTime.addListener(13, this.listener);
    }

    protected Object doGetValue() {
        return this.dateTimeToDate();
    }

    protected void doSetValue(Object value) {
        if (value instanceof Date) {
            Date date = (Date)value;
            this.dateToDateTime(date);
        }
    }

    public Object getValueType() {
        return Date.class;
    }

    private void dateToDateTime(Date date) {
        if (!this.dateTime.isDisposed()) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.dateTime.setYear(cal.get(1));
            this.dateTime.setMonth(cal.get(2));
            this.dateTime.setDay(cal.get(5));
            this.dateTime.setHours(cal.get(11));
            this.dateTime.setMinutes(cal.get(12));
            this.dateTime.setSeconds(cal.get(13));
        }
    }

    private Date dateTimeToDate() {
        Date result = null;
        if (!this.dateTime.isDisposed()) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, this.dateTime.getYear());
            cal.set(2, this.dateTime.getMonth());
            cal.set(5, this.dateTime.getDay());
            cal.set(11, this.dateTime.getHours());
            cal.set(12, this.dateTime.getMinutes());
            cal.set(13, this.dateTime.getSeconds());
            result = cal.getTime();
        }
        return result;
    }

    public synchronized void dispose() {
        this.dateTime.removeListener(13, this.listener);
        super.dispose();
    }
}

