/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.wb.swt.SWTResourceManager;

public class CSashForm
extends SashForm {
    public static final int NO_HIDE_LEFT = 1;
    public static final int NO_HIDE_UP = 1;
    public static final int NO_HIDE_RIGHT = 2;
    public static final int NO_HIDE_DOWN = 2;
    private static final int NO_WEIGHT = -1;
    private static final int NO_ARROW = -1;
    protected SashInfo currentSashInfo = null;
    protected boolean inMouseClick = false;
    protected boolean[] sashBorders;
    protected boolean noHideUp;
    protected boolean noHideDown;
    protected List<ICustomSashFormListener> customSashFormListeners = null;
    protected static final int UP_RESTORE_ARROW = 0;
    protected static final int UP_HIDE_ARROW = 1;
    protected static final int DOWN_RESTORE_ARROW = 2;
    protected static final int DOWN_HIDE_ARROW = 3;
    protected static final int HIDE_ARROWS = 4;
    protected static final int ARROW_TYPE_INDEX = 0;
    protected static final int ARROW_DRAWN_INDEX = 1;
    protected static final int X_INDEX = 2;
    protected static final int Y_INDEX = 3;
    protected static final int WIDTH_INDEX = 4;
    protected static final int HEIGHT_INDEX = 5;
    protected static final int ARROW_WIDTH = 8;
    protected static final int ARROW_HEIGHT = 8;
    protected static final int ARROW_MARGIN = 3;
    private static Color arrowColor = SWTResourceManager.getColor((int)99, (int)101, (int)156);
    private static Color borderColor = SWTResourceManager.getColor((int)132, (int)130, (int)132);
    private static final int NOT_SLAMMED = 1;
    private static final int SLAMMED_TO_BOTTOM = 2;
    private static final int SLAMMED_TO_TOP = 3;

    public CSashForm(Composite parent, int style) {
        this(parent, style, 0);
    }

    public CSashForm(Composite parent, int style, int customStyle) {
        super(parent, style);
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                CSashForm.this.layout(true);
            }
        });
        this.noHideUp = (customStyle & 1) != 0;
        boolean bl = this.noHideDown = (customStyle & 2) != 0;
        if (this.noHideUp & this.noHideDown) {
            return;
        }
        this.SASH_WIDTH = 3 + this.getOrientation() == 512 ? 8 : 8;
    }

    public boolean isNoHideUp() {
        return this.noHideUp;
    }

    public boolean isNoHideDown() {
        return this.noHideDown;
    }

    public boolean isNoHideLeft() {
        return this.noHideUp;
    }

    public boolean isNoHideRight() {
        return this.noHideDown;
    }

    public void setNoHideUp(boolean bHide) {
        this.noHideUp = bHide;
    }

    public void setNoHideDown(boolean bHide) {
        this.noHideDown = bHide;
    }

    public void setNoHideLeft(boolean bHide) {
        this.setNoHideUp(bHide);
    }

    public void setNoHideRight(boolean bHide) {
        this.setNoHideDown(bHide);
    }

    public void hideUp() {
        if (this.noHideUp) {
            return;
        }
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
        this.upHideClicked(this.currentSashInfo);
    }

    public void hideLeft() {
        this.hideUp();
    }

    public void hideDown() {
        if (this.noHideDown) {
            return;
        }
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
        this.downHideClicked(this.currentSashInfo);
    }

    public void hideRight() {
        this.hideDown();
    }

    public void setSashBorders(boolean[] sashBorders) {
        int[] weights = this.getWeights();
        if (weights.length != 2 || sashBorders != null && sashBorders.length != 2) {
            SWT.error((int)5);
        }
        this.sashBorders = sashBorders;
    }

    public void layout(boolean changed) {
        super.layout(changed);
        if (this.noHideUp && this.noHideDown) {
            return;
        }
        if (this.getMaximizedControl() != null) {
            return;
        }
        Control[] children = this.getChildren();
        Sash newSash = null;
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Sash) {
                if (newSash == null) {
                    newSash = (Sash)children[i];
                } else {
                    return;
                }
            }
            ++i;
        }
        if (newSash == null) {
            return;
        }
        if (this.currentSashInfo == null || this.currentSashInfo.sash == null) {
            if (this.currentSashInfo == null) {
                this.currentSashInfo = new SashInfo(newSash);
            } else {
                this.currentSashInfo.sash = newSash;
            }
            newSash.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Color oldFg = gc.getForeground();
                    Color oldBg = gc.getBackground();
                    CSashForm.this.drawArrow(gc, CSashForm.this.currentSashInfo.sashLocs[0], CSashForm.this.currentSashInfo.cursorOver == 0);
                    if (CSashForm.this.currentSashInfo.sashLocs.length > 1) {
                        CSashForm.this.drawArrow(gc, CSashForm.this.currentSashInfo.sashLocs[1], CSashForm.this.currentSashInfo.cursorOver == 1);
                    }
                    if (CSashForm.this.currentSashInfo.sashBorderLeft) {
                        CSashForm.this.drawSashBorder(gc, CSashForm.this.currentSashInfo.sash, true);
                    }
                    if (CSashForm.this.currentSashInfo.sashBorderRight) {
                        CSashForm.this.drawSashBorder(gc, CSashForm.this.currentSashInfo.sash, false);
                    }
                    gc.setForeground(oldFg);
                    gc.setBackground(oldBg);
                }
            });
            newSash.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    CSashForm.this.recomputeSashInfo();
                }

                public void controlResized(ControlEvent e) {
                    CSashForm.this.recomputeSashInfo();
                }
            });
            newSash.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CSashForm.this.currentSashInfo = null;
                }
            });
            newSash.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    int x = e.x;
                    int y = e.y;
                    int i = 0;
                    while (i < CSashForm.this.currentSashInfo.sashLocs.length) {
                        int sizeIndex;
                        int[] locs = CSashForm.this.currentSashInfo.sashLocs[i];
                        boolean vertical = CSashForm.this.getOrientation() == 512;
                        int loc = vertical ? x : y;
                        int locIndex = vertical ? 2 : 3;
                        int n = sizeIndex = vertical ? 4 : 5;
                        if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                            if (CSashForm.this.currentSashInfo.cursorOver == -1) {
                                CSashForm.this.currentSashInfo.sash.setCursor(Cursors.ARROW);
                            }
                            if (CSashForm.this.currentSashInfo.cursorOver != i) {
                                CSashForm.this.currentSashInfo.cursorOver = i;
                                CSashForm.this.currentSashInfo.sash.redraw();
                                switch (locs[0]) {
                                    case 0: 
                                    case 2: {
                                        CSashForm.this.currentSashInfo.sash.setToolTipText("Restore");
                                        break;
                                    }
                                    case 1: 
                                    case 3: {
                                        CSashForm.this.currentSashInfo.sash.setToolTipText("Hide");
                                    }
                                }
                            }
                            return;
                        }
                        ++i;
                    }
                    if (CSashForm.this.currentSashInfo.cursorOver != -1) {
                        CSashForm.this.currentSashInfo.sash.setCursor(null);
                        CSashForm.this.currentSashInfo.cursorOver = -1;
                        CSashForm.this.currentSashInfo.sash.redraw();
                        CSashForm.this.currentSashInfo.sash.setToolTipText(null);
                    }
                }
            });
            newSash.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    if (CSashForm.this.currentSashInfo.cursorOver != -1) {
                        CSashForm.this.currentSashInfo.sash.setCursor(null);
                        CSashForm.this.currentSashInfo.cursorOver = -1;
                        CSashForm.this.currentSashInfo.sash.redraw();
                        CSashForm.this.currentSashInfo.sash.setToolTipText(null);
                    }
                }
            });
            newSash.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    CSashForm.this.inMouseClick = true;
                    int x = e.x;
                    int y = e.y;
                    int i = 0;
                    while (i < CSashForm.this.currentSashInfo.sashLocs.length) {
                        int sizeIndex;
                        int[] locs = CSashForm.this.currentSashInfo.sashLocs[i];
                        boolean vertical = CSashForm.this.getOrientation() == 512;
                        int loc = vertical ? x : y;
                        int locIndex = vertical ? 2 : 3;
                        int n = sizeIndex = vertical ? 4 : 5;
                        if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                            CSashForm.this.currentSashInfo.sash.redraw();
                            break;
                        }
                        ++i;
                    }
                }

                public void mouseUp(MouseEvent e) {
                    CSashForm.this.inMouseClick = false;
                    int x = e.x;
                    int y = e.y;
                    int i = 0;
                    while (i < CSashForm.this.currentSashInfo.sashLocs.length) {
                        int sizeIndex;
                        int[] locs = CSashForm.this.currentSashInfo.sashLocs[i];
                        boolean vertical = CSashForm.this.getOrientation() == 512;
                        int loc = vertical ? x : y;
                        int locIndex = vertical ? 2 : 3;
                        int n = sizeIndex = vertical ? 4 : 5;
                        if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                            switch (locs[0]) {
                                case 0: {
                                    CSashForm.this.upRestoreClicked(CSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 1: {
                                    CSashForm.this.upHideClicked(CSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 2: {
                                    CSashForm.this.downRestoreClicked(CSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 3: {
                                    CSashForm.this.downHideClicked(CSashForm.this.currentSashInfo);
                                }
                            }
                            break;
                        }
                        ++i;
                    }
                    CSashForm.this.currentSashInfo.sash.redraw();
                    CSashForm.this.fireDividerMoved();
                }
            });
            this.recomputeSashInfo();
        }
    }

    public void upRestore() {
        this.initSash();
        this.upRestoreClicked(this.currentSashInfo);
    }

    public void upHide() {
        this.initSash();
        this.upHideClicked(this.currentSashInfo);
    }

    public void downRestore() {
        this.initSash();
        this.downRestoreClicked(this.currentSashInfo);
    }

    public void downHide() {
        this.initSash();
        this.downHideClicked(this.currentSashInfo);
    }

    protected void initSash() {
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
    }

    protected void recomputeSashInfo() {
        if (this.inMouseClick && this.currentSashInfo.cursorOver != -1) {
            return;
        }
        int[] addArrows = null;
        int[] drawArrows = null;
        int[] weights = this.getWeights();
        Rectangle sashBounds = this.currentSashInfo.sash.getBounds();
        Rectangle clientArea = this.getClientArea();
        boolean vertical = this.getOrientation() == 512;
        int slammed = 1;
        if (weights[1] == 0) {
            slammed = 2;
        } else if (weights[0] == 0) {
            slammed = 3;
        } else if (vertical) {
            if (this.currentSashInfo.restoreWeight != -1 && sashBounds.y <= 20) {
                slammed = 3;
            } else if (this.currentSashInfo.restoreWeight != -1 && sashBounds.y + sashBounds.height >= clientArea.height - 20) {
                slammed = 2;
            }
        } else if (!vertical) {
            if (this.currentSashInfo.restoreWeight != -1 && sashBounds.x <= 20) {
                slammed = 3;
            } else if (this.currentSashInfo.restoreWeight != -1 && sashBounds.x + sashBounds.width >= clientArea.width - 20) {
                slammed = 2;
            }
        }
        if (this.noHideUp) {
            if (slammed == 2) {
                addArrows = new int[1];
                drawArrows = new int[1];
                addArrows[0] = 0;
                drawArrows[0] = 0;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = false;
            } else {
                addArrows = new int[1];
                drawArrows = new int[1];
                addArrows[0] = 3;
                drawArrows[0] = 2;
                this.currentSashInfo.restoreWeight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            }
        } else if (this.noHideDown) {
            if (slammed == 3) {
                addArrows = new int[1];
                drawArrows = new int[1];
                addArrows[0] = 2;
                drawArrows[0] = 2;
                this.currentSashInfo.sashBorderLeft = false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            } else {
                addArrows = new int[1];
                drawArrows = new int[1];
                addArrows[0] = 1;
                drawArrows[0] = 0;
                this.currentSashInfo.restoreWeight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            }
        } else if (slammed == 3) {
            addArrows = new int[1];
            drawArrows = new int[1];
            addArrows[0] = 2;
            drawArrows[0] = 2;
            this.currentSashInfo.sashBorderLeft = false;
            this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
        } else if (slammed == 2) {
            addArrows = new int[1];
            drawArrows = new int[1];
            addArrows[0] = 0;
            drawArrows[0] = 0;
            this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
            this.currentSashInfo.sashBorderRight = false;
        } else {
            addArrows = new int[2];
            drawArrows = new int[2];
            addArrows[0] = 1;
            drawArrows[0] = 0;
            addArrows[1] = 3;
            drawArrows[1] = 2;
            this.currentSashInfo.restoreWeight = -1;
            this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
            this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
        }
        this.getNewSashArray(this.currentSashInfo, addArrows, drawArrows);
        this.currentSashInfo.sash.redraw();
    }

    protected void upRestoreClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        weights[0] = 1000 - sashinfo.restoreWeight;
        weights[1] = sashinfo.restoreWeight;
        sashinfo.restoreWeight = -1;
        if (weights[1] >= 0) {
            this.setWeights(weights);
        }
        this.fireDividerMoved();
    }

    protected void upHideClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        if (this.currentSashInfo.restoreWeight == -1) {
            this.currentSashInfo.restoreWeight = weights[1];
            this.saveChildControlSizes();
        }
        weights[0] = 0;
        weights[1] = 1000;
        Control[] children = this.getChildren();
        boolean upperFocus = this.isFocusAncestorA(children[0]);
        this.setWeights(weights);
        if (upperFocus) {
            children[1].setFocus();
        }
        this.fireDividerMoved();
    }

    protected void downRestoreClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        weights[0] = 1000 - sashinfo.restoreWeight;
        weights[1] = sashinfo.restoreWeight;
        sashinfo.restoreWeight = -1;
        this.setWeights(weights);
        this.fireDividerMoved();
    }

    protected void downHideClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        if (this.currentSashInfo.restoreWeight == -1) {
            this.currentSashInfo.restoreWeight = weights[1];
            this.saveChildControlSizes();
        }
        weights[0] = 1000;
        weights[1] = 0;
        Control[] children = this.getChildren();
        boolean lowerFocus = this.isFocusAncestorA(children[1]);
        this.setWeights(weights);
        if (lowerFocus) {
            children[0].setFocus();
        }
        this.fireDividerMoved();
    }

    private void saveChildControlSizes() {
        Control[] children = this.getChildren();
        int iChildToSave = 0;
        int i = 0;
        while (i < children.length && iChildToSave < 2) {
            Control child = children[i];
            if (!(child instanceof Sash)) {
                this.currentSashInfo.savedSizes[iChildToSave] = child.getSize();
                ++iChildToSave;
            }
            ++i;
        }
    }

    protected boolean isFocusAncestorA(Control control) {
        Display display = this.getDisplay();
        Control focusControl = display.getFocusControl();
        while (focusControl != null && focusControl != control) {
            focusControl = focusControl.getParent();
        }
        return control == focusControl;
    }

    protected void getNewSashArray(SashInfo sashInfo, int[] addArrowTypes, int[] drawArrowTypes) {
        int[][] thisSash = sashInfo.sashLocs = (int[][])new int[addArrowTypes.length][];
        int aSize = 8;
        int tSize = aSize + 6;
        int neededSize = tSize * addArrowTypes.length;
        boolean vertical = this.getOrientation() == 512;
        Point s = sashInfo.sash.getSize();
        int start = 0;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (vertical) {
            x = start = (s.x - neededSize) / 2;
            y = (s.y - 8) / 2;
            width = tSize;
            height = aSize;
        } else {
            y = start = (s.y - neededSize) / 2;
            x = (s.x - 8) / 2;
            width = aSize;
            height = tSize;
        }
        int j = 0;
        while (j < addArrowTypes.length) {
            if (thisSash[j] == null) {
                thisSash[j] = new int[]{addArrowTypes[j], drawArrowTypes[j], x, y, width, height};
            } else {
                thisSash[j][0] = addArrowTypes[j];
                thisSash[j][1] = drawArrowTypes[j];
                thisSash[j][2] = x;
                thisSash[j][3] = y;
                thisSash[j][4] = width;
                thisSash[j][5] = height;
            }
            if (vertical) {
                x += tSize;
            } else {
                y += tSize;
            }
            ++j;
        }
    }

    protected void drawSashBorder(GC gc, Sash sash, boolean leftBorder) {
        gc.setForeground(borderColor);
        if (this.getOrientation() == 512) {
            Point s = sash.getSize();
            if (leftBorder) {
                gc.drawLine(0, 0, s.x - 1, 0);
            } else {
                gc.drawLine(0, s.y - 1, s.x - 1, s.y - 1);
            }
        } else {
            Point s = sash.getSize();
            if (leftBorder) {
                gc.drawLine(0, 0, 0, s.y - 1);
            } else {
                gc.drawLine(s.x - 1, 0, s.x - 1, s.y - 1);
            }
        }
    }

    protected void drawArrow(GC gc, int[] sashLoc, boolean selected) {
        int indent = 0;
        if (selected) {
            if (!this.inMouseClick) {
                Color highlightShadow = this.getDisplay().getSystemColor(20);
                Color normalShadow = this.getDisplay().getSystemColor(18);
                gc.setForeground(highlightShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2], sashLoc[3]);
                gc.drawLine(sashLoc[2], sashLoc[3], sashLoc[2] + sashLoc[4], sashLoc[3]);
                gc.setForeground(normalShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2] + sashLoc[4], sashLoc[3] + sashLoc[5]);
                gc.drawLine(sashLoc[2] + sashLoc[4], sashLoc[3] + sashLoc[5], sashLoc[2] + sashLoc[4], sashLoc[3]);
            } else {
                indent = 1;
                Color highlightShadow = this.getDisplay().getSystemColor(20);
                Color normalShadow = this.getDisplay().getSystemColor(18);
                gc.setForeground(normalShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2], sashLoc[3]);
                gc.drawLine(sashLoc[2], sashLoc[3], sashLoc[2] + sashLoc[4], sashLoc[3]);
                gc.setForeground(highlightShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2] + sashLoc[4], sashLoc[3] + sashLoc[5]);
                gc.drawLine(sashLoc[2] + sashLoc[4], sashLoc[3] + sashLoc[5], sashLoc[2] + sashLoc[4], sashLoc[3]);
            }
        }
        if (this.getOrientation() == 512) {
            switch (sashLoc[1]) {
                case 0: {
                    this.drawUpRestoreArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 2: {
                    this.drawDownRestoreArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 1: {
                    this.drawUpHideArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 3: {
                    this.drawDownHideArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                }
            }
        } else {
            switch (sashLoc[1]) {
                case 0: {
                    this.drawLeftRestoreArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 2: {
                    this.drawRightRestoreArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 1: {
                    this.drawLeftHideArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 3: {
                    this.drawRightHideArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                }
            }
        }
    }

    protected void drawUpRestoreArrow(GC gc, int x, int y) {
        gc.setForeground(arrowColor);
        gc.drawLine((x += 3) + 4, y + 2, x + 7, y + 5);
        gc.drawLine(x + 3, y + 2, x + 3, y + 2);
        gc.drawLine(x + 2, y + 3, x + 4, y + 3);
        gc.drawLine(x + 1, y + 4, x + 5, y + 4);
        gc.drawLine(x, y + 5, x + 6, y + 5);
    }

    protected void drawUpHideArrow(GC gc, int x, int y) {
        gc.setForeground(arrowColor);
        gc.drawLine(x += 3, y, x + 7, y);
        gc.drawLine(x, y + 1, x + 7, y + 1);
        gc.drawLine(x + 4, y + 2, x + 7, y + 5);
        gc.drawLine(x + 3, y + 2, x + 3, y + 2);
        gc.drawLine(x + 2, y + 3, x + 4, y + 3);
        gc.drawLine(x + 1, y + 4, x + 5, y + 4);
        gc.drawLine(x, y + 5, x + 6, y + 5);
    }

    protected void drawDownRestoreArrow(GC gc, int x, int y) {
        gc.setForeground(arrowColor);
        gc.drawLine(x += 3, y + 2, x + 3, y + 5);
        gc.drawLine(x + 4, y + 5, x + 4, y + 5);
        gc.drawLine(x + 3, y + 4, x + 5, y + 4);
        gc.drawLine(x + 1, y + 3, x + 6, y + 3);
        gc.drawLine(x + 1, y + 2, x + 7, y + 2);
    }

    protected void drawDownHideArrow(GC gc, int x, int y) {
        gc.setForeground(arrowColor);
        gc.drawLine(x += 3, y + 6, x + 7, y + 6);
        gc.drawLine(x, y + 7, x + 7, y + 7);
        gc.drawLine(x, y + 2, x + 3, y + 5);
        gc.drawLine(x + 4, y + 5, x + 4, y + 5);
        gc.drawLine(x + 3, y + 4, x + 5, y + 4);
        gc.drawLine(x + 1, y + 3, x + 6, y + 3);
        gc.drawLine(x + 1, y + 2, x + 7, y + 2);
    }

    protected void drawLeftRestoreArrow(GC gc, int x, int y) {
        gc.setForeground(arrowColor);
        gc.drawLine(x + 2, (y += 3) + 4, x + 5, y + 7);
        gc.drawLine(x + 2, y + 3, x + 2, y + 3);
        gc.drawLine(x + 3, y + 2, x + 3, y + 4);
        gc.drawLine(x + 4, y + 1, x + 4, y + 5);
        gc.drawLine(x + 5, y, x + 5, y + 6);
    }

    protected void drawLeftHideArrow(GC gc, int x, int y) {
        gc.setForeground(arrowColor);
        gc.drawLine(x, y += 3, x, y + 7);
        gc.drawLine(x + 1, y, x + 1, y + 7);
        gc.drawLine(x + 2, y + 4, x + 5, y + 7);
        gc.drawLine(x + 2, y + 3, x + 2, y + 3);
        gc.drawLine(x + 3, y + 2, x + 3, y + 4);
        gc.drawLine(x + 4, y + 1, x + 4, y + 5);
        gc.drawLine(x + 5, y, x + 5, y + 6);
    }

    protected void drawRightRestoreArrow(GC gc, int x, int y) {
        gc.setForeground(arrowColor);
        gc.drawLine(x + 2, y += 3, x + 5, y + 3);
        gc.drawLine(x + 5, y + 4, x + 5, y + 4);
        gc.drawLine(x + 4, y + 3, x + 4, y + 5);
        gc.drawLine(x + 3, y + 1, x + 3, y + 6);
        gc.drawLine(x + 2, y + 1, x + 2, y + 7);
    }

    protected void drawRightHideArrow(GC gc, int x, int y) {
        gc.setForeground(arrowColor);
        gc.drawLine(x + 6, y += 3, x + 6, y + 7);
        gc.drawLine(x + 7, y, x + 7, y + 7);
        gc.drawLine(x + 2, y, x + 5, y + 3);
        gc.drawLine(x + 5, y + 4, x + 5, y + 4);
        gc.drawLine(x + 4, y + 3, x + 4, y + 5);
        gc.drawLine(x + 3, y + 1, x + 3, y + 6);
        gc.drawLine(x + 2, y + 1, x + 2, y + 7);
    }

    public int getRestoreWeight() {
        if (this.currentSashInfo != null) {
            return this.currentSashInfo.restoreWeight;
        }
        return -1;
    }

    protected Sash getSash() {
        Control[] kids = this.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (kids[i] instanceof Sash) {
                return (Sash)kids[i];
            }
            ++i;
        }
        return null;
    }

    public void setRestoreWeight(int weight) {
        if (weight >= 0 && this.currentSashInfo != null) {
            this.currentSashInfo.restoreWeight = weight;
        }
    }

    public Point[] getSavedSizes() {
        if (this.currentSashInfo != null) {
            return this.currentSashInfo.savedSizes;
        }
        return null;
    }

    public void addCustomSashFormListener(ICustomSashFormListener listener) {
        if (this.customSashFormListeners == null) {
            this.customSashFormListeners = new ArrayList<ICustomSashFormListener>();
        }
        this.customSashFormListeners.add(listener);
    }

    public void removeCustomSashFormListener(ICustomSashFormListener listener) {
        if (this.customSashFormListeners != null) {
            this.customSashFormListeners.remove(listener);
        }
    }

    protected void fireDividerMoved() {
        int[] weights;
        if (this.customSashFormListeners != null && this.customSashFormListeners.size() > 0 && (weights = this.getWeights()) != null && weights.length == 2) {
            int firstControlWeight = weights[0];
            int secondControlWeight = weights[1];
            for (ICustomSashFormListener listener : this.customSashFormListeners) {
                listener.dividerMoved(firstControlWeight, secondControlWeight);
            }
        }
    }

    public static interface ICustomSashFormListener {
        public void dividerMoved(int var1, int var2);
    }

    private class SashInfo {
        public Sash sash;
        public int restoreWeight = -1;
        public int cursorOver = -1;
        public boolean sashBorderLeft;
        public boolean sashBorderRight;
        public int[][] sashLocs;
        public Point[] savedSizes = new Point[2];

        public SashInfo(Sash sash) {
            this.sash = sash;
        }
    }
}

