/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.messages.Messages;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CustomReadOnlyCombo
extends Combo {
    private boolean hasError = false;
    private String errorTooltip = Messages.ErrorCombo_errorMessage;
    private String originalTooltip = null;
    private Color originalBackground;
    private boolean isReadOnly = false;
    private VerifyListener verifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (CustomReadOnlyCombo.this.isReadOnly) {
                if (e.character == '\u007f') {
                    CustomReadOnlyCombo.this.setText("");
                } else {
                    String[] stringArray = CustomReadOnlyCombo.this.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        if (item.equals(e.text)) {
                            e.doit = true;
                            return;
                        }
                        ++n2;
                    }
                }
                e.doit = false;
            }
        }
    };

    public CustomReadOnlyCombo(Composite parent, int customStyle) {
        super(parent, customStyle);
        this.addListener(37, new Listener(){

            public void handleEvent(Event arg0) {
                if (!CustomReadOnlyCombo.this.isFocusControl()) {
                    arg0.doit = false;
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (CustomReadOnlyCombo.this.isReadOnly) {
                    e.doit = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (CustomReadOnlyCombo.this.isReadOnly && e.keyCode == 0x1000002 && e.keyCode == 0x1000001) {
                    e.doit = false;
                }
            }
        });
        this.addVerifyListener(this.verifyListener);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (CustomReadOnlyCombo.this.isReadOnly) {
                    CustomReadOnlyCombo.this.setSelection(new Point(0, 0));
                }
            }
        });
    }

    public void setText(String string) {
        this.removeVerifyListener(this.verifyListener);
        super.setText(Misc.nvl((String)string));
        this.addVerifyListener(this.verifyListener);
    }

    public void select(int index) {
        this.removeVerifyListener(this.verifyListener);
        super.select(index);
        this.addVerifyListener(this.verifyListener);
    }

    public void setItems(String ... items) {
        this.removeVerifyListener(this.verifyListener);
        super.setItems(items);
        this.addVerifyListener(this.verifyListener);
    }

    public void setError(boolean value) {
        if (value != this.hasError) {
            this.hasError = value;
            if (value) {
                if (this.errorTooltip != null) {
                    super.setToolTipText(this.errorTooltip);
                }
                super.setBackground(ColorConstants.red);
            } else {
                super.setToolTipText(this.originalTooltip);
                super.setBackground(this.originalBackground);
            }
        }
    }

    public void setToolTipText(String string) {
        if (!this.hasError) {
            super.setToolTipText(string);
        }
        this.originalTooltip = string;
    }

    public void setBackground(Color color) {
        if (this.hasError) {
            super.setBackground(color);
        }
        this.originalBackground = color;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    protected void checkSubclass() {
    }
}

