/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.angles.AngleSlider;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class JSSAngleSlider
extends Canvas {
    private static final int WHOLE_RADIUS = 40;
    private static final int BUTTON_RADIUS = 10;
    private static final int STEP = 5;
    private final Image backgroundImage;
    private final Image buttonFocus;
    private final Image buttonNoFocus;
    private int selection;
    private final List<SelectionListener> selectionListeners;
    private boolean mousePressed;

    public JSSAngleSlider(Composite parent, int style) {
        super(parent, style | 0x20000000);
        ClassLoader loader = AngleSlider.class.getClassLoader();
        this.backgroundImage = new Image((Device)this.getDisplay(), loader.getResourceAsStream("images/angleBackground.png"));
        this.buttonFocus = new Image((Device)this.getDisplay(), loader.getResourceAsStream("images/angleButtonFocus.png"));
        this.buttonNoFocus = new Image((Device)this.getDisplay(), loader.getResourceAsStream("images/angleButtonFocusLost.png"));
        this.addListeners();
        this.selection = 0;
        this.selectionListeners = new ArrayList<SelectionListener>();
    }

    private void addListeners() {
        int[] listeners;
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                JSSAngleSlider.this.paintControl(event);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                SWTGraphicUtil.safeDispose((Resource)JSSAngleSlider.this.backgroundImage);
                SWTGraphicUtil.safeDispose((Resource)JSSAngleSlider.this.buttonFocus);
                SWTGraphicUtil.safeDispose((Resource)JSSAngleSlider.this.buttonNoFocus);
            }
        });
        int[] nArray = listeners = new int[]{3, 4, 5};
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            int listener = nArray[n2];
            this.addListener(listener, this.createMouseListener());
            ++n2;
        }
        this.addListener(1, this.createKeyListener());
    }

    private void paintControl(Event event) {
        GC gc = event.gc;
        gc.drawImage(this.backgroundImage, 0, 0);
        float angle = (float)this.selection / 360.0f;
        angle = (float)((double)(angle * 2.0f) * Math.PI - 1.5707963267948966);
        float x = (float)(20.0 - 10.0 * Math.cos(angle));
        float y = (float)(20.0 - 10.0 * Math.sin(angle));
        if (this.isFocusControl()) {
            gc.drawImage(this.buttonFocus, (int)x - 2, (int)y - 2);
        } else {
            gc.drawImage(this.buttonNoFocus, (int)x - 2, (int)y - 2);
        }
        if (!this.isEnabled()) {
            gc.setAlpha(127);
            gc.setAntialias(1);
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.fillOval(4, 4, 33, 33);
        }
    }

    private Listener createMouseListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!JSSAngleSlider.this.isEnabled()) {
                    return;
                }
                if (event.type == 3 && event.button == 1) {
                    JSSAngleSlider.this.mousePressed = true;
                }
                if (event.type == 3 && event.button == 1 || event.type == 5 && JSSAngleSlider.this.mousePressed) {
                    float deltaX = (float)event.x - 20.0f;
                    float deltaY = (float)event.y - 20.0f;
                    double angle = Math.atan2(deltaX, deltaY);
                    JSSAngleSlider.this.selection = 360 - (int)(360.0 * angle / (Math.PI * 2) + 360.0) % 360;
                    JSSAngleSlider.this.redraw();
                }
                if (event.type == 4) {
                    JSSAngleSlider.this.mousePressed = false;
                    JSSAngleSlider.this.fireSelectionListeners();
                }
            }
        };
    }

    private void fireSelectionListeners() {
        Event evt = new Event();
        evt.widget = this;
        SelectionEvent sel = new SelectionEvent(evt);
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(sel);
        }
    }

    private Listener createKeyListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!JSSAngleSlider.this.isEnabled()) {
                    return;
                }
                if (event.type != 1) {
                    return;
                }
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000003) {
                    JSSAngleSlider.this.setSelection(JSSAngleSlider.this.selection + 5);
                }
                if (event.keyCode == 0x1000002 || event.keyCode == 0x1000004) {
                    JSSAngleSlider.this.setSelection(JSSAngleSlider.this.selection - 5);
                }
            }
        };
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.add(selectionListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return new Point(40, 40);
    }

    public void dispose() {
        super.dispose();
        this.backgroundImage.dispose();
        this.buttonFocus.dispose();
        this.buttonNoFocus.dispose();
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.remove(selectionListener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (selection < 0 || selection > 360) {
            SWT.error((int)28);
        }
        this.selection = selection;
        this.fireSelectionListeners();
        this.redraw();
    }
}

