/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.internal.forms.widgets.FormTextModel;
import org.eclipse.ui.internal.forms.widgets.Paragraph;

public class LinkButton
extends Composite {
    private FormText editQueryLink = null;
    private String unformattedText;
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();

    public LinkButton(Composite parent, String text) {
        super(parent, 0);
        this.createLink(this, text);
    }

    private int getWidthInChars() {
        GC gc = null;
        gc = this.editQueryLink != null ? new GC((Drawable)this.editQueryLink) : new GC((Drawable)this);
        Point extent = gc.textExtent(this.unformattedText);
        gc.dispose();
        return extent.x;
    }

    private String getLongerParagraph(FormTextModel model) {
        String currentLongest = "";
        Paragraph[] paragraphArray = model.getParagraphs();
        int n = paragraphArray.length;
        int n2 = 0;
        while (n2 < n) {
            Paragraph paragraph = paragraphArray[n2];
            String text = paragraph.getAccessibleText();
            if (text.length() > currentLongest.length()) {
                currentLongest = text;
            }
            ++n2;
        }
        return currentLongest;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        size.x = this.getWidthInChars() + 10;
        return this.editQueryLink.computeSize(size.x, -1);
    }

    protected void createLink(Composite parent, String linkText) {
        if (!(linkText = linkText.trim()).startsWith("<form>")) {
            this.unformattedText = new String(linkText);
            StringBuilder formattedText = new StringBuilder();
            formattedText.append("<form><p><a href=\"\">");
            formattedText.append(linkText);
            formattedText.append("</a></p></form>");
            linkText = formattedText.toString();
        } else {
            FormTextModel formTextModel = new FormTextModel();
            formTextModel.parseTaggedText(linkText, false);
            this.unformattedText = this.getLongerParagraph(formTextModel);
        }
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.horizontalSpacing = 0;
        containerLayout.verticalSpacing = 0;
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        super.setLayout((Layout)containerLayout);
        this.editQueryLink = new FormText((Composite)this, 0);
        this.editQueryLink.setText(linkText, true, false);
        this.editQueryLink.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.editQueryLink.setWhitespaceNormalized(true);
        this.editQueryLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LinkButton.this.forceFocus();
                Event baseEvent = new Event();
                baseEvent.widget = LinkButton.this;
                baseEvent.data = e;
                SelectionEvent selectionEvent = new SelectionEvent(baseEvent);
                for (SelectionListener listener : LinkButton.this.selectionListeners) {
                    listener.widgetSelected(selectionEvent);
                }
                LinkButton.this.editQueryLink.redraw();
            }
        });
        this.editQueryLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LinkButton.this.forceFocus();
                LinkButton.this.editQueryLink.redraw();
            }
        });
        GridData data = new GridData(1808);
        data.widthHint = this.getWidthInChars();
        this.editQueryLink.setLayoutData((Object)data);
    }

    public void setText(String text) {
        if (!(text = text.trim()).startsWith("<form>")) {
            this.unformattedText = new String(text);
            StringBuilder formattedText = new StringBuilder();
            formattedText.append("<form><p><a href=\"\">");
            formattedText.append(text);
            formattedText.append("</a></p></form>");
            text = formattedText.toString();
        } else {
            FormTextModel formTextModel = new FormTextModel();
            formTextModel.parseTaggedText(text, false);
            this.unformattedText = this.getLongerParagraph(formTextModel);
        }
        this.editQueryLink.setText(text, true, false);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener != null && !this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.editQueryLink.setToolTipText(string);
    }

    public void setLayout(Layout layout) {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editQueryLink.setEnabled(enabled);
    }
}

