/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.color.chooser.ColorDialog;
import com.jaspersoft.studio.swt.events.ColorSelectedEvent;
import com.jaspersoft.studio.swt.events.ColorSelectionListener;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class WColorPicker
extends Composite {
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AlfaRGB newColor = WColorPicker.decodeColor(WColorPicker.this.textColorValue.getText(), WColorPicker.this.htmlColorNamesSupported);
            if (newColor != null) {
                WColorPicker.this.currentState = VALIDATION_RESULT.VALID;
                WColorPicker.this.setColor(newColor);
                WColorPicker.this.updateBackground(WColorPicker.this.defaultBackgroundColor);
            } else {
                WColorPicker.this.currentState = VALIDATION_RESULT.NOT_VALID;
                WColorPicker.this.updateBackground(ColorConstants.red);
            }
        }
    };
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (WColorPicker.this.previewImg != null) {
                WColorPicker.this.previewImg.dispose();
                WColorPicker.this.previewImg = null;
            }
            if (WColorPicker.this.disabledPreviewImg != null) {
                WColorPicker.this.disabledPreviewImg.dispose();
                WColorPicker.this.disabledPreviewImg = null;
            }
        }
    };
    private boolean haveTransparency = false;
    private static final String BUTTON_ICON_LOCATION = "icons/resources/colorwheel-16.png";
    private static final String BUTTON_DISABLED_ICON_LOCATION = "icons/resources/colorwheel-16-disabled.png";
    private AlfaRGB selectedRGB;
    private CLabel imgColorPreview;
    private Text textColorValue;
    private List<ColorSelectionListener> colorSelectionListeners;
    private ToolItem buttonColorChoser;
    private Color defaultBackgroundColor;
    private String toolTipText = null;
    protected VALIDATION_RESULT currentState = VALIDATION_RESULT.VALID;
    private boolean htmlColorNamesSupported = false;
    private Image previewImg;
    private Image disabledPreviewImg;

    public WColorPicker(AlfaRGB preselectedRGB, Composite parent) {
        this(preselectedRGB, parent, 0);
    }

    public WColorPicker(AlfaRGB preselectedRGB, Composite parent, int style) {
        super(parent, style);
        this.selectedRGB = preselectedRGB;
        this.colorSelectionListeners = new ArrayList<ColorSelectionListener>();
        this.addDisposeListener(this.disposeListener);
        this.createControl(parent);
    }

    public void setHaveTransparency(boolean haveTransparency) {
        this.haveTransparency = haveTransparency;
    }

    private void createControl(Composite parent) {
        this.setLayoutData(new GridData(4, 4, false, false, 1, 1));
        GridLayout colorChooserLayout = new GridLayout(3, false);
        colorChooserLayout.marginHeight = 0;
        colorChooserLayout.marginWidth = 0;
        this.setLayout((Layout)colorChooserLayout);
        this.imgColorPreview = new CLabel((Composite)this, 0);
        GridData gridData1 = new GridData(4, 0x1000000, false, false, 1, 1);
        this.imgColorPreview.setLayoutData((Object)gridData1);
        this.previewImg = Colors.getSWTColorPreview(Colors.getAWT4SWTRGBColor(this.selectedRGB), 16, 16);
        this.imgColorPreview.setImage(this.previewImg);
        this.textColorValue = new Text((Composite)this, 2049);
        GC tmpGC = new GC((Drawable)this.textColorValue);
        int charHeight = tmpGC.getFontMetrics().getHeight();
        int averageCharWidth = tmpGC.getFontMetrics().getAverageCharWidth();
        tmpGC.dispose();
        GridData gridData2 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData2.widthHint = this.textColorValue.computeSize((int)(averageCharWidth * 10), (int)-1).x;
        gridData2.heightHint = charHeight;
        this.textColorValue.setLayoutData((Object)gridData2);
        this.textColorValue.setText(Colors.getHexEncodedRGBColor(this.selectedRGB));
        this.defaultBackgroundColor = this.textColorValue.getBackground();
        this.textColorValue.addModifyListener(this.textModifyListener);
        ToolBar toolBar = new ToolBar((Composite)this, 0);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.buttonColorChoser = new ToolItem(toolBar, 0x800000);
        this.buttonColorChoser.setImage(JaspersoftStudioPlugin.getInstance().getImage(BUTTON_ICON_LOCATION));
        this.buttonColorChoser.setDisabledImage(JaspersoftStudioPlugin.getInstance().getImage(BUTTON_DISABLED_ICON_LOCATION));
        this.buttonColorChoser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(WColorPicker.this.getShell());
                cd.setText(Messages.ColorsSection_element_forecolor);
                cd.setRGB(WColorPicker.this.selectedRGB);
                AlfaRGB newColor = null;
                if (WColorPicker.this.haveTransparency) {
                    newColor = cd.openAlfaRGB();
                } else {
                    RGB rgb = cd.openRGB();
                    if (rgb != null) {
                        newColor = AlfaRGB.getFullyOpaque(rgb);
                    }
                }
                if (newColor != null) {
                    WColorPicker.this.setColor(newColor);
                    WColorPicker.this.updateBackground(WColorPicker.this.defaultBackgroundColor);
                }
            }
        });
    }

    public void setHtmlColorNamesSupport(boolean enabled) {
        this.htmlColorNamesSupported = enabled;
    }

    public boolean isHtmlColorNamesSupportEnabled() {
        return this.htmlColorNamesSupported;
    }

    public static AlfaRGB decodeColor(String text, boolean htmlColorNamesSupported) {
        if (text != null) {
            try {
                AlfaRGB newColor;
                String htmlColorHex;
                if (htmlColorNamesSupported && StringUtils.isAlpha((String)text) && !StringUtils.isEmpty((String)(htmlColorHex = Colors.getHtmlColorHex(text)))) {
                    return AlfaRGB.getFullyOpaque(new RGB(Integer.valueOf(htmlColorHex.substring(1, 3), 16).intValue(), Integer.valueOf(htmlColorHex.substring(3, 5), 16).intValue(), Integer.valueOf(htmlColorHex.substring(5, 7), 16).intValue()));
                }
                if (text.startsWith("#") && text.length() == 7) {
                    newColor = AlfaRGB.getFullyOpaque(new RGB(Integer.valueOf(text.substring(1, 3), 16).intValue(), Integer.valueOf(text.substring(3, 5), 16).intValue(), Integer.valueOf(text.substring(5, 7), 16).intValue()));
                    return newColor;
                }
                if (text.length() == 6) {
                    newColor = AlfaRGB.getFullyOpaque(new RGB(Integer.valueOf(text.substring(0, 2), 16).intValue(), Integer.valueOf(text.substring(2, 4), 16).intValue(), Integer.valueOf(text.substring(4, 6), 16).intValue()));
                    return newColor;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected void updateBackground(Color color) {
        if (Util.isMac() && this.textColorValue.isFocusControl() && !ModelUtils.safeEquals(color, this.textColorValue.getBackground())) {
            Point caretPosition = this.textColorValue.getSelection();
            boolean oldEnabled = this.textColorValue.getEnabled();
            this.textColorValue.setEnabled(false);
            this.textColorValue.setBackground(color);
            this.textColorValue.setEnabled(oldEnabled);
            this.textColorValue.setFocus();
            this.textColorValue.setSelection(caretPosition.x);
        } else {
            this.textColorValue.setBackground(color);
        }
        this.updateTooltipText();
    }

    private void notifyColorSelection() {
        for (ColorSelectionListener l : this.colorSelectionListeners) {
            ColorSelectedEvent evt = new ColorSelectedEvent((Widget)this);
            evt.selectedColor = this.selectedRGB;
            l.changed(evt);
        }
    }

    protected void setWidgetsToolTipText(String text) {
        super.setToolTipText(text);
        this.imgColorPreview.setToolTipText(text);
        this.textColorValue.setToolTipText(text);
        this.buttonColorChoser.setToolTipText(text);
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
        this.setWidgetsToolTipText(text);
    }

    protected void updateTooltipText() {
        if (VALIDATION_RESULT.NOT_VALID == this.currentState) {
            String errorTooltip = "The current value can not be recognized";
            if (this.toolTipText != null) {
                errorTooltip = String.valueOf(errorTooltip) + " \n" + this.toolTipText;
            }
            this.setWidgetsToolTipText(errorTooltip);
        } else {
            this.setToolTipText(this.toolTipText);
        }
    }

    public void setColor(AlfaRGB newColor) {
        this.selectedRGB = newColor;
        Point caretPosition = this.textColorValue.getSelection();
        this.textColorValue.removeModifyListener(this.textModifyListener);
        this.textColorValue.setText(Colors.getHexEncodedRGBColor(this.selectedRGB));
        this.textColorValue.addModifyListener(this.textModifyListener);
        this.textColorValue.setSelection(caretPosition);
        this.updatePreviewImage(this.isEnabled());
        this.notifyColorSelection();
    }

    public void addColorSelectionListener(ColorSelectionListener listener) {
        this.colorSelectionListeners.add(listener);
    }

    public void removeColorSelectionListener(ColorSelectionListener listener) {
        this.colorSelectionListeners.remove(listener);
    }

    public java.awt.Color getSelectedColorAsAWTColor() {
        return Colors.getAWT4SWTRGBColor(this.selectedRGB);
    }

    public Color getSelectedColorAsSWTColor() {
        return this.selectedRGB != null ? SWTResourceManager.getColor((RGB)this.selectedRGB.getRgb()) : null;
    }

    public AlfaRGB getSelectedColorAsRGB() {
        return this.selectedRGB;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updatePreviewImage(enabled);
        this.imgColorPreview.setEnabled(enabled);
        this.textColorValue.setEnabled(enabled);
        this.buttonColorChoser.setEnabled(enabled);
    }

    private void updatePreviewImage(boolean enabled) {
        if (this.previewImg != null) {
            this.previewImg.dispose();
            this.previewImg = null;
        }
        this.previewImg = Colors.getSWTColorPreview(Colors.getAWT4SWTRGBColor(this.selectedRGB), 16, 16);
        if (enabled) {
            this.imgColorPreview.setImage(this.previewImg);
        } else {
            if (this.disabledPreviewImg != null) {
                this.disabledPreviewImg.dispose();
                this.disabledPreviewImg = null;
            }
            this.disabledPreviewImg = new Image((Device)this.getDisplay(), this.previewImg, 1);
            this.imgColorPreview.setImage(this.disabledPreviewImg);
            this.previewImg.dispose();
            this.previewImg = null;
        }
    }

    protected static enum VALIDATION_RESULT {
        VALID,
        NOT_VALID;

    }
}

