/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import java.util.Arrays;
import java.util.Locale;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.lang.LocaleUtils;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WLocale
extends Composite {
    private Combo combo;
    public static Locale[] locales;
    public static String[] strLocales;

    public WLocale(Composite parent, int style) {
        super(parent, 0);
        this.combo = new Combo((Composite)this, style);
        this.combo.setItems(WLocale.getLocales());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.combo.setLayoutData((Object)new GridData(768));
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.combo.setToolTipText(string);
    }

    public void addModifyListener(ModifyListener m) {
        this.combo.addModifyListener(m);
    }

    public void removeModifyListener(ModifyListener m) {
        this.combo.removeModifyListener(m);
    }

    public void addSelectionListener(SelectionListener m) {
        this.combo.addSelectionListener(m);
    }

    public void removeSelectionListener(SelectionListener m) {
        this.combo.removeSelectionListener(m);
    }

    public Combo getCombo() {
        return this.combo;
    }

    public static String[] getLocales() {
        if (locales == null) {
            locales = Locale.getAvailableLocales();
            strLocales = new String[locales.length];
            int i = 0;
            while (i < strLocales.length) {
                WLocale.strLocales[i] = locales[i].getDisplayName();
                ++i;
            }
            Arrays.sort(strLocales);
        }
        return strLocales;
    }

    public void setSelection(Locale locale) {
        int index = locale == null ? this.getIndexFromLocale(Locale.getDefault()) : this.getIndexFromLocale(locale);
        this.combo.select(index);
        if (index < 0 && locale != null) {
            this.combo.setText(locale.toString());
        }
    }

    public Locale getLocale() {
        int selectionIndex = this.combo.getSelectionIndex();
        if (selectionIndex < 0) {
            if (Misc.isNullOrEmpty((String)this.combo.getText())) {
                return Locale.getDefault();
            }
            return LocaleUtils.toLocale((String)this.combo.getText());
        }
        String strLocale = strLocales[this.combo.getSelectionIndex()];
        int i = 0;
        while (i < locales.length) {
            if (locales[i].getDisplayName().equals(strLocale)) {
                return locales[i];
            }
            ++i;
        }
        return Locale.getDefault();
    }

    private int getIndexFromLocale(Locale locale) {
        int returnedIndex = -1;
        if (locale != null) {
            int i = 0;
            while (i < strLocales.length) {
                if (strLocales[i].equals(locale.getDisplayName())) {
                    returnedIndex = i;
                }
                ++i;
            }
        }
        return returnedIndex;
    }
}

