/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.UUID;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.SecretsUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class WSecretText
extends Text {
    private JasperReportsContext jrContext;
    private String secretCategory;
    private String key;
    private UUID uuid;

    public WSecretText(Composite parent, int style) {
        super(parent, style);
    }

    private void setSecretCategory(String secretCategory) {
        this.secretCategory = secretCategory;
    }

    private void setKey(String key) {
        this.key = key;
    }

    public String getUUIDKey() {
        Assert.isNotNull((Object)this.uuid);
        return this.uuid.toString();
    }

    public void persistSecret() {
        try {
            String uuidStr = this.uuid.toString();
            String widgetText = this.getText();
            if (!uuidStr.equals(widgetText)) {
                SecureStorageUtils.saveToDefaultSecurePreferences((String)this.secretCategory, (String)uuidStr, (String)widgetText);
            }
        }
        catch (StorageException e) {
            UIUtils.showError((Throwable)e);
        }
    }

    public void loadSecret(String secretCategory, String key) {
        if (!this.isWidgetConfigured()) {
            Assert.isNotNull((Object)secretCategory);
            Assert.isNotNull((Object)key);
            this.setSecretCategory(secretCategory);
            this.setKey(key);
            SecretsUtil sInstance = SecretsUtil.getInstance((JasperReportsContext)this.getJRContext());
            String secret = sInstance.getSecret(secretCategory, key);
            if (secret.equals(key)) {
                this.uuid = UUID.randomUUID();
                this.setText(secret);
            } else {
                this.uuid = UUID.fromString(key);
            }
        } else {
            throw new RuntimeException("Widget can be initialized only once!");
        }
    }

    public boolean isWidgetConfigured() {
        return this.secretCategory != null && this.key != null;
    }

    private JasperReportsContext getJRContext() {
        if (this.jrContext != null) {
            return this.jrContext;
        }
        return JasperReportsConfiguration.getDefaultInstance();
    }

    protected void checkSubclass() {
    }
}

