/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets.table;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.events.ChangeEvent;
import com.jaspersoft.studio.swt.events.ChangeListener;
import com.jaspersoft.studio.swt.widgets.table.MoveHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ListOrderButtons {
    private Button upField;
    private Button downFields;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().changed(ev);
        }
    }

    public void createOrderButtons(Composite composite, TableViewer tableViewer) {
        this.createOrderButtons(composite, tableViewer, new MoveHandler());
    }

    public void createOrderButtons(Composite composite, TableViewer tableViewer, MoveHandler moveHandler) {
        this.upField = new Button(composite, 8);
        this.upField.setText(Messages.common_up);
        this.upField.setLayoutData((Object)new GridData(770));
        this.upField.addSelectionListener((SelectionListener)new ElementOrderChanger(tableViewer, true, moveHandler));
        this.downFields = new Button(composite, 8);
        this.downFields.setText(Messages.common_down);
        this.downFields.setLayoutData((Object)new GridData(770));
        this.downFields.addSelectionListener((SelectionListener)new ElementOrderChanger(tableViewer, false, moveHandler));
        Object obj = tableViewer.getInput();
        this.setEnabled(obj instanceof Collection && !((Collection)obj).isEmpty());
        tableViewer.addSelectionChangedListener(event -> {
            StructuredSelection sel = (StructuredSelection)event.getSelection();
            this.setEnabled(sel != null && sel.size() > 0 && tableViewer.getTable().getItemCount() > 1);
        });
    }

    public void setEnabled(boolean enabled) {
        this.upField.setEnabled(enabled);
        this.downFields.setEnabled(enabled);
    }

    private final class ElementOrderChanger
    extends SelectionAdapter {
        private final TableViewer tableViewer;
        private boolean up;
        private MoveHandler moveHandler;

        private ElementOrderChanger(TableViewer tableViewer, boolean up, MoveHandler moveHandler) {
            this.tableViewer = tableViewer;
            this.up = up;
            this.moveHandler = moveHandler;
        }

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection s = (StructuredSelection)this.tableViewer.getSelection();
            if (!s.isEmpty()) {
                List lst = (List)this.tableViewer.getInput();
                int[] indxs = this.moveDown(lst, s);
                this.tableViewer.refresh();
                this.tableViewer.getTable().setSelection(indxs);
                ListOrderButtons.this.fireChangeEvent();
            }
        }

        private int[] moveDown(List lst, StructuredSelection s) {
            int[] indxs = this.tableViewer.getTable().getSelectionIndices();
            Object[] selected = new Object[indxs.length];
            int i = 0;
            while (i < indxs.length) {
                selected[i] = lst.get(indxs[i]);
                ++i;
            }
            if (this.up) {
                this.moveHandler.moveUp(selected);
            } else {
                this.moveHandler.moveDown(selected);
            }
            ArrayList<Object> nlst = new ArrayList<Object>();
            int i2 = 0;
            while (i2 < lst.size()) {
                if (Arrays.binarySearch(indxs, i2) <= -1) {
                    nlst.add(lst.get(i2));
                }
                ++i2;
            }
            int[] nindxs = new int[indxs.length];
            int i3 = 0;
            while (i3 < indxs.length) {
                int index;
                int n = index = this.up ? indxs[i3] - 1 : indxs[i3] + 1;
                if (index < 0) {
                    index = 0;
                }
                if (index >= 0 && index < lst.size()) {
                    nlst.add(index, selected[i3]);
                    nindxs[i3] = index;
                } else {
                    nlst.add(selected[i3]);
                    nindxs[i3] = nlst.size() - 1;
                }
                ++i3;
            }
            lst.clear();
            lst.addAll(nlst);
            return nindxs;
        }
    }
}

