/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.templates.engine;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.templates.ReportBundle;
import com.jaspersoft.templates.TemplateBundle;
import com.jaspersoft.templates.TemplateEngine;
import com.jaspersoft.templates.TemplateEngineException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class DefaultTemplateEngine
implements TemplateEngine {
    public static final String DATASET = "main_dataset";
    public static final String FIELDS = "main_fields";
    public static final String GROUP_FIELDS = "main_group_fields";
    public static final String DATA_ADAPTER = "data_adapter";
    public static final String OTHER_PARAMETERS = "parameters";
    public static final String ORDER_GROUP = "create_sort_fields";
    protected boolean createSortFields = false;

    @Override
    public ReportBundle generateReportBundle(TemplateBundle template, Map<String, Object> settings, JasperReportsContext jContext) throws TemplateEngineException {
        int n;
        JasperDesign jdCopy = null;
        try {
            jdCopy = ModelUtils.copyJasperDesign(jContext, template.getJasperDesign());
        }
        catch (JRException e) {
            UIUtils.showError((Throwable)e);
            return null;
        }
        List fields = (List)settings.get(FIELDS);
        List groupFields = (List)settings.get(GROUP_FIELDS);
        JRDesignDataset dataset = (JRDesignDataset)settings.get(DATASET);
        Object sortFieldsValue = settings.get(ORDER_GROUP);
        boolean bl = this.createSortFields = sortFieldsValue != null ? (Boolean)sortFieldsValue : false;
        if (dataset != null) {
            if (jdCopy.getMainDesignDataset() == null) {
                jdCopy.setMainDataset(new JRDesignDataset(jContext, true));
            }
            jdCopy.getMainDesignDataset().setQuery((JRDesignQuery)dataset.getQuery());
            JRField[] jRFieldArray = dataset.getFields();
            int n2 = jRFieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                JRField f = jRFieldArray[n3];
                try {
                    jdCopy.getMainDesignDataset().addField(f);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                ++n3;
            }
            JRDesignDataset mainDataset = jdCopy.getMainDesignDataset();
            JRParameter[] jRParameterArray = dataset.getParameters();
            n = jRParameterArray.length;
            n2 = 0;
            while (n2 < n) {
                JRParameter p = jRParameterArray[n2];
                try {
                    if (!mainDataset.getParametersMap().containsKey(p.getName())) {
                        mainDataset.addParameter(p);
                    }
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        this.processTemplate(jContext, jdCopy, fields, groupFields);
        Object subreportParams = settings.get(OTHER_PARAMETERS);
        if (subreportParams != null) {
            JRSubreportParameter[] otherParamters;
            JRSubreportParameter[] jRSubreportParameterArray = otherParamters = (JRSubreportParameter[])subreportParams;
            int n4 = otherParamters.length;
            n = 0;
            while (n < n4) {
                JRSubreportParameter param = jRSubreportParameterArray[n];
                if (!jdCopy.getParametersMap().containsKey(param.getName())) {
                    JRDesignParameter newParam = new JRDesignParameter();
                    newParam.setName(param.getName());
                    try {
                        jdCopy.addParameter((JRParameter)newParam);
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                }
                ++n;
            }
        }
        ReportBundle reportBundle = new ReportBundle(template);
        reportBundle.setJasperDesign(jdCopy);
        return reportBundle;
    }

    protected void processTemplate(JasperReportsContext jrContext, JasperDesign jd, List<Object> fields, List<Object> groupFields) {
        JRDesignTextField fieldElement;
        JRDesignStaticText labelElement;
        JRBand detailBand;
        String reportType = Misc.nvl((Object)jd.getProperty("template.type"), (String)"tabular");
        boolean keepExtraGroups = false;
        boolean noLayoutChanges = false;
        if (jd.getProperty("template.keepExtraGroups") != null && jd.getProperty("template.keepExtraGroups").equals("true")) {
            keepExtraGroups = true;
        }
        if (groupFields != null) {
            int i = 0;
            while (i < groupFields.size()) {
                try {
                    String name = ((JRField)groupFields.get(i)).getName();
                    if (jd.getGroupsList().size() <= i) {
                        JRDesignGroup g = new JRDesignGroup();
                        g.setName(name);
                        JRDesignExpression jre = new JRDesignExpression();
                        jre.setText("$F{" + name + "}");
                        g.setExpression((JRExpression)jre);
                        jd.addGroup(g);
                    }
                    if (this.createSortFields) {
                        JRDesignSortField sortfield = new JRDesignSortField();
                        sortfield.setType(SortFieldTypeEnum.FIELD);
                        sortfield.setOrder(SortOrderEnum.DESCENDING);
                        sortfield.setName(name);
                        jd.addSortField((JRSortField)sortfield);
                    }
                }
                catch (JRException jRException) {}
                JRField gr = (JRField)groupFields.get(i);
                JRDesignGroup group = (JRDesignGroup)jd.getGroupsList().get(i);
                if (group.getGroupHeaderSection() != null && group.getGroupHeaderSection().getBands().length > 0) {
                    JRDesignTextField tf;
                    JRBand groupHeaderSection = group.getGroupHeaderSection().getBands()[0];
                    JRDesignExpression groupExpression = ExprUtil.setValues(new JRDesignExpression(), "$F{" + gr.getName() + "}", gr.getValueClassName());
                    group.setExpression((JRExpression)groupExpression);
                    JRDesignStaticText st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "G" + (i + 1) + "Label");
                    if (st == null) {
                        st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "GroupLabel");
                    }
                    if (st == null) {
                        st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "Group Label");
                    }
                    if (st == null) {
                        st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "Label");
                    }
                    if (st == null) {
                        st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "Group name");
                    }
                    if (st != null) {
                        st.setText(gr.getName());
                    }
                    if ((tf = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)groupHeaderSection, "G" + (i + 1) + "Field")) == null) {
                        tf = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)groupHeaderSection, "GroupField");
                    }
                    if (tf == null) {
                        tf = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)groupHeaderSection, "Group Field");
                    }
                    if (tf == null) {
                        tf = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)groupHeaderSection, "Field");
                    }
                    if (tf != null) {
                        JRDesignExpression expression = ExprUtil.setValues(new JRDesignExpression(), "$F{" + gr.getName() + "}", gr.getValueClassName());
                        tf.setExpression((JRExpression)expression);
                    }
                }
                ++i;
            }
        }
        if (!keepExtraGroups && !noLayoutChanges) {
            int groupFieldsCount = groupFields != null ? groupFields.size() : 0;
            while (groupFieldsCount < jd.getGroupsList().size()) {
                jd.removeGroup((JRGroup)((JRDesignGroup)jd.getGroupsList().get(groupFieldsCount)));
            }
        }
        JRBand jRBand = detailBand = jd.getDetailSection() != null && jd.getDetailSection().getBands() != null && jd.getDetailSection().getBands().length > 0 ? jd.getDetailSection().getBands()[0] : null;
        if (!noLayoutChanges && reportType != null && reportType.equals("tabular")) {
            int cols;
            JRDesignBand columnHeaderBand = (JRDesignBand)jd.getColumnHeader();
            labelElement = null;
            if (columnHeaderBand != null) {
                labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)columnHeaderBand, "DetailLabel");
                if (labelElement == null) {
                    labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)columnHeaderBand, "Label");
                }
                if (labelElement == null) {
                    labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)columnHeaderBand, "Header");
                }
            }
            fieldElement = null;
            if (detailBand != null && (fieldElement = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)detailBand, "DetailField")) == null) {
                fieldElement = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)detailBand, "Field");
            }
            if (labelElement != null) {
                columnHeaderBand = labelElement.getElementGroup();
                this.removeElement((JRElementGroup)columnHeaderBand, (JRDesignElement)labelElement);
            }
            if (fieldElement != null) {
                detailBand = fieldElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBand, (JRDesignElement)fieldElement);
            }
            int width = jd.getPageWidth() - jd.getRightMargin() - jd.getLeftMargin();
            if (detailBand != null && detailBand instanceof JRDesignFrame) {
                width = ((JRDesignFrame)detailBand).getWidth();
            }
            if ((cols = (fields != null ? fields.size() : 0) - (groupFields != null ? groupFields.size() : 0)) > 0) {
                width /= cols;
                int currentX = 0;
                if (fields != null) {
                    for (Object obj : fields) {
                        JRDesignField f = (JRDesignField)obj;
                        if (groupFields != null && groupFields.contains(f)) continue;
                        JRDesignTextField newTextField = null;
                        if (fieldElement != null && detailBand != null) {
                            newTextField = (JRDesignTextField)fieldElement.clone();
                            newTextField.setExpression((JRExpression)ExprUtil.setValues(new JRDesignExpression(), "$F{" + f.getName() + "}", f.getValueClassName()));
                            newTextField.setX(currentX);
                            newTextField.setWidth(width);
                            this.addElement((JRElementGroup)detailBand, (JRDesignElement)newTextField);
                        }
                        if (labelElement != null && columnHeaderBand != null) {
                            JRDesignStaticText newLabel = (JRDesignStaticText)labelElement.clone();
                            newLabel.setText(f.getName());
                            newLabel.setX(currentX);
                            newLabel.setWidth(width);
                            if (newTextField != null) {
                                String uuid = UUID.randomUUID().toString();
                                newLabel.getPropertiesMap().setProperty("com.jaspersoft.studio.spreadsheet.connectionID", uuid);
                                newTextField.getPropertiesMap().setProperty("com.jaspersoft.studio.spreadsheet.connectionID", uuid);
                            }
                            this.addElement((JRElementGroup)columnHeaderBand, (JRDesignElement)newLabel);
                        }
                        currentX += width;
                    }
                }
            }
        } else if (!noLayoutChanges && reportType != null && reportType.equals("columnar") && detailBand != null) {
            JRDesignBand detailBandField = (JRDesignBand)jd.getDetailSection().getBands()[0];
            labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)detailBand, "DetailLabel");
            if (labelElement == null) {
                labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)detailBand, "Label");
            }
            if (labelElement == null) {
                labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)detailBand, "Header");
            }
            if ((fieldElement = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)detailBandField, "DetailField")) == null) {
                fieldElement = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)detailBandField, "Field");
            }
            if (labelElement != null) {
                detailBand = labelElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBand, (JRDesignElement)labelElement);
            }
            if (fieldElement != null) {
                detailBandField = fieldElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBandField, (JRDesignElement)fieldElement);
            }
            int currentY = 0;
            int rowHeight = 0;
            if (labelElement != null) {
                rowHeight = labelElement.getHeight();
            }
            if (fieldElement != null) {
                rowHeight = Math.max(rowHeight, fieldElement.getHeight());
            }
            if (fields != null) {
                for (Object obj : fields) {
                    JRDesignField f = (JRDesignField)obj;
                    if (groupFields != null && groupFields.contains(f)) continue;
                    if (labelElement != null) {
                        JRDesignStaticText newLabel = (JRDesignStaticText)labelElement.clone();
                        newLabel.setText(f.getName());
                        newLabel.setY(currentY);
                        this.addElement((JRElementGroup)detailBand, (JRDesignElement)newLabel);
                    }
                    if (fieldElement != null) {
                        JRDesignTextField newTextField = (JRDesignTextField)fieldElement.clone();
                        JRDesignExpression expression = ExprUtil.setValues(new JRDesignExpression(), "$F{" + f.getName() + "}", f.getValueClassName());
                        newTextField.setExpression((JRExpression)expression);
                        newTextField.setY(currentY);
                        this.addElement((JRElementGroup)detailBandField, (JRDesignElement)newTextField);
                    }
                    currentY += rowHeight;
                }
            }
            this.setGroupHeight((JRElementGroup)detailBand, currentY);
            this.setGroupHeight((JRElementGroup)detailBandField, currentY);
        }
    }

    public static JRDesignStaticText findStaticTextElement(JRElementGroup parent, String exp) {
        JRElement[] elements = parent.getElements();
        int i = 0;
        while (i < elements.length) {
            JRDesignStaticText ele2;
            JRElement ele = elements[i];
            if (ele instanceof JRDesignStaticText) {
                JRDesignStaticText st = (JRDesignStaticText)ele;
                if (st.getText() != null && st.getText().equalsIgnoreCase(exp)) {
                    return st;
                }
            } else if (ele instanceof JRElementGroup && (ele2 = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)ele, exp)) != null) {
                return ele2;
            }
            ++i;
        }
        return null;
    }

    public static JRDesignTextField findTextFieldElement(JRElementGroup band, String exp) {
        JRElement[] elements = band.getElements();
        int i = 0;
        while (i < elements.length) {
            JRDesignTextField ele2;
            JRElement ele = elements[i];
            if (ele instanceof JRDesignTextField) {
                String s = ExprUtil.getExpressionText(((JRDesignTextField)ele).getExpression());
                if (s.startsWith("\"")) {
                    s = s.substring(1);
                }
                if (s.endsWith("\"")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.equalsIgnoreCase(exp)) {
                    return (JRDesignTextField)ele;
                }
            } else if (ele instanceof JRElementGroup && (ele2 = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)ele, exp)) != null) {
                return ele2;
            }
            ++i;
        }
        return null;
    }

    public void removeElement(JRElementGroup container, JRDesignElement element) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).removeElement(element);
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).removeElement((JRElement)element);
        }
    }

    public void addElement(JRElementGroup container, JRDesignElement element) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).addElement(element);
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).addElement((JRElement)element);
        }
    }

    private void setGroupHeight(JRElementGroup container, int minHeight) {
        if (container instanceof JRDesignBand) {
            ((JRDesignBand)container).setHeight(Math.max(minHeight, ((JRDesignBand)container).getHeight()));
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).setHeight(Math.max(minHeight, ((JRDesignFrame)container).getHeight()));
        }
    }

    public static List<String> validateJasperDesig(JasperDesign design) {
        JRDesignTextField fieldElement;
        JRDesignStaticText labelElement;
        JRBand detailBand;
        ArrayList<String> errorsList = new ArrayList<String>();
        int groupIndex = 0;
        for (JRGroup jrGroup : design.getGroupsList()) {
            JRDesignGroup group = (JRDesignGroup)jrGroup;
            if (group.getGroupHeaderSection() != null && group.getGroupHeaderSection().getBands().length > 0) {
                JRDesignTextField tf;
                JRBand groupHeaderSection = group.getGroupHeaderSection().getBands()[0];
                JRDesignStaticText st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "G" + (groupIndex + 1) + "Label");
                if (st == null) {
                    st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "GroupLabel");
                }
                if (st == null) {
                    st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "Group Label");
                }
                if (st == null) {
                    st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "Label");
                }
                if (st == null) {
                    st = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)groupHeaderSection, "Group name");
                }
                if ((tf = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)groupHeaderSection, "G" + (groupIndex + 1) + "Field")) == null) {
                    tf = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)groupHeaderSection, "GroupField");
                }
                if (tf == null) {
                    tf = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)groupHeaderSection, "Group Field");
                }
                if (tf == null) {
                    tf = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)groupHeaderSection, "Field");
                }
                if (st == null && tf == null) {
                    errorsList.add(String.valueOf(Messages.DefaultTemplateEngine_missingGroupFiledStatic) + (groupIndex + 1));
                }
            }
            ++groupIndex;
        }
        String reportType = Misc.nvl((Object)design.getProperty("template.type"), (String)"tabular");
        JRBand jRBand = detailBand = design.getDetailSection() != null && design.getDetailSection().getBands() != null && design.getDetailSection().getBands().length > 0 ? design.getDetailSection().getBands()[0] : null;
        if (reportType != null && reportType.equals("tabular")) {
            JRDesignBand columnHeaderBand = (JRDesignBand)design.getColumnHeader();
            labelElement = null;
            if (columnHeaderBand != null) {
                labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)columnHeaderBand, "DetailLabel");
                if (labelElement == null) {
                    labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)columnHeaderBand, "Label");
                }
                if (labelElement == null) {
                    labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)columnHeaderBand, "Header");
                }
            }
            fieldElement = null;
            if (detailBand != null && (fieldElement = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)detailBand, "DetailField")) == null) {
                fieldElement = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)detailBand, "Field");
            }
            if (labelElement == null) {
                errorsList.add(Messages.DefaultTemplateEngine_missingStaticTextCH);
            }
            if (fieldElement == null) {
                errorsList.add(Messages.DefaultTemplateEngine_missingTextFieldD);
            }
        } else if (reportType.equals("columnar") && detailBand != null) {
            JRDesignBand detailBandField = (JRDesignBand)design.getDetailSection().getBands()[0];
            labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)detailBand, "DetailLabel");
            if (labelElement == null) {
                labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)detailBand, "Label");
            }
            if (labelElement == null) {
                labelElement = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)detailBand, "Header");
            }
            if (labelElement == null) {
                errorsList.add(Messages.DefaultTemplateEngine_missingStaticTextD);
            }
            if ((fieldElement = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)detailBandField, "DetailField")) == null) {
                fieldElement = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)detailBandField, "Field");
            }
            if (fieldElement != null) {
                errorsList.add(Messages.DefaultTemplateEngine_missingTextFieldD);
            }
        }
        return errorsList;
    }

    @Override
    public void setReportDataAdapter(ReportBundle bundle, DataAdapterDescriptor dataadapter, JRPropertiesMap properties, JasperReportsConfiguration jConf) {
        JasperDesign jd = bundle.getJasperDesign();
        String[] stringArray = properties.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            jd.setProperty(key, properties.getProperty(key));
            ++n2;
        }
        jConf.getEditorContext().setDataAdapter(dataadapter, jd);
    }
}

