/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars.border;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.border.TemplateBorder;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElementLineBox;
import com.jaspersoft.studio.model.MLineBox;
import com.jaspersoft.studio.model.MLinePen;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BorderContributionItem
extends CommonToolbarHandler {
    private Composite control;
    private TableCombo combo;
    private static List<TemplateBorder> exampleImages = new ArrayList<TemplateBorder>();
    private ModelListener modelListener = new ModelListener();
    private APropertyNode showedNode = null;

    static {
        exampleImages.add(new TemplateBorder(null, LineStyleEnum.SOLID));
        exampleImages.add(new TemplateBorder(Float.valueOf(1.0f), LineStyleEnum.SOLID));
        exampleImages.add(new TemplateBorder(Float.valueOf(1.0f), LineStyleEnum.DASHED));
        exampleImages.add(new TemplateBorder(Float.valueOf(1.0f), LineStyleEnum.DOTTED));
        exampleImages.add(new TemplateBorder(Float.valueOf(1.0f), LineStyleEnum.DOUBLE));
        exampleImages.add(new TemplateBorder(Float.valueOf(2.0f), LineStyleEnum.SOLID));
        exampleImages.add(new TemplateBorder(Float.valueOf(2.0f), LineStyleEnum.DASHED));
        exampleImages.add(new TemplateBorder(Float.valueOf(2.0f), LineStyleEnum.DOTTED));
        exampleImages.add(new TemplateBorder(Float.valueOf(2.0f), LineStyleEnum.DOUBLE));
        exampleImages.add(new TemplateBorder(Float.valueOf(4.0f), LineStyleEnum.SOLID));
        exampleImages.add(new TemplateBorder(Float.valueOf(4.0f), LineStyleEnum.DASHED));
        exampleImages.add(new TemplateBorder(Float.valueOf(4.0f), LineStyleEnum.DOTTED));
        exampleImages.add(new TemplateBorder(Float.valueOf(4.0f), LineStyleEnum.DOUBLE));
    }

    protected void setCorrectValue() {
        if (this.combo != null && !this.combo.isDisposed()) {
            TemplateBorder actualBorder = this.getElementAttributes();
            int index = exampleImages.indexOf(actualBorder);
            if (index != -1) {
                this.combo.select(index);
            } else {
                this.combo.select(exampleImages.size());
            }
        }
    }

    protected Command getChangePropertyCommand(Object property, Object newValue, APropertyNode n) {
        Object oldValue = n.getPropertyValue(property);
        if (oldValue == null && newValue != null || oldValue != null && newValue == null || newValue != null && !newValue.equals(oldValue)) {
            SetValueCommand setCommand = new SetValueCommand(n.getDisplayText());
            setCommand.setTarget(n);
            setCommand.setPropertyId(property);
            setCommand.setPropertyValue(newValue);
            return setCommand;
        }
        return null;
    }

    private void changeAllProperties(JSSCompoundCommand cc, TemplateBorder selectedElement, MLinePen lp) {
        Command c = this.getChangePropertyCommand("lineColor", new AlfaRGB(selectedElement.getColor(), 255), lp);
        if (c != null) {
            cc.add(c);
        }
        if ((c = this.getChangePropertyCommand("lineStyle", selectedElement.getStyle(), lp)) != null) {
            cc.add(c);
        }
        if ((c = this.getChangePropertyCommand("lineWidth", selectedElement.getLineWidth(), lp)) != null) {
            cc.add(c);
        }
    }

    private TemplateBorder getElementAttribute(String position, MLineBox lb) {
        MLinePen lp = (MLinePen)lb.getPropertyValue(position);
        JRPen pen = (JRPen)lp.getValue();
        LineStyleEnum lineStyle = pen.getLineStyleValue();
        Float lineWidth = (Float)lp.getPropertyValue("lineWidth");
        AlfaRGB lineColor = (AlfaRGB)lp.getPropertyValue("lineColor");
        TemplateBorder result = new TemplateBorder(lineWidth, lineStyle, lineColor != null ? lineColor.getRgb() : null);
        return result;
    }

    private TemplateBorder getElementAttributes() {
        List<Object> selection = this.getSelectionForType(MGraphicElementLineBox.class);
        if (selection.size() > 0) {
            TemplateBorder left;
            MGraphicElementLineBox model = (MGraphicElementLineBox)selection.get(0);
            MLineBox lb = (MLineBox)model.getPropertyValue("LineBox");
            TemplateBorder top = this.getElementAttribute("LinePen_TOP", lb);
            if (!top.equals(left = this.getElementAttribute("LinePen_RIGHT", lb))) {
                return null;
            }
            TemplateBorder right = this.getElementAttribute("LinePen_RIGHT", lb);
            if (!top.equals(right)) {
                return null;
            }
            TemplateBorder bottom = this.getElementAttribute("LinePen_BOTTOM", lb);
            if (!top.equals(bottom)) {
                return null;
            }
            return top;
        }
        return null;
    }

    private void changeProperty() {
        if (this.combo.getSelectionIndex() < exampleImages.size()) {
            List<Object> selection = this.getSelectionForType(MGraphicElementLineBox.class);
            JSSCompoundCommand cc = new JSSCompoundCommand("Change border", selection.isEmpty() ? null : (APropertyNode)selection.get(0));
            for (Object obj : selection) {
                MGraphicElementLineBox model = (MGraphicElementLineBox)obj;
                TemplateBorder selectedElement = exampleImages.get(this.combo.getSelectionIndex());
                MLineBox lb = (MLineBox)model.getPropertyValue("LineBox");
                MLinePen lp = (MLinePen)lb.getPropertyValue("LinePen_BOTTOM");
                this.changeAllProperties(cc, selectedElement, lp);
                lp = (MLinePen)lb.getPropertyValue("LinePen_LEFT");
                this.changeAllProperties(cc, selectedElement, lp);
                lp = (MLinePen)lb.getPropertyValue("LinePen_RIGHT");
                this.changeAllProperties(cc, selectedElement, lp);
                lp = (MLinePen)lb.getPropertyValue("LinePen_TOP");
                this.changeAllProperties(cc, selectedElement, lp);
            }
            CommandStack cs = this.getCommandStack();
            cs.execute((Command)cc);
        }
        this.setCorrectValue();
    }

    @Override
    protected boolean fillWithToolItems(ToolBar parent) {
        ToolItem tiBorderCombo = new ToolItem(parent, 2);
        this.combo = new TableCombo((Composite)parent, 2056){

            @Override
            protected Table createTable(Composite parent) {
                Table table = super.createTable(parent);
                TemplateBorder.setWidth(100);
                for (TemplateBorder border : exampleImages) {
                    TableItem ti = new TableItem(table, 8);
                    ti.setImage(border.getImage());
                }
                TableItem ti = new TableItem(table, 0);
                ti.setImage(TemplateBorder.getCustomImage());
                return table;
            }
        };
        this.combo.setEditable(false);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BorderContributionItem.this.changeProperty();
            }
        });
        this.setAllControlsData();
        this.combo.pack();
        tiBorderCombo.setWidth(130);
        tiBorderCombo.setControl((Control)this.combo);
        this.getToolItems().add(tiBorderCombo);
        return true;
    }

    protected void setAllControlsData() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        List<Object> selection = this.getSelectionForType(MGraphicElementLineBox.class);
        if (selection.size() == 1) {
            APropertyNode node = (APropertyNode)selection.get(0);
            this.setCorrectValue();
            if (this.showedNode != null) {
                this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.modelListener);
            }
            this.showedNode = node;
            this.showedNode.getPropertyChangeSupport().addPropertyChangeListener(this.modelListener);
        }
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        List<Object> selection = this.getSelectionForType(MGraphicElementLineBox.class);
        return !selection.isEmpty();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.combo != null) {
            this.combo.dispose();
            this.combo = null;
        }
        if (this.control != null) {
            this.control.dispose();
            this.control = null;
        }
        if (this.showedNode != null) {
            this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.modelListener);
            this.showedNode = null;
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BorderContributionItem.this.setCorrectValue();
        }
    }
}

