/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars.text;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.property.ResetValueCommand;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertySource;

public class TextualButtonsContributionItem
extends CommonToolbarHandler {
    protected static MouseAdapter macComboMenuOpener = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            Menu menu;
            if (e.button == 3 && ((Control)e.widget).getMenu() != null && !(menu = ((Control)e.widget).getMenu()).isDisposed() && !menu.isVisible()) {
                Point location = e.widget.getDisplay().getCursorLocation();
                menu.setLocation(location.x, location.y);
                menu.setVisible(true);
            }
        }
    };
    private APropertyNode showedNode = null;
    private Composite controlsArea;
    public static Integer factor = 10;
    private ToolItem bold;
    private ToolItem italic;
    private ToolBar boldToolbar;
    private ToolBar italicToolbar;
    private ToolBar hAlignToolbar;
    private ToolBar vAlignToolbar;
    private boolean refreshing = false;
    private PropertyChangeListener nodeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TextualButtonsContributionItem.this.boldToolbar == null || TextualButtonsContributionItem.this.boldToolbar.isDisposed()) {
                return;
            }
            TextualButtonsContributionItem.this.refreshing = true;
            List selection = TextualButtonsContributionItem.this.getSelectionForType(MTextElement.class);
            if (selection.size() == 1) {
                APropertyNode node = (APropertyNode)selection.get(0);
                if (evt.getPropertyName().equals("isItalic")) {
                    TextualButtonsContributionItem.this.italic.setSelection(((Boolean)node.getPropertyActualValue("isItalic")).booleanValue());
                } else if (evt.getPropertyName().equals("isBold")) {
                    TextualButtonsContributionItem.this.bold.setSelection(((Boolean)node.getPropertyActualValue("isBold")).booleanValue());
                }
            } else {
                TextualButtonsContributionItem.this.italic.setSelection(false);
                TextualButtonsContributionItem.this.bold.setSelection(false);
                if (TextualButtonsContributionItem.this.showedNode != null) {
                    TextualButtonsContributionItem.this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(TextualButtonsContributionItem.this.nodeChangeListener);
                    TextualButtonsContributionItem.this.showedNode = null;
                }
            }
            TextualButtonsContributionItem.this.refreshing = false;
        }
    };
    private SelectionAdapter booleanButtonSelected = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!TextualButtonsContributionItem.this.refreshing) {
                List selection = TextualButtonsContributionItem.this.getSelectionForType(MTextElement.class);
                if (selection.isEmpty()) {
                    return;
                }
                Boolean value = ((ToolItem)e.widget).getSelection();
                Object property = e.widget.getData(WIDGET_DATA_KEY);
                JSSCompoundCommand cc = new JSSCompoundCommand(null);
                for (Object textElement : selection) {
                    Command changeValueCmd = TextualButtonsContributionItem.this.createCommand(textElement, value, property);
                    if (changeValueCmd == null) continue;
                    cc.add(changeValueCmd);
                    cc.setReferenceNodeIfNull(textElement);
                }
                TextualButtonsContributionItem.this.getCommandStack().execute((Command)cc);
            }
        }
    };
    private SelectionAdapter pushButtonPressed = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!TextualButtonsContributionItem.this.refreshing) {
                List selection = TextualButtonsContributionItem.this.getSelectionForType(MTextElement.class);
                if (selection.isEmpty()) {
                    return;
                }
                JSSCompoundCommand changeSizeCommands = new JSSCompoundCommand(null);
                String property = "";
                Object data = e.widget.getData(WIDGET_DATA_KEY);
                if (data instanceof VerticalTextAlignEnum) {
                    property = "verticalTextAlignment";
                } else if (data instanceof HorizontalTextAlignEnum) {
                    property = "horizontalTextAlignment";
                } else {
                    return;
                }
                for (Object textElement : selection) {
                    changeSizeCommands.setReferenceNodeIfNull(textElement);
                    Command c = TextualButtonsContributionItem.this.createCommand(textElement, data, property);
                    if (c == null) continue;
                    changeSizeCommands.add(c);
                }
                CommandStack cs = TextualButtonsContributionItem.this.getCommandStack();
                cs.execute((Command)changeSizeCommands);
            }
        }
    };

    @Override
    protected Control createControl(Composite parent) {
        this.controlsArea = new Composite(parent, 0);
        RowLayout layout = new RowLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.controlsArea.setLayout((Layout)layout);
        this.boldToolbar = new ToolBar(this.controlsArea, 0x800040);
        this.bold = new ToolItem(this.boldToolbar, 32);
        this.bold.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/font-bold.gif"));
        this.bold.setToolTipText("Bold");
        this.bold.setData(WIDGET_DATA_KEY, (Object)"isBold");
        this.bold.addSelectionListener((SelectionListener)this.booleanButtonSelected);
        this.bold.setWidth(25);
        this.italicToolbar = new ToolBar(this.controlsArea, 0x800040);
        this.italic = new ToolItem(this.italicToolbar, 32);
        this.italic.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/font-italic.gif"));
        this.italic.setToolTipText("Italic");
        this.italic.setData(WIDGET_DATA_KEY, (Object)"isItalic");
        this.italic.addSelectionListener((SelectionListener)this.booleanButtonSelected);
        this.italic.setWidth(25);
        this.hAlignToolbar = new ToolBar(this.controlsArea, 0x800040);
        ToolItem alignButton = new ToolItem(this.hAlignToolbar, 8);
        alignButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/left_align.gif"));
        alignButton.setData(WIDGET_DATA_KEY, (Object)HorizontalTextAlignEnum.LEFT);
        alignButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        alignButton = new ToolItem(this.hAlignToolbar, 8);
        alignButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/center_align.gif"));
        alignButton.setData(WIDGET_DATA_KEY, (Object)HorizontalTextAlignEnum.CENTER);
        alignButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        alignButton = new ToolItem(this.hAlignToolbar, 8);
        alignButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/right_align.gif"));
        alignButton.setData(WIDGET_DATA_KEY, (Object)HorizontalTextAlignEnum.RIGHT);
        alignButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        alignButton = new ToolItem(this.hAlignToolbar, 8);
        alignButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/justified_align.gif"));
        alignButton.setData(WIDGET_DATA_KEY, (Object)HorizontalTextAlignEnum.JUSTIFIED);
        alignButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        new ToolItem(this.hAlignToolbar, 2);
        this.vAlignToolbar = new ToolBar(this.controlsArea, 0x800040);
        alignButton = new ToolItem(this.vAlignToolbar, 8);
        alignButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment-top.png"));
        alignButton.setData(WIDGET_DATA_KEY, (Object)VerticalTextAlignEnum.TOP);
        alignButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        alignButton = new ToolItem(this.vAlignToolbar, 8);
        alignButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment-middle.png"));
        alignButton.setData(WIDGET_DATA_KEY, (Object)VerticalTextAlignEnum.MIDDLE);
        alignButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        alignButton = new ToolItem(this.vAlignToolbar, 8);
        alignButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment.png"));
        alignButton.setData(WIDGET_DATA_KEY, (Object)VerticalTextAlignEnum.BOTTOM);
        alignButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        this.setAllControlsData();
        return this.controlsArea;
    }

    @Override
    protected boolean fillWithToolItems(ToolBar parent) {
        ToolItem tiToolabrs = new ToolItem(parent, 2);
        Composite toolItemContainer = new Composite((Composite)parent, 0);
        RowLayout toolItemContainerLayout = new RowLayout();
        toolItemContainerLayout.marginTop = 0;
        toolItemContainerLayout.marginBottom = 0;
        toolItemContainerLayout.marginLeft = 0;
        toolItemContainerLayout.marginRight = 0;
        toolItemContainerLayout.spacing = 0;
        toolItemContainer.setLayout((Layout)toolItemContainerLayout);
        tiToolabrs.setControl((Control)toolItemContainer);
        this.getToolItems().add(tiToolabrs);
        this.boldToolbar = new ToolBar(toolItemContainer, 0x800040);
        this.bold = new ToolItem(this.boldToolbar, 32);
        this.bold.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/font-bold.gif"));
        this.bold.setToolTipText("Bold");
        this.bold.setData(WIDGET_DATA_KEY, (Object)"isBold");
        this.bold.addSelectionListener((SelectionListener)this.booleanButtonSelected);
        this.bold.setWidth(25);
        this.italicToolbar = new ToolBar(toolItemContainer, 0x800040);
        this.italic = new ToolItem(this.italicToolbar, 32);
        this.italic.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/font-italic.gif"));
        this.italic.setToolTipText("Italic");
        this.italic.setData(WIDGET_DATA_KEY, (Object)"isItalic");
        this.italic.addSelectionListener((SelectionListener)this.booleanButtonSelected);
        this.italic.setWidth(25);
        this.hAlignToolbar = new ToolBar(toolItemContainer, 0x800040);
        ToolItem alignLeftButton = new ToolItem(this.hAlignToolbar, 8);
        alignLeftButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/left_align.gif"));
        alignLeftButton.setData(WIDGET_DATA_KEY, (Object)HorizontalTextAlignEnum.LEFT);
        alignLeftButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        ToolItem alignCenterButton = new ToolItem(this.hAlignToolbar, 8);
        alignCenterButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/center_align.gif"));
        alignCenterButton.setData(WIDGET_DATA_KEY, (Object)HorizontalTextAlignEnum.CENTER);
        alignCenterButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        ToolItem alignRightButton = new ToolItem(this.hAlignToolbar, 8);
        alignRightButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/right_align.gif"));
        alignRightButton.setData(WIDGET_DATA_KEY, (Object)HorizontalTextAlignEnum.RIGHT);
        alignRightButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        ToolItem alignJustifiedButton = new ToolItem(this.hAlignToolbar, 8);
        alignJustifiedButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/justified_align.gif"));
        alignJustifiedButton.setData(WIDGET_DATA_KEY, (Object)HorizontalTextAlignEnum.JUSTIFIED);
        alignJustifiedButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        new ToolItem(this.hAlignToolbar, 2);
        this.vAlignToolbar = new ToolBar(toolItemContainer, 0x800040);
        ToolItem alignTopButton = new ToolItem(this.vAlignToolbar, 8);
        alignTopButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment-top.png"));
        alignTopButton.setData(WIDGET_DATA_KEY, (Object)VerticalTextAlignEnum.TOP);
        alignTopButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        ToolItem alignMiddleButton = new ToolItem(this.vAlignToolbar, 8);
        alignMiddleButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment-middle.png"));
        alignMiddleButton.setData(WIDGET_DATA_KEY, (Object)VerticalTextAlignEnum.MIDDLE);
        alignMiddleButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        this.getToolItems().add(alignMiddleButton);
        ToolItem alignBottomButton = new ToolItem(this.vAlignToolbar, 8);
        alignBottomButton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/formatting/edit-vertical-alignment.png"));
        alignBottomButton.setData(WIDGET_DATA_KEY, (Object)VerticalTextAlignEnum.BOTTOM);
        alignBottomButton.addSelectionListener((SelectionListener)this.pushButtonPressed);
        tiToolabrs.setWidth(toolItemContainer.computeSize((int)-1, (int)-1).x);
        this.setAllControlsData();
        return true;
    }

    protected Command createCommand(Object model, Object value, Object property) {
        if (!(model instanceof IPropertySource)) {
            return null;
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget((IPropertySource)model);
        cmd.setPropertyId(property);
        cmd.setPropertyValue(value);
        return cmd;
    }

    @Override
    public boolean isVisible() {
        boolean selectionValid;
        if (!super.isVisible()) {
            return false;
        }
        List<Object> selection = this.getSelectionForType(MTextElement.class);
        boolean bl = selectionValid = selection.size() > 0;
        if (selectionValid) {
            this.setAllControlsData();
        } else if (this.showedNode != null) {
            this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            this.showedNode = null;
        }
        return selectionValid;
    }

    protected JSSCompoundCommand createIncremenrtsCommand(boolean increment, List<Object> models) {
        JSSCompoundCommand changeSizeCommands = new JSSCompoundCommand(null);
        for (Object model : models) {
            Object fontSize = ((APropertyNode)model).getPropertyActualValue("fontSize");
            Float newValue = Float.valueOf(2.0f);
            if (fontSize == null || fontSize.toString().length() <= 0) continue;
            newValue = Float.valueOf(fontSize.toString());
            Integer plus = null;
            plus = increment ? Integer.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)factor.intValue()) + 1) : Integer.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)(-factor.intValue())) - 1);
            if (newValue.floatValue() + (float)plus.intValue() > 99.0f) {
                newValue = Float.valueOf(99.0f);
            } else if (newValue.floatValue() + (float)plus.intValue() > 0.0f) {
                newValue = Float.valueOf(newValue.floatValue() + (float)plus.intValue());
            }
            Command c = this.createCommand(model, newValue, "fontSize");
            changeSizeCommands.setReferenceNodeIfNull(model);
            if (c == null) continue;
            changeSizeCommands.add(c);
        }
        return changeSizeCommands;
    }

    protected void setAllControlsData() {
        if (this.boldToolbar == null || this.boldToolbar.isDisposed()) {
            return;
        }
        this.refreshing = true;
        List<Object> selection = this.getSelectionForType(MTextElement.class);
        if (selection.size() == 1) {
            APropertyNode node = (APropertyNode)selection.get(0);
            this.italic.setSelection(((Boolean)node.getPropertyActualValue("isItalic")).booleanValue());
            this.createContextualMenu(node, (Control)this.italicToolbar, "isItalic");
            this.bold.setSelection(((Boolean)node.getPropertyActualValue("isBold")).booleanValue());
            this.createContextualMenu(node, (Control)this.boldToolbar, "isBold");
            this.createContextualMenu(node, (Control)this.vAlignToolbar, "verticalTextAlignment");
            this.createContextualMenu(node, (Control)this.hAlignToolbar, "horizontalTextAlignment");
            if (this.showedNode != null) {
                this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            }
            this.showedNode = node;
            this.showedNode.getPropertyChangeSupport().addPropertyChangeListener(this.nodeChangeListener);
        } else {
            this.italic.setSelection(false);
            this.bold.setSelection(false);
            if (this.showedNode != null) {
                this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
                this.showedNode = null;
            }
        }
        this.refreshing = false;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.showedNode != null) {
            this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            this.showedNode = null;
        }
        if (this.controlsArea != null) {
            this.controlsArea.dispose();
            this.controlsArea = null;
        }
        this.bold = null;
        this.italic = null;
        this.boldToolbar = null;
        factor = 10;
        this.refreshing = false;
    }

    protected void createContextualMenu(final APropertyNode node, final Control control, final String propertyID) {
        if (node != null && control != null && !control.isDisposed()) {
            DefaultValue defaultEntry;
            boolean handleComboListener;
            boolean bl = handleComboListener = Util.isMac() && control.getClass() == Combo.class;
            if (handleComboListener) {
                control.removeMouseListener((MouseListener)macComboMenuOpener);
            }
            boolean entryCreated = false;
            Map<String, DefaultValue> defaultMap = node.getDefaultsPropertiesMap();
            if (defaultMap != null && (defaultEntry = defaultMap.get(propertyID)) != null && (defaultEntry.isNullable() || defaultEntry.hasDefault())) {
                Menu controlMenu = new Menu(control);
                if (defaultEntry.hasDefault()) {
                    MenuItem resetItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    resetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResetValueCommand cmd = new ResetValueCommand();
                            cmd.setPropertyId(propertyID);
                            cmd.setTarget(node);
                            CommandStack cs = TextualButtonsContributionItem.this.getCommandStack();
                            cs.execute((Command)cmd);
                            control.setFocus();
                        }
                    });
                    resetItem.setText(Messages.ASPropertyWidget_0);
                }
                if (defaultEntry.isNullable()) {
                    MenuItem nullItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    nullItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SetValueCommand cmd = new SetValueCommand();
                            cmd.setPropertyId(propertyID);
                            cmd.setTarget(node);
                            cmd.setPropertyValue(null);
                            CommandStack cs = TextualButtonsContributionItem.this.getCommandStack();
                            cs.execute((Command)cmd);
                            control.setFocus();
                        }
                    });
                    nullItem.setText(Messages.ASPropertyWidget_1);
                }
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(controlMenu);
                if (handleComboListener) {
                    control.addMouseListener((MouseListener)macComboMenuOpener);
                }
            }
            if (!entryCreated) {
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(null);
            }
        }
    }
}

