/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.translation;

import com.jaspersoft.studio.translation.ExtendedTranslationInformation;
import com.jaspersoft.studio.translation.FragmentCreationUtil;
import com.jaspersoft.studio.translation.wizard.GenerateFragmentWizard;
import com.jaspersoft.translation.action.ProvideSelectedTranslation;
import com.jaspersoft.translation.resources.TranslationInformation;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class CreateTranslationFragmentCommand
implements IHandler {
    private static String baseVersion = ((String)Platform.getBundle((String)"com.jaspersoft.studio").getHeaders().get("Bundle-Version")).toString();

    public static ExtendedTranslationInformation generateExtendedInfo(TranslationInformation baseInfo, String qualifiedVersion, String vendorName) {
        ExtendedTranslationInformation extendedInfo = new ExtendedTranslationInformation(baseInfo);
        String qualifiedName = String.valueOf(baseInfo.getPluginName()) + "_translation";
        Bundle bundle = Platform.getBundle((String)baseInfo.getPluginName());
        String version = "";
        version = bundle != null ? ((String)bundle.getHeaders().get("Bundle-Version")).toString() : new String(baseVersion);
        version = version.replaceAll("\\.qualifier", "");
        extendedInfo.setBundleVersion(qualifiedVersion);
        extendedInfo.setBundleProducer(vendorName);
        extendedInfo.setBundleName(qualifiedName);
        extendedInfo.setHostPluginName(baseInfo.getPluginName());
        extendedInfo.setHostPluginVersion(version);
        return extendedInfo;
    }

    private List<ExtendedTranslationInformation> generateExtendedInfos(List<TranslationInformation> baseInfos) {
        String qualifiedVersion = FragmentCreationUtil.generateQualifier();
        String vendorName = System.getProperty("user.name");
        ArrayList<ExtendedTranslationInformation> result = new ArrayList<ExtendedTranslationInformation>();
        for (TranslationInformation baseInfo : baseInfos) {
            result.add(CreateTranslationFragmentCommand.generateExtendedInfo(baseInfo, qualifiedVersion, vendorName));
        }
        return result;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ProvideSelectedTranslation translationCommand = new ProvideSelectedTranslation();
        List translations = translationCommand.execute();
        List<ExtendedTranslationInformation> extendedInfo = this.generateExtendedInfos(translations);
        GenerateFragmentWizard wizard = new GenerateFragmentWizard(extendedInfo);
        WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
        dialog.create();
        UIUtils.resizeAndCenterShell((Shell)dialog.getShell(), (int)600, (int)600);
        dialog.open();
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }
}

