/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.translation;

import com.jaspersoft.studio.utils.ImageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.babel.editor.widgets.LocaleSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FlagLocaleSelector
extends LocaleSelector {
    private Label flagImage;
    private Button changeFlagImage;
    private String actualLocaleImage = null;

    public FlagLocaleSelector(Composite parent) {
        super(parent);
        this.selectionGroup.setLayoutData((Object)new GridData(1040));
        Composite flagComposite = new Composite((Composite)this.selectionGroup, 0);
        flagComposite.setLayout((Layout)new GridLayout(2, false));
        flagComposite.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.flagImage = new Label(flagComposite, 0);
        this.changeFlagImage = new Button(flagComposite, 0);
        this.changeFlagImage.setText("Set Flag Icon");
        this.changeFlagImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(UIUtils.getShell(), 4096);
                fd.setText("Save");
                String[] filterExt = new String[]{"*.jpg", "*.png", ".gif"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    try {
                        int scaleFactor;
                        Image loadedImage = new Image(null, (InputStream)new FileInputStream(new File(selected)));
                        int width = loadedImage.getImageData().width;
                        int height = loadedImage.getImageData().height;
                        if (width > 16) {
                            scaleFactor = width / 16;
                            width /= scaleFactor;
                            height /= scaleFactor;
                        }
                        if (height > 11) {
                            scaleFactor = height / 11;
                            width /= scaleFactor;
                            height /= scaleFactor;
                        }
                        if (width != loadedImage.getImageData().width || height != loadedImage.getImageData().height) {
                            Image biggerImage = loadedImage;
                            loadedImage = ImageUtils.resize(loadedImage, width, height);
                            biggerImage.dispose();
                        }
                        FlagLocaleSelector.this.disposeOldFlagImage();
                        FlagLocaleSelector.this.flagImage.setImage(loadedImage);
                        FlagLocaleSelector.this.changeFlagImage.setText("Change flag image");
                        FlagLocaleSelector.this.flagImage.getParent().layout(true, true);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    private void disposeOldFlagImage() {
        Image flag = this.flagImage.getImage();
        if (flag != null) {
            flag.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeOldFlagImage();
    }

    public void updateImage(ImageData image, String actualLocale) {
        this.disposeOldFlagImage();
        if (image != null) {
            this.flagImage.setImage(new Image((Device)UIUtils.getDisplay(), image));
        } else {
            this.flagImage.setImage(null);
        }
        this.actualLocaleImage = actualLocale;
        if (image == null) {
            this.changeFlagImage.setText("Set flag image");
        } else {
            this.changeFlagImage.setText("Change flag image");
        }
        this.flagImage.getParent().layout(true, true);
    }

    public ImageData getActualImage() {
        if (this.flagImage.getImage() == null) {
            return null;
        }
        return this.flagImage.getImage().getImageData();
    }

    public String getLangText() {
        return this.langText.getText();
    }

    public String getCountryText() {
        return this.countryText.getText();
    }

    public String getActualLocaleImage() {
        return this.actualLocaleImage;
    }
}

