/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.translation;

import com.jaspersoft.studio.translation.CreateTranslationFragmentCommand;
import com.jaspersoft.studio.translation.ExtendedTranslationInformation;
import com.jaspersoft.studio.translation.ImageLocale;
import com.jaspersoft.studio.translation.JarFileUtils;
import com.jaspersoft.studio.utils.VelocityUtils;
import com.jaspersoft.translation.resources.ITranslationResource;
import com.jaspersoft.translation.resources.TranslationInformation;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class FragmentCreationUtil {
    public static final String SEPARATOR = System.getProperty("file.separator");
    private static final String TEMPLATES_LOCATION_PREFIX = "com/jaspersoft/studio/translation/templates/";
    private static final String MANIFEST_TEMPLATE = "com/jaspersoft/studio/translation/templates/manifestFile.vm";
    private static final String BUILD_TEMPLATE = "com/jaspersoft/studio/translation/templates/buildFile.vm";
    private static final String FRAGMENT_COMMAND_TEMPLATE = "com/jaspersoft/studio/translation/templates/fragmentCommandFile.vm";
    private static final String FRAGMENT_XML_FILE = "com/jaspersoft/studio/translation/templates/fragmentXmlFile.vm";

    public static String generateManifest(ExtendedTranslationInformation pluginInfo, String languagesCodes, boolean isSingleton) {
        VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("hostPlugin", (Object)pluginInfo.getHostPluginName());
        functionContext.put("bundleName", (Object)(String.valueOf(pluginInfo.getBundleName()) + languagesCodes));
        functionContext.put("qualifier", (Object)pluginInfo.getBundleVersion());
        functionContext.put("vendor", (Object)pluginInfo.getBundleProducer());
        String singleton = "";
        if (isSingleton) {
            singleton = ";singleton:=true";
        }
        functionContext.put("singleton", (Object)singleton);
        String hostVersion = "";
        if (!pluginInfo.getHostPluginVersion().trim().isEmpty()) {
            hostVersion = ";bundle-version=\"" + pluginInfo.getHostPluginVersion().trim() + "\"";
        }
        functionContext.put("pluginVersion", (Object)hostVersion);
        Template functionTemplate = ve.getTemplate(MANIFEST_TEMPLATE);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    public static void createBuildFile(TranslationInformation pluginInfo, File pluginDir, List<String> rootFileNames) {
        String buildInclusion = "";
        if (rootFileNames.size() > 0) {
            int i = 0;
            while (i < rootFileNames.size()) {
                buildInclusion = String.valueOf(buildInclusion) + ",\\\n" + rootFileNames.get(i);
                ++i;
            }
        }
        VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("rootFiles", (Object)buildInclusion);
        Template functionTemplate = ve.getTemplate(BUILD_TEMPLATE);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        try {
            FileUtils.writeFile((File)new File(String.valueOf(pluginDir.getAbsolutePath()) + SEPARATOR + "build.properties"), (String)fsw.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createFragmentXml(File destinationDir, List<ImageLocale> locales) {
        String commands = "";
        File iconDir = new File(String.valueOf(destinationDir.getAbsolutePath()) + SEPARATOR + "icons");
        iconDir.mkdirs();
        for (ImageLocale loc : locales) {
            String imagePath = "";
            if (loc.getImage() != null) {
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{loc.getImage()};
                String imageName = String.valueOf(loc.getLocale().toString()) + ".png";
                loader.save(String.valueOf(iconDir.getAbsolutePath()) + SEPARATOR + imageName, 5);
                imagePath = "icons/" + imageName;
            }
            VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();
            VelocityContext commandContext = new VelocityContext();
            commandContext.put("iconpath", (Object)imagePath);
            commandContext.put("languageParameter", (Object)loc.getLocale().toString());
            commandContext.put("languageName", (Object)loc.getLocale().getDisplayLanguage(loc.getLocale()));
            commandContext.put("languageCommandId", (Object)("com.jaspersoft.studio.switchlanguage.menus." + loc.getLocale().getDisplayLanguage(new Locale("en", "EN"))));
            Template commandTemplate = ve.getTemplate(FRAGMENT_COMMAND_TEMPLATE);
            StringWriter fsw = new StringWriter();
            commandTemplate.merge((Context)commandContext, (Writer)fsw);
            commands = String.valueOf(commands) + fsw.toString() + "\n";
        }
        VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();
        VelocityContext fragmentContext = new VelocityContext();
        fragmentContext.put("commands", (Object)commands);
        Template fragmentTemplate = ve.getTemplate(FRAGMENT_XML_FILE);
        StringWriter fsw = new StringWriter();
        fragmentTemplate.merge((Context)fragmentContext, (Writer)fsw);
        try {
            FileUtils.writeFile((File)new File(String.valueOf(destinationDir.getAbsolutePath()) + SEPARATOR + "fragment.xml"), (String)fsw.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getCodesFromLanguage(List<ImageLocale> languagesProvided) {
        String languagesCodes = "";
        for (ImageLocale locale : languagesProvided) {
            languagesCodes = String.valueOf(languagesCodes) + "_" + locale.getLocale().toString();
        }
        return languagesCodes;
    }

    private static void forceCreateFragmentRcp(String destinationPath, List<ImageLocale> languagesProvided) {
        String tmpDirectory = System.getProperty("java.io.tmpdir");
        ArrayList<String> rootFileNames = new ArrayList<String>();
        String rcpPluginName = "com.jaspersoft.studio.rcp";
        File pluginDir = new File(String.valueOf(tmpDirectory) + SEPARATOR + rcpPluginName);
        if (pluginDir.exists()) {
            JarFileUtils.delete(pluginDir);
        }
        pluginDir.mkdirs();
        FragmentCreationUtil.createFragmentXml(pluginDir, languagesProvided);
        rootFileNames.add("fragment.xml");
        rootFileNames.add("icons/");
        TranslationInformation baseInfo = new TranslationInformation(rcpPluginName);
        String version = FragmentCreationUtil.generateQualifier();
        ExtendedTranslationInformation rcpPlugin = CreateTranslationFragmentCommand.generateExtendedInfo(baseInfo, version, "JSSBuilder");
        String languageProvidedIds = FragmentCreationUtil.getCodesFromLanguage(languagesProvided);
        String jarName = String.valueOf(rcpPlugin.getBundleName()) + languageProvidedIds + "_" + rcpPlugin.getBundleVersion() + ".jar";
        FragmentCreationUtil.createBuildFile(rcpPlugin, pluginDir, rootFileNames);
        String manifest = FragmentCreationUtil.generateManifest(rcpPlugin, languageProvidedIds, true);
        JarFileUtils.createJar(destinationPath, pluginDir, jarName, manifest);
    }

    public static String generateQualifier() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private static String getPathFromPackageName(String name) {
        String[] names = name.split("\\.");
        String path = "";
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            path = String.valueOf(path) + packageName + SEPARATOR;
            ++n2;
        }
        return path;
    }

    private static void createPackages(File srcFolder, TranslationInformation plugin) {
        for (ITranslationResource resource : plugin.getResources()) {
            if (resource.isFile()) continue;
            String packageFolderPath = String.valueOf(srcFolder.getAbsolutePath()) + SEPARATOR + FragmentCreationUtil.getPathFromPackageName(resource.getResourceName());
            File packageFolder = new File(packageFolderPath);
            packageFolder.mkdirs();
            for (ITranslationResource packageContent : resource.getChildren()) {
                if (!packageContent.isFile()) continue;
                JarFileUtils.copyFile(new File(packageContent.getResourcePath()), packageFolder);
            }
        }
    }

    public static void createFragment(String destinationPath, List<ExtendedTranslationInformation> translations, List<ImageLocale> languagesProvided) {
        boolean rcpPluginFound = false;
        String tmpDirectory = System.getProperty("java.io.tmpdir");
        String languageProvidedIds = FragmentCreationUtil.getCodesFromLanguage(languagesProvided);
        for (ExtendedTranslationInformation plugin : translations) {
            ArrayList<String> rootFileNames = new ArrayList<String>();
            boolean hasPackage = false;
            File pluginDir = new File(String.valueOf(tmpDirectory) + SEPARATOR + plugin.getPluginName());
            if (pluginDir.exists()) {
                JarFileUtils.delete(pluginDir);
            }
            pluginDir.mkdirs();
            for (ITranslationResource resource : plugin.getResources()) {
                if (resource.isFile()) {
                    rootFileNames.add(resource.getResourceName());
                    JarFileUtils.copyFile(new File(resource.getResourcePath()), pluginDir);
                    continue;
                }
                hasPackage = true;
            }
            if (hasPackage) {
                FragmentCreationUtil.createPackages(pluginDir, plugin);
            }
            String manifest = "";
            if (plugin.getHostPluginName().equals("com.jaspersoft.studio.rcp")) {
                rcpPluginFound = true;
                FragmentCreationUtil.createFragmentXml(pluginDir, languagesProvided);
                rootFileNames.add("fragment.xml");
                rootFileNames.add("icons/");
                manifest = FragmentCreationUtil.generateManifest(plugin, languageProvidedIds, true);
            } else {
                manifest = FragmentCreationUtil.generateManifest(plugin, languageProvidedIds, false);
            }
            String jarName = String.valueOf(plugin.getBundleName()) + languageProvidedIds + "_" + plugin.getBundleVersion() + ".jar";
            FragmentCreationUtil.createBuildFile(plugin, pluginDir, rootFileNames);
            JarFileUtils.createJar(destinationPath, pluginDir, jarName, manifest);
        }
        if (!rcpPluginFound) {
            FragmentCreationUtil.forceCreateFragmentRcp(destinationPath, languagesProvided);
        }
    }
}

