/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.translation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarFileUtils {
    public static void copyFile(File sourceFile, File targetDir) {
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File copy = new File(String.valueOf(targetDir.getAbsolutePath()) + File.separatorChar + sourceFile.getName());
        FileInputStream is = null;
        if (!copy.exists()) {
            try {
                try {
                    is = new FileInputStream(sourceFile);
                    FileOutputStream fwr = new FileOutputStream(copy);
                    copy.createNewFile();
                    try {
                        int read;
                        byte[] buff = new byte[1024];
                        while ((read = ((InputStream)is).read(buff)) != -1) {
                            fwr.write(buff, 0, read);
                        }
                    }
                    finally {
                        fwr.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                String[] stringArray = files = file.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(file, temp);
                    JarFileUtils.delete(fileDelete);
                    ++n2;
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    private static void add(File source, JarOutputStream target, String basePath) throws IOException {
        try (BufferedInputStream in = null;){
            int count;
            String name = source.getPath().substring(basePath.length() + 1).replace("\\", "/");
            if (source.isDirectory()) {
                File[] fileArray = source.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File nestedFile = fileArray[n2];
                    JarFileUtils.add(nestedFile, target, basePath);
                    ++n2;
                }
                return;
            }
            JarEntry entry = new JarEntry(name);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }

    public static void createJar(String destination, File pluginDir, String fileName, String manifestContent) {
        try {
            Manifest manifest = new Manifest(new ByteArrayInputStream(manifestContent.getBytes("UTF-8")));
            JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(String.valueOf(destination) + File.separatorChar + fileName), manifest);
            File[] fileArray = pluginDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File children = fileArray[n2];
                try {
                    JarFileUtils.add(children, target, pluginDir.getAbsolutePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            target.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String deserializeString(File file) {
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        try (FileReader reader = new FileReader(file);){
            int len;
            while ((len = reader.read(chr)) > 0) {
                buffer.append(chr, 0, len);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buffer.toString();
    }

    public static void createPluginJar(String destination, File pluginDir, String fileName, String manifestContent) {
        try {
            Manifest manifest = new Manifest(new ByteArrayInputStream(manifestContent.getBytes("UTF-8")));
            JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(String.valueOf(destination) + File.separatorChar + fileName), manifest);
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(new File(pluginDir, "build.properties"));
            prop.load(in);
            String[] files = prop.getProperty("bin.includes").split(",");
            List<String> filesToAdd = Arrays.asList(files);
            File[] fileArray = pluginDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File children = fileArray[n2];
                try {
                    String currentFileName = children.getName();
                    if (children.isFile()) {
                        if (filesToAdd.contains(currentFileName)) {
                            JarFileUtils.add(children, target, pluginDir.getAbsolutePath());
                        }
                    } else if (!currentFileName.equals("META-INF") && filesToAdd.contains(String.valueOf(currentFileName) + "/")) {
                        JarFileUtils.add(children, target, pluginDir.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            File binFolder = new File(pluginDir, "bin");
            File[] fileArray2 = binFolder.listFiles();
            int n3 = fileArray2.length;
            n = 0;
            while (n < n3) {
                File children = fileArray2[n];
                try {
                    JarFileUtils.add(children, target, binFolder.getAbsolutePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n;
            }
            target.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

