/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.swt.SWTResourceManager;

public class Colors {
    private static final Properties htmlColorNames;
    public static final Pattern HEX_COLOR_PATTERN;

    static {
        HEX_COLOR_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
        htmlColorNames = new Properties();
        InputStream in = null;
        try {
            try {
                in = Colors.class.getResourceAsStream("htmlColorNames.properties");
                htmlColorNames.load(in);
            }
            catch (IOException ex) {
                JaspersoftStudioPlugin.getInstance().logError(ex);
                if (in != null) {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
        finally {
            if (in != null) {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public static Color getSWT4AWTColor(java.awt.Color color) {
        if (color != null) {
            return SWTResourceManager.getColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
        }
        return null;
    }

    public static java.awt.Color getAWT4SWTColor(Color color) {
        if (color != null) {
            return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
        }
        return null;
    }

    public static AlfaRGB getSWTRGB4AWTGBColor(java.awt.Color color) {
        if (color != null) {
            return new AlfaRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()), color.getAlpha());
        }
        return null;
    }

    public static java.awt.Color getAWT4SWTRGBColor(AlfaRGB color) {
        if (color != null && color.getRgb() != null) {
            return new java.awt.Color(color.getRgb().red, color.getRgb().green, color.getRgb().blue, color.getAlfa());
        }
        return null;
    }

    public static RGB getRGB4AWTColor(java.awt.Color color) {
        if (color != null) {
            return new RGB(color.getRed(), color.getGreen(), color.getBlue());
        }
        return null;
    }

    public static String getHexEncodedAWTColor(java.awt.Color awtColor) {
        if (awtColor == null) {
            return "";
        }
        String nums = "0123456789ABCDEF";
        String s = "#";
        s = String.valueOf(s) + nums.charAt(awtColor.getRed() / 16);
        s = String.valueOf(s) + nums.charAt(awtColor.getRed() % 16);
        s = String.valueOf(s) + nums.charAt(awtColor.getGreen() / 16);
        s = String.valueOf(s) + nums.charAt(awtColor.getGreen() % 16);
        s = String.valueOf(s) + nums.charAt(awtColor.getBlue() / 16);
        s = String.valueOf(s) + nums.charAt(awtColor.getBlue() % 16);
        return s;
    }

    public static String getHexEncodedSWTColor(Color swtColor) {
        if (swtColor == null) {
            return "";
        }
        return Colors.getHexEncodedAWTColor(Colors.getAWT4SWTColor(swtColor));
    }

    public static String getHexEncodedRGBColor(RGB rgbColor) {
        if (rgbColor == null) {
            return "";
        }
        return Colors.getHexEncodedAWTColor(Colors.getAWT4SWTRGBColor(AlfaRGB.getFullyOpaque(rgbColor)));
    }

    public static String getHexEncodedRGBColor(AlfaRGB alfaRgbColor) {
        if (alfaRgbColor == null) {
            return "";
        }
        return Colors.getHexEncodedAWTColor(Colors.getAWT4SWTRGBColor(alfaRgbColor));
    }

    public static String getRGBAEncodedRGBColor(AlfaRGB alfaRgbColor) {
        if (alfaRgbColor == null) {
            return "";
        }
        RGB rgb = alfaRgbColor.getRgb();
        return "rgba(" + rgb.red + "," + rgb.green + "," + rgb.blue + "," + alfaRgbColor.getAlfa() + ")";
    }

    public static Image getSWTColorPreview(java.awt.Color color, int width, int height) {
        RGB black = new RGB(0, 0, 0);
        RGB white = new RGB(255, 255, 255);
        ImageData data = null;
        if (color == null) {
            PaletteData dataPalette = new PaletteData(new RGB[]{black, black, white});
            data = new ImageData(width, height, 4, dataPalette);
            data.transparentPixel = 0;
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    if (y == 0 || y == data.height - 1 || x == 0 || x == data.width - 1) {
                        data.setPixel(x, y, 1);
                    } else if (y % 3 == 0 || x % 3 == 0) {
                        data.setPixel(x, y, 1);
                    } else {
                        data.setPixel(x, y, 2);
                    }
                    ++x;
                }
                ++y;
            }
        } else {
            AlfaRGB rgb = Colors.getSWTRGB4AWTGBColor(color);
            PaletteData dataPalette = new PaletteData(new RGB[]{black, black, rgb.getRgb()});
            data = new ImageData(width, height, 4, dataPalette);
            data.transparentPixel = 0;
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    if (x == 0 || y == 0 || x == data.width - 1 || y == data.height - 1) {
                        data.setPixel(x, y, 1);
                    } else {
                        data.setPixel(x, y, 2);
                    }
                    ++x;
                }
                ++y;
            }
        }
        Image image = new Image((Device)UIUtils.getDisplay(), data);
        return image;
    }

    public static java.awt.Color decodeColor(String colorString) {
        java.awt.Color color = null;
        if (colorString.length() > 0) {
            try {
                color = new java.awt.Color(Integer.parseInt(colorString, 16));
            }
            catch (Exception exception) {}
        }
        return color;
    }

    public static String getEncodedColor(java.awt.Color awtColor) {
        String s = Colors.getHexEncodedAWTColor(awtColor);
        if (s != null && !s.isEmpty()) {
            return s.substring(1);
        }
        return s;
    }

    public static java.awt.Color decodeHexStringAsAWTColor(String hexColorString) {
        RGB decodedRGB = Colors.decodeHexStringAsSWTRGB(hexColorString);
        if (decodedRGB != null) {
            return Colors.getAWT4SWTRGBColor(AlfaRGB.getFullyOpaque(decodedRGB));
        }
        return null;
    }

    public static RGB decodeHexStringAsSWTRGB(String hexColorString) {
        RGB rgb = null;
        if (hexColorString != null && hexColorString.startsWith("#") && hexColorString.length() == 7) {
            int red = Integer.parseInt(hexColorString.substring(1, 3), 16);
            int green = Integer.parseInt(hexColorString.substring(3, 5), 16);
            int blue = Integer.parseInt(hexColorString.substring(5, 7), 16);
            rgb = new RGB(red, green, blue);
        }
        return rgb;
    }

    public static String[] decodeHexColorsArray(String hexColorsArray) {
        if (hexColorsArray == null) {
            return new String[0];
        }
        Matcher m = HEX_COLOR_PATTERN.matcher(hexColorsArray);
        ArrayList<String> listMatches = new ArrayList<String>();
        while (m.find()) {
            listMatches.add(m.group(0));
        }
        return listMatches.toArray(new String[listMatches.size()]);
    }

    public static String encodeHexColorsAsArray(String[] colors) {
        StringBuffer sb = new StringBuffer();
        if (colors != null && colors.length > 0) {
            String separator = "";
            sb.append("[");
            String[] stringArray = colors;
            int n = colors.length;
            int n2 = 0;
            while (n2 < n) {
                String col = stringArray[n2];
                sb.append(separator);
                separator = ",";
                sb.append("'").append(col).append("'");
                ++n2;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static String getHtmlColorName(String hex) {
        if (!StringUtils.isEmpty((String)hex)) {
            for (String p : htmlColorNames.stringPropertyNames()) {
                if (!htmlColorNames.getProperty(p).equalsIgnoreCase(hex)) continue;
                return p;
            }
        }
        return null;
    }

    public static String getHtmlColorHex(String name) {
        if (!StringUtils.isEmpty((String)name)) {
            return htmlColorNames.getProperty(name.toLowerCase());
        }
        return null;
    }
}

