/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.control.VErrorPreview;
import com.jaspersoft.studio.utils.ErrorUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.xml.SourceLocation;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class Console {
    private MessageConsole console;
    private List<VErrorPreview> ePreviews = new ArrayList<VErrorPreview>();
    private JasperReportsConfiguration jConfig;
    public static Color REDCOLOR = Display.getDefault().getSystemColor(3);

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static Console showConsole(String name, JasperReportsConfiguration jConfig) {
        MessageConsole myConsole = Console.findConsole(name);
        final Console c = new Console(myConsole, jConfig);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                c.showConsole();
            }
        });
        return c;
    }

    public void showConsole() {
        try {
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.jaspersoft.studio.editor.preview.reportstate");
            }
        }
        catch (PartInitException e) {
            UIUtils.showError((Throwable)e);
        }
    }

    private Console(MessageConsole console, JasperReportsConfiguration jConfig) {
        this.console = console;
        this.jConfig = jConfig;
    }

    public void addErrorPreview(VErrorPreview ep) {
        if (ep != null) {
            ep.setReportContext(this.jConfig);
            this.ePreviews.add(ep);
        }
    }

    public void removeErrorPreview(VErrorPreview ep) {
        this.ePreviews.remove(ep);
    }

    public void addError(final Throwable e, final JasperDesign design) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageConsoleStream out = Console.this.console.newMessageStream();
                Color color = out.getColor();
                out.setColor(color);
                out.println(String.valueOf(ErrorUtil.getStackTrace(e)) + "\n\r");
                out.setColor(REDCOLOR);
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.addError(e, design);
                }
            }
        });
    }

    public void addMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageConsoleStream out = Console.this.console.newMessageStream();
                out.println(message);
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.addMessage(message);
                }
            }
        });
    }

    public void startMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageConsoleStream out = Console.this.console.newMessageStream();
                out.print(message);
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.startMessage(message);
                }
            }
        });
    }

    public void addProblem(final IProblem problem, final SourceLocation location) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.addProblem(problem, location);
                }
            }
        });
    }

    public void addProblem(final IProblem problem, final SourceLocation location, final JRExpression expr) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.addProblem(problem, location, expr);
                }
            }
        });
    }

    public void addProblem(final String message, final SourceLocation location, final JRDesignElement element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.addProblem(message, location, element);
                }
            }
        });
    }

    public void addProblem(final String message, final SourceLocation location) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.addProblem(message, location);
                }
            }
        });
    }

    public void setStatistics(final Statistics stats) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.setStats(stats);
                }
            }
        });
    }

    public void clearConsole() {
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.setStats(null);
                }
                Console.this.console.clearConsole();
                for (VErrorPreview vep : Console.this.ePreviews) {
                    vep.clear();
                }
            }
        });
    }
}

