/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.eclipse.osgi.util.NLS;

public class EnumHelper {
    public static String[] getEnumValues(Class<? extends NamedEnum> enumClazz) {
        NamedEnum[] enumConstants = enumClazz.getEnumConstants();
        ArrayList<String> values = new ArrayList<String>();
        NamedEnum[] namedEnumArray = enumConstants;
        int n = enumConstants.length;
        int n2 = 0;
        while (n2 < n) {
            NamedEnum positionEnum = namedEnumArray[n2];
            values.add(positionEnum.getName());
            ++n2;
        }
        return values.toArray(new String[values.size()]);
    }

    public static String[][] getEnumLabelsAndValues(Class<? extends NamedEnum> enumClazz) {
        String[] labels = EnumHelper.getEnumNames(enumClazz, NullEnum.NOTNULL);
        String[] values = EnumHelper.getEnumValues(enumClazz);
        return EnumHelper.getEnumLabelsAndValues(labels, values);
    }

    public static String[][] getEnumLabelsAndValues(String[] labels, String[] values) {
        if (labels != null && values != null && labels.length == values.length) {
            String[][] results = new String[labels.length][2];
            int i = 0;
            while (i < values.length) {
                results[i][0] = values[i];
                results[i][1] = labels[i];
                ++i;
            }
            return results;
        }
        throw new RuntimeException("Impossible to match the labels and values");
    }

    public static String[] getEnumNames(Class<? extends NamedEnum> enumClazz, NullEnum type) {
        NamedEnum[] enums = enumClazz.getEnumConstants();
        return EnumHelper.getEnumNames(enums, type);
    }

    public static String[] getEnumNames(NamedEnum[] namedEnum, NullEnum nullable, Integer ... skipPositions) {
        ArrayList<String> res = new ArrayList<String>();
        if (nullable != NullEnum.NOTNULL) {
            res.add(nullable.getName());
        }
        int i = 0;
        while (i < namedEnum.length) {
            boolean skip = false;
            int j = 0;
            while (j < skipPositions.length) {
                if (i == skipPositions[j]) {
                    skip = true;
                }
                ++j;
            }
            if (!skip) {
                res.add(MessagesByKeys.getString(namedEnum[i].getName()));
            }
            ++i;
        }
        return res.toArray(new String[res.size()]);
    }

    public static LinkedHashMap<Object, String> getEnumMapNames(NamedEnum[] namedEnum, NullEnum nullable) {
        LinkedHashMap<Object, String> res = new LinkedHashMap<Object, String>();
        if (nullable != NullEnum.NOTNULL) {
            res.put((Object)NullEnum.NOTNULL, nullable.getName());
        }
        int i = 0;
        while (i < namedEnum.length) {
            res.put(namedEnum[i], MessagesByKeys.getString(namedEnum[i].getName()));
            ++i;
        }
        return res;
    }

    public static String[] getEnumNames(NamedEnum[] namedEnum, NullEnum nullable) {
        ArrayList<String> res = new ArrayList<String>();
        if (nullable != NullEnum.NOTNULL) {
            res.add(nullable.getName());
        }
        int i = 0;
        while (i < namedEnum.length) {
            res.add(MessagesByKeys.getString(namedEnum[i].getName()));
            ++i;
        }
        return res.toArray(new String[res.size()]);
    }

    public static <T extends NamedEnum> T getEnumByObjectValue(T[] enums, Object objValue) {
        return (T)EnumHelper.getEnumByObjectValue(enums, (Object)objValue, (boolean)false);
    }

    public static <T extends NamedEnum> T getEnumByObjectValue(T[] enums, Object objValue, boolean isNullable) {
        if (objValue == null) {
            return null;
        }
        if (objValue instanceof NamedEnum) {
            NamedEnum foundEnum = (NamedEnum)objValue;
            return (T)foundEnum;
        }
        if (objValue instanceof String) {
            T[] TArray = enums;
            int n = enums.length;
            int n2 = 0;
            while (n2 < n) {
                T e = TArray[n2];
                if (objValue.equals(MessagesByKeys.getString(e.getName()))) {
                    return e;
                }
                ++n2;
            }
            return null;
        }
        if (objValue instanceof Number) {
            Integer val = ((Number)objValue).intValue();
            if (val < 0 || val > enums.length) {
                return null;
            }
            if (isNullable) {
                if (val == 0) {
                    return null;
                }
                return enums[val - 1];
            }
            return enums[val];
        }
        throw new UnsupportedOperationException(NLS.bind((String)"Cannot convert the object of type {0} to a valid instance of NamedEnum.", (Object)objValue.getClass().getCanonicalName()));
    }

    public static int getEnumIndexByTranslatedName(String[] enumNames, NamedEnum namedEnum) {
        if (namedEnum == null) {
            return 0;
        }
        String translation = EnumHelper.getEnumTranslation(namedEnum);
        int i = 0;
        while (i < enumNames.length) {
            if (enumNames[i].equals(translation)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static String getEnumTranslation(NamedEnum nameEnum) {
        return MessagesByKeys.getString(nameEnum.getName());
    }

    public static Integer getIntValueForCombo(Enum<?> jrEnum, boolean isNullable) {
        if (jrEnum == null) {
            return 0;
        }
        Enum[] jrEnums = (Enum[])jrEnum.getDeclaringClass().getEnumConstants();
        int ind = 0;
        while (ind < jrEnums.length) {
            if (jrEnums[ind] == jrEnum) break;
            ++ind;
        }
        return isNullable ? ind + 1 : ind;
    }
}

