/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class JRXMLUtils {
    public static InputStream getJRXMLInputStream(JasperReportsContext jrContext, InputStream in, String fileExtension, String encoding, String version) throws JRException {
        if (fileExtension != null && fileExtension.equals("jasper")) {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)in);
            try {
                String str = JRXmlWriterHelper.writeReport(jrContext, (JRReport)report, JRXmlWriterHelper.fixencoding(encoding), version);
                return new ByteArrayInputStream(str.getBytes());
            }
            catch (Exception e) {
                UIUtils.showError((String)"Something goes wrong while trying to create a JRXML input stream from a .jasper one.", (Throwable)e);
            }
        }
        return in;
    }

    public static JasperDesign getJasperDesign(JasperReportsConfiguration jrContext, InputStream in, String fileExtension) throws JRException {
        if (fileExtension != null) {
            if (fileExtension.equals("jasper")) {
                JasperReport jr = (JasperReport)JRLoader.loadObject((InputStream)in);
                return JRXmlLoader.load((InputStream)new ByteArrayInputStream(JRXmlWriter.writeReport((JRReport)jr, (String)"UTF-8").getBytes()));
            }
            if (fileExtension.equals("jrxml")) {
                return JRXmlLoader.load((JasperReportsContext)jrContext, (InputStream)in);
            }
        } else {
            BufferedInputStream bis = new BufferedInputStream(in);
            bis.mark(Integer.MAX_VALUE);
            try {
                JasperDesign jasperDesign = JRXmlLoader.load((JasperReportsContext)jrContext, (InputStream)bis);
                return jasperDesign;
            }
            catch (Exception exception) {
                try {
                    bis.reset();
                }
                catch (IOException e1) {
                    UIUtils.showError((Throwable)e1);
                }
                JasperReport jr = (JasperReport)JRLoader.loadObject((InputStream)bis);
                JasperDesign jasperDesign = JRXmlLoader.load((InputStream)new ByteArrayInputStream(JRXmlWriter.writeReport((JRReport)jr, (String)"UTF-8").getBytes()));
                return jasperDesign;
            }
            finally {
                FileUtils.closeStream((Closeable)bis);
            }
        }
        return null;
    }

    public static InputStream getXML(JasperReportsConfiguration jrContext, IEditorInput editorInput, String encoding, InputStream in, String version) throws JRException {
        String fileExtension = JRXMLUtils.getFileExtension(editorInput);
        InputStream jrxmlInputStream = JRXMLUtils.getJRXMLInputStream((JasperReportsContext)jrContext, in, fileExtension, encoding, version);
        return jrxmlInputStream != null ? jrxmlInputStream : in;
    }

    public static String getFileExtension(IEditorInput editorInput) {
        String fileExtention = "";
        if (editorInput instanceof FileStoreEditorInput) {
            String path = ((FileStoreEditorInput)editorInput).getURI().getPath();
            fileExtention = path.substring(path.lastIndexOf(".") + 1, path.length());
        } else if (editorInput instanceof IFileEditorInput) {
            fileExtention = ((IFileEditorInput)editorInput).getFile().getFileExtension();
        } else if (editorInput instanceof JarEntryEditorInput) {
            fileExtention = ((JarEntryEditorInput)editorInput).getStorage().getFullPath().getFileExtension();
        }
        return fileExtention;
    }
}

