/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MDummy;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.dataset.MElementDataset;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.QueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.resource.ImageDescriptor;

public class ModelUtils {
    public static final String[] FONT_SIZES = new String[]{"", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26"};
    public static final String MAIN_DATASET = Messages.ModelUtils_13;
    private static final String[] DEFAULT_LANGUAGES = new String[]{"groovy", "java", "javascript"};
    private static Map<String, String> mp = new HashMap<String, String>();
    private static List<String> pdfencodings;
    private static Set<String> deprecatedLanguages;

    static {
        deprecatedLanguages = new HashSet<String>();
        deprecatedLanguages.add("xlsx");
        deprecatedLanguages.add("xpath2");
        deprecatedLanguages.add("ad hoc query api");
    }

    public static JRDesignDataset getDataset(ANode node) {
        ANode n = node.getParent();
        while (n != null) {
            JRElementDataset elementDS;
            JRDatasetRun datasetRun;
            if (n instanceof MDataset) {
                return ((MDataset)n).getValue();
            }
            if (n instanceof MReport) {
                return (JRDesignDataset)((MReport)n).getValue().getMainDataset();
            }
            if (n instanceof MElementDataset && (datasetRun = (elementDS = (JRElementDataset)n.getValue()).getDatasetRun()) != null) {
                return (JRDesignDataset)node.getJasperDesign().getDatasetMap().get(datasetRun.getDatasetName());
            }
            n = n.getParent();
        }
        return null;
    }

    public static JRDesignDataset getFirstDatasetInHierarchy(ANode node) {
        ANode n = node.getParent();
        while (n != null) {
            ANode realParent;
            if (n instanceof MPage && (realParent = ((MPage)n).getRealParent()) != null) {
                n = realParent;
            }
            if (n instanceof MDataset) {
                return ((MDataset)n).getValue();
            }
            if (n instanceof MReport) {
                return (JRDesignDataset)((MReport)n).getValue().getMainDataset();
            }
            if (n instanceof IDatasetContainer) {
                List<MDatasetRun> datasets = ((IDatasetContainer)((Object)n)).getDatasetRunList();
                JasperDesign design = n.getJasperDesign();
                for (MDatasetRun parentDataset : datasets) {
                    JRDesignDataset dataset = (JRDesignDataset)design.getDatasetMap().get(parentDataset.getValue().getDatasetName());
                    if (dataset == null) continue;
                    return dataset;
                }
            }
            n = n.getParent();
        }
        return null;
    }

    public static ANode getFirstChild(ANode parent) {
        List<INode> children = parent.getChildren();
        if (children != null && !children.isEmpty()) {
            return (ANode)children.get(0);
        }
        return null;
    }

    public static JasperDesign copyJasperDesign(JasperReportsContext jContext, JasperDesign jrd) throws JRException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JRSaver.saveObject((Object)jrd, (OutputStream)out);
        JasperDesign jd = (JasperDesign)JRLoader.loadObject((JasperReportsContext)jContext, (InputStream)new ByteArrayInputStream(out.toByteArray()));
        return jd;
    }

    public static JRBand getGroupFooter(JRGroup group) {
        JRBand[] footers;
        if (group.getGroupFooterSection() != null && (footers = group.getGroupFooterSection().getBands()) != null && footers.length > 0) {
            return footers[0];
        }
        return null;
    }

    public static int getBetweenIndex(ANode parent, Point point) {
        ILayout layout;
        String layoutClassName;
        JRPropertiesHolder holder = LayoutManager.getPropertyHolder(parent);
        if (holder != null && (layoutClassName = holder.getPropertiesMap().getProperty("com.jaspersoft.studio.layout")) != null && (layout = LayoutManager.getLayout(layoutClassName)) != null) {
            return layout.getInsertPosition(parent, point);
        }
        return -1;
    }

    public static org.eclipse.swt.graphics.Color getSWTColorFromAWT(Color awtColor) {
        return new org.eclipse.swt.graphics.Color(null, awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
    }

    public static String[] getDataSets(JasperDesign jd, boolean includeMainDataset) {
        ArrayList<JRDataset> datasetsList = new ArrayList<JRDataset>(jd.getDatasetsList());
        if (includeMainDataset) {
            datasetsList.add(0, jd.getMainDataset());
        }
        String[] res = new String[datasetsList.size()];
        int i = 0;
        while (i < datasetsList.size()) {
            String name = ((JRDataset)datasetsList.get(i)).getName();
            if (datasetsList.get(i) == jd.getMainDataset()) {
                name = MAIN_DATASET;
            }
            res[i] = name;
            ++i;
        }
        return res;
    }

    public static List<Object> getReportObjects4Datasource(JasperDesign jd, String ds) {
        ArrayList<Object> inFields = new ArrayList<Object>();
        inFields.addAll(ModelUtils.getFields4Datasource(jd, ds));
        inFields.addAll(ModelUtils.getVariables4Datasource(jd, ds));
        inFields.addAll(ModelUtils.getParameters4Datasource(jd, ds));
        return inFields;
    }

    public static List<Object> getReportObjects4Datasource(JRDataset ds) {
        ArrayList<Object> inFields = new ArrayList<Object>();
        inFields.addAll(Arrays.asList(ds.getFields()));
        inFields.addAll(Arrays.asList(ds.getVariables()));
        inFields.addAll(Arrays.asList(ds.getParameters()));
        return inFields;
    }

    public static List<JRParameter> getParameters4Datasource(JasperDesign jd, String ds) {
        if (ds == null || ds.equals("")) {
            ArrayList<JRParameter> res = new ArrayList<JRParameter>(jd.getParametersList());
            return res;
        }
        List datasetsList = jd.getDatasetsList();
        int i = 0;
        while (i < datasetsList.size()) {
            JRDesignDataset d = (JRDesignDataset)datasetsList.get(i);
            if (d.getName().equals(ds)) {
                List fieldsList = d.getParametersList();
                ArrayList<JRParameter> res = new ArrayList<JRParameter>(fieldsList);
                return res;
            }
            ++i;
        }
        return new ArrayList<JRParameter>();
    }

    public static int getChildrenPosition(INode child) {
        if (child != null && child.getParent() != null) {
            return child.getParent().getChildren().indexOf(child);
        }
        return -1;
    }

    public static List<JRVariable> getVariables4Datasource(JasperDesign jd, String ds) {
        if (ds == null || ds.equals("")) {
            List fieldsList = jd.getVariablesList();
            ArrayList<JRVariable> res = new ArrayList<JRVariable>(fieldsList);
            return res;
        }
        List datasetsList = jd.getDatasetsList();
        int i = 0;
        while (i < datasetsList.size()) {
            JRDesignDataset d = (JRDesignDataset)datasetsList.get(i);
            if (d.getName().equals(ds)) {
                List fieldsList = d.getVariablesList();
                ArrayList<JRVariable> res = new ArrayList<JRVariable>(fieldsList);
                return res;
            }
            ++i;
        }
        return new ArrayList<JRVariable>();
    }

    public static List<JRField> getFields4Datasource(JasperDesign jd, String ds) {
        if (ds == null || ds.equals("")) {
            List fieldsList = jd.getFieldsList();
            ArrayList<JRField> res = new ArrayList<JRField>(fieldsList);
            return res;
        }
        List datasetsList = jd.getDatasetsList();
        int i = 0;
        while (i < datasetsList.size()) {
            JRDesignDataset d = (JRDesignDataset)datasetsList.get(i);
            if (d.getName().equals(ds)) {
                List fieldsList = d.getFieldsList();
                ArrayList<JRField> res = new ArrayList<JRField>(fieldsList);
                return res;
            }
            ++i;
        }
        return new ArrayList<JRField>();
    }

    public static JRDesignExpression createExpression(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText(text);
        return exp;
    }

    public static List<JRBand> getBands(JasperDesign jd) {
        int k;
        JRBand[] bandsList;
        ArrayList<JRBand> list = new ArrayList<JRBand>();
        if (jd == null) {
            return list;
        }
        JRGroup[] groups = jd.getGroups();
        if (jd.getTitle() != null) {
            list.add(jd.getTitle());
        }
        if (jd.getPageHeader() != null) {
            list.add(jd.getPageHeader());
        }
        if (jd.getColumnHeader() != null) {
            list.add(jd.getColumnHeader());
        }
        int i = 0;
        while (i < groups.length) {
            if (groups[i].getGroupHeaderSection() != null) {
                bandsList = groups[i].getGroupHeaderSection().getBands();
                k = 0;
                while (bandsList != null && k < bandsList.length) {
                    if (bandsList[k] != null) {
                        list.add(bandsList[k]);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (jd.getDetailSection() != null) {
            JRBand[] bandsList2 = jd.getDetailSection().getBands();
            int k2 = 0;
            while (bandsList2 != null && k2 < bandsList2.length) {
                if (bandsList2[k2] != null) {
                    list.add(bandsList2[k2]);
                }
                ++k2;
            }
        }
        i = groups.length - 1;
        while (i >= 0) {
            if (groups[i].getGroupFooterSection() != null) {
                bandsList = groups[i].getGroupFooterSection().getBands();
                k = 0;
                while (bandsList != null && k < bandsList.length) {
                    if (bandsList[k] != null) {
                        list.add(bandsList[k]);
                    }
                    ++k;
                }
            }
            --i;
        }
        if (jd.getColumnFooter() != null) {
            list.add(jd.getColumnFooter());
        }
        if (jd.getPageFooter() != null) {
            list.add(jd.getPageFooter());
        }
        if (jd.getLastPageFooter() != null) {
            list.add(jd.getLastPageFooter());
        }
        if (jd.getSummary() != null) {
            list.add(jd.getSummary());
        }
        if (jd.getNoData() != null) {
            list.add(jd.getNoData());
        }
        if (jd.getBackground() != null) {
            list.add(jd.getBackground());
        }
        return list;
    }

    public static int getDesignHeight(JasperDesign jd) {
        int designHeight = 0;
        if (jd != null) {
            designHeight += jd.getTopMargin();
            designHeight += ModelUtils.getDesignHeight(ModelUtils.getAllBands(jd));
            designHeight += jd.getBottomMargin();
        }
        return designHeight;
    }

    public static int getDesignHeight(List<JRBand> bands) {
        int designHeight = 0;
        for (JRBand b : bands) {
            designHeight += b.getHeight();
        }
        return designHeight;
    }

    public static boolean elementExists(JRBand jrBand, JRElement jrElement) {
        JRElement[] elements = jrBand.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] == jrElement) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int getBand4Element(List<JRBand> bands, JRElement jrElement) {
        int i = 0;
        while (i < bands.size()) {
            JRBand cBand = bands.get(i);
            if (cBand != null && ModelUtils.elementExists(cBand, jrElement)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<JRBand> getAllBands(JasperDesign jrDesign) {
        JRBand[] bandsList;
        ArrayList<JRBand> bands = new ArrayList<JRBand>();
        if (jrDesign.getTitle() != null) {
            bands.add(jrDesign.getTitle());
        }
        if (jrDesign.getPageHeader() != null) {
            bands.add(jrDesign.getPageHeader());
        }
        if (jrDesign.getColumnHeader() != null) {
            bands.add(jrDesign.getColumnHeader());
        }
        if (jrDesign.getGroups() != null) {
            for (Object g : jrDesign.getGroupsList()) {
                JRDesignGroup gr = (JRDesignGroup)g;
                if (gr.getGroupHeaderSection() == null) continue;
                bands.addAll(((JRDesignSection)gr.getGroupHeaderSection()).getBandsList());
            }
        }
        if (jrDesign.getDetailSection() != null && (bandsList = jrDesign.getDetailSection().getBands()) != null) {
            bands.addAll(Arrays.asList(bandsList));
        }
        if (jrDesign.getGroupsList() != null) {
            ListIterator ij = jrDesign.getGroupsList().listIterator(jrDesign.getGroupsList().size());
            while (ij.hasPrevious()) {
                JRDesignGroup gr = (JRDesignGroup)ij.previous();
                if (gr.getGroupFooterSection() == null) continue;
                bands.addAll(((JRDesignSection)gr.getGroupFooterSection()).getBandsList());
            }
        }
        if (jrDesign.getColumnFooter() != null) {
            bands.add(jrDesign.getColumnFooter());
        }
        if (jrDesign.getPageFooter() != null) {
            bands.add(jrDesign.getPageFooter());
        }
        if (jrDesign.getLastPageFooter() != null) {
            bands.add(jrDesign.getLastPageFooter());
        }
        if (jrDesign.getSummary() != null) {
            bands.add(jrDesign.getSummary());
        }
        if (jrDesign.getNoData() != null) {
            bands.add(jrDesign.getNoData());
        }
        if (jrDesign.getBackground() != null) {
            bands.add(jrDesign.getBackground());
        }
        return bands;
    }

    public static List<JRCrosstab> getAllCrosstabs(JasperDesign jrDesign) {
        List<JRDesignElement> allElements = ModelUtils.getAllElements(jrDesign);
        ArrayList<JRCrosstab> allCrosstabs = new ArrayList<JRCrosstab>();
        for (JRDesignElement el : allElements) {
            if (!(el instanceof JRCrosstab)) continue;
            allCrosstabs.add((JRCrosstab)el);
        }
        return allCrosstabs;
    }

    public static MBand getBand4Point(INode jd, Point point) {
        INode res = jd;
        INode rNode = jd;
        int xband = jd.getJasperDesign().getTopMargin();
        for (INode n : rNode.getChildren()) {
            Object de;
            if (!(n instanceof IGraphicElement) || !((de = n.getValue()) instanceof JRDesignBand)) continue;
            JRDesignBand deband = (JRDesignBand)de;
            res = (ANode)n;
            if (point.y >= xband && point.y < xband + deband.getHeight()) break;
            xband += deband.getHeight();
        }
        if (res instanceof MBand) {
            return (MBand)res;
        }
        return null;
    }

    public static MGraphicElement getElement4Point(ANode parent, Point point) {
        return null;
    }

    public static int getBandLocation(JRBand b, JasperDesign jd) {
        int yLocation = jd.getTopMargin();
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand tmpBand : bands) {
            if (tmpBand instanceof JRDesignBand) {
                ((JRDesignBand)tmpBand).getOrigin().getBandTypeValue().equals((Object)BandTypeEnum.BACKGROUND);
            }
            if (tmpBand == b) {
                return yLocation;
            }
            yLocation += tmpBand.getHeight();
        }
        return yLocation;
    }

    public static Point getY4Element(MGraphicElement mge) {
        JasperDesign jrDesign = mge.getJasperDesign();
        JRDesignElement jrElement = mge.getValue();
        int y = jrElement.getY() + jrDesign.getTopMargin();
        List<JRBand> bands = ModelUtils.getAllBands(jrDesign);
        int pos = ModelUtils.getBand4Element(bands, (JRElement)jrElement);
        int i = 0;
        while (i < pos) {
            y += bands.get(i).getHeight();
            ++i;
        }
        int x = jrElement.getX() + jrDesign.getLeftMargin();
        return new Point(x, y);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        JaspersoftStudioPlugin.getInstance();
        return JaspersoftStudioPlugin.getInstance().getImageDescriptor(path);
    }

    public static String nameOf(JRBand b, JasperDesign jd) {
        JROrigin origin = ((JRDesignBand)b).getOrigin();
        if (origin.getBandTypeValue().equals((Object)BandTypeEnum.GROUP_HEADER)) {
            JRGroup group = (JRGroup)jd.getGroupsMap().get(origin.getGroupName());
            int index = ModelUtils.getBandIndex(group.getGroupHeaderSection(), b);
            return String.valueOf(Messages.ModelUtils_groupheader_section) + " " + origin.getGroupName() + " " + (index + 1);
        }
        if (origin.getBandTypeValue().equals((Object)BandTypeEnum.DETAIL)) {
            int index = ModelUtils.getBandIndex(jd.getDetailSection(), b);
            return String.valueOf(Messages.ModelUtils_detail_section) + " " + (index + 1);
        }
        if (origin.getBandTypeValue().equals((Object)BandTypeEnum.GROUP_FOOTER)) {
            JRGroup group = (JRGroup)jd.getGroupsMap().get(origin.getGroupName());
            int index = ModelUtils.getBandIndex(group.getGroupFooterSection(), b);
            return String.valueOf(Messages.ModelUtils_groupfooter_section) + " " + origin.getGroupName() + (index + 1);
        }
        return ModelUtils.nameOf(((JRDesignBand)b).getOrigin());
    }

    public static int getBandIndex(JRSection section, JRBand band) {
        JRBand[] bands = section.getBands();
        int i = 0;
        while (bands != null && i < bands.length) {
            if (bands[i] == band) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getBandHeight(JRBand band) {
        return ModelUtils.getContainerSize(band.getChildren(), (Dimension)new Dimension((int)0, (int)0)).height;
    }

    public static Dimension getContainerSize(List<?> list, Dimension d) {
        for (Object obj : list) {
            JRDesignElement de;
            if (obj instanceof JRDesignElement) {
                de = (JRDesignElement)obj;
                d.height = Math.max(de.getY() + de.getHeight(), d.height);
                d.width = Math.max(de.getX() + de.getWidth(), d.width);
                continue;
            }
            if (obj instanceof JRFrame) {
                de = (JRFrame)obj;
                d.height = Math.max(de.getY() + de.getHeight(), d.height);
                d.width = Math.max(de.getX() + de.getWidth(), d.width);
                continue;
            }
            if (!(obj instanceof JRElementGroup)) continue;
            de = (JRElementGroup)obj;
            Dimension td = ModelUtils.getContainerSize(de.getChildren(), new Dimension(0, 0));
            d.height = Math.max(td.height, d.height);
            d.width = Math.max(td.width, d.width);
        }
        return d;
    }

    public static List<JRDesignElement> getAllGElements(JasperDesign jd) {
        ArrayList<JRDesignElement> res = new ArrayList<JRDesignElement>();
        List<JRBand> bands = ModelUtils.getAllBands(jd);
        for (JRBand b : bands) {
            res.addAll(ModelUtils.getGElements((JRElementGroup)b));
        }
        return res;
    }

    public static List<JRPart> getAllPartElements(JasperDesign jd) {
        JRPart[] partsList;
        ArrayList<JRPart> res = new ArrayList<JRPart>();
        if (jd.getDetailSection() != null && (partsList = jd.getDetailSection().getParts()) != null) {
            res.addAll(Arrays.asList(partsList));
        }
        if (jd.getGroups() != null) {
            for (Object g : jd.getGroupsList()) {
                JRDesignGroup gr = (JRDesignGroup)g;
                if (gr.getGroupHeaderSection() != null) {
                    res.addAll(Arrays.asList(gr.getGroupHeaderSection().getParts()));
                }
                if (gr.getGroupFooterSection() == null) continue;
                res.addAll(Arrays.asList(gr.getGroupFooterSection().getParts()));
            }
        }
        return res;
    }

    public static List<JRDesignElement> getAllElements(JasperDesign jd) {
        List<JRDesignElement> list = ModelUtils.getAllGElements(jd);
        return list;
    }

    public static List<JRDesignElement> getAllElements(List<JRChild> childElements) {
        ArrayList<JRDesignElement> list2 = new ArrayList<JRDesignElement>();
        for (JRChild ele : childElements) {
            if (ele instanceof JRDesignElement) {
                list2.add((JRDesignElement)ele);
            }
            if (ele instanceof JRElementGroup) {
                list2.addAll(ModelUtils.getGElements((JRElementGroup)ele));
                continue;
            }
            if (ele instanceof JRDesignCrosstab) {
                list2.addAll(ModelUtils.getCrosstabElements((JRDesignCrosstab)ele));
                continue;
            }
            if (!(ele instanceof JRDesignComponentElement)) continue;
            Component cmp = ((JRDesignComponentElement)ele).getComponent();
            if (cmp instanceof StandardTable) {
                list2.addAll(ModelUtils.getTableElements((StandardTable)cmp));
                continue;
            }
            if (!(cmp instanceof StandardListComponent)) continue;
            list2.addAll(ModelUtils.getListElements((StandardListComponent)cmp));
        }
        return list2;
    }

    public static List<JRDesignElement> getListElements(StandardListComponent list) {
        ArrayList<JRDesignElement> list2 = new ArrayList<JRDesignElement>();
        list2.addAll(ModelUtils.getAllElements(list.getContents().getChildren()));
        return list2;
    }

    public static List<JRDesignElement> getTableElements(StandardTable table) {
        ArrayList<JRDesignElement> list2 = new ArrayList<JRDesignElement>();
        ModelUtils.getTableCellElements(table.getColumns(), list2);
        return list2;
    }

    public static void getTableCellElements(List<BaseColumn> cols, List<JRDesignElement> list2) {
        for (BaseColumn c : cols) {
            ModelUtils.getTableCellElements(c.getTableHeader(), list2);
            ModelUtils.getTableCellElements(c.getTableFooter(), list2);
            ModelUtils.getTableCellElements(c.getColumnHeader(), list2);
            ModelUtils.getTableCellElements(c.getColumnFooter(), list2);
            for (GroupCell gc : c.getGroupHeaders()) {
                if (gc == null) continue;
                ModelUtils.getTableCellElements(gc.getCell(), list2);
            }
            for (GroupCell gc : c.getGroupFooters()) {
                if (gc == null) continue;
                ModelUtils.getTableCellElements(gc.getCell(), list2);
            }
            if (c instanceof StandardColumn) {
                ModelUtils.getTableCellElements(((StandardColumn)c).getDetailCell(), list2);
            }
            if (!(c instanceof StandardColumnGroup)) continue;
            ModelUtils.getTableCellElements(((StandardColumnGroup)c).getColumns(), list2);
        }
    }

    public static void getTableCellElements(Cell cell, List<JRDesignElement> list2) {
        if (cell == null) {
            return;
        }
        list2.addAll(ModelUtils.getAllElements(cell.getChildren()));
    }

    public static List<JRDesignElement> getGElements(JRElementGroup gr) {
        ArrayList<JRDesignElement> res = new ArrayList<JRDesignElement>();
        res.addAll(ModelUtils.getAllElements(gr.getChildren()));
        return res;
    }

    public static List<JRPart> getPartElements(JRElementGroup gr) {
        ArrayList<JRPart> res = new ArrayList<JRPart>();
        for (Object el : gr.getChildren()) {
            if (el instanceof JRElementGroup) {
                res.addAll(ModelUtils.getPartElements((JRElementGroup)el));
                continue;
            }
            if (!(el instanceof JRPart)) continue;
            res.add((JRPart)el);
        }
        return res;
    }

    public static List<JRDesignElement> getCrosstabElements(JRDesignCrosstab crosstab) {
        ArrayList<JRDesignElement> list = new ArrayList<JRDesignElement>();
        List<JRDesignCellContents> cells = ModelUtils.getAllCells(crosstab);
        for (JRDesignCellContents content : cells) {
            if (content == null) continue;
            list.addAll(ModelUtils.getGElements((JRElementGroup)content));
        }
        return list;
    }

    public static List<JRDesignCellContents> getAllCells(JRDesignCrosstab designCrosstab) {
        ArrayList<JRDesignCellContents> list = new ArrayList<JRDesignCellContents>();
        list.add((JRDesignCellContents)designCrosstab.getHeaderCell());
        List cells = designCrosstab.getCellsList();
        for (JRCrosstabCell cell : cells) {
            if (cell == null || (JRDesignCellContents)cell.getContents() == null) continue;
            list.add((JRDesignCellContents)cell.getContents());
        }
        JRCrosstabRowGroup[] row_groups = designCrosstab.getRowGroups();
        int i = 0;
        while (i < row_groups.length) {
            switch (row_groups[i].getTotalPositionValue()) {
                case START: 
                case END: {
                    list.add((JRDesignCellContents)row_groups[i].getTotalHeader());
                    break;
                }
            }
            list.add((JRDesignCellContents)row_groups[i].getHeader());
            ++i;
        }
        JRCrosstabColumnGroup[] col_groups = designCrosstab.getColumnGroups();
        int i2 = 0;
        while (i2 < col_groups.length) {
            switch (col_groups[i2].getTotalPositionValue()) {
                case START: 
                case END: {
                    list.add((JRDesignCellContents)col_groups[i2].getTotalHeader());
                    break;
                }
            }
            list.add((JRDesignCellContents)col_groups[i2].getHeader());
            ++i2;
        }
        return list;
    }

    public static String nameOf(JROrigin origin) {
        return origin.getBandTypeValue().getName();
    }

    public static int getMaxBandHeight(JRDesignBand b, JasperDesign jd) {
        int titleHeight;
        int k;
        if (b == null || jd == null) {
            return 0;
        }
        JROrigin origin = b.getOrigin();
        int topBottomMargins = jd.getTopMargin() + jd.getBottomMargin();
        if (origin.getBandTypeValue() == BandTypeEnum.TITLE && jd.isTitleNewPage() || origin.getBandTypeValue() == BandTypeEnum.SUMMARY || origin.getBandTypeValue() == BandTypeEnum.BACKGROUND || origin.getBandTypeValue() == BandTypeEnum.NO_DATA) {
            return jd.getPageHeight() - topBottomMargins;
        }
        int basicBandsHeight = 0;
        basicBandsHeight += topBottomMargins;
        basicBandsHeight += jd.getPageHeader() != null ? jd.getPageHeader().getHeight() : 0;
        basicBandsHeight += jd.getColumnHeader() != null ? jd.getColumnHeader().getHeight() : 0;
        basicBandsHeight += jd.getColumnFooter() != null ? jd.getColumnFooter().getHeight() : 0;
        if (b.getOrigin().getBandTypeValue() == BandTypeEnum.LAST_PAGE_FOOTER) {
            return jd.getPageHeight() - basicBandsHeight;
        }
        basicBandsHeight += jd.getPageFooter() != null ? jd.getPageFooter().getHeight() : 0;
        int heighestGroupHeader = 0;
        int heighestGroupFooter = 0;
        int i = 0;
        while (i < jd.getGroupsList().size()) {
            JRDesignGroup grp = (JRDesignGroup)jd.getGroupsList().get(i);
            JRBand[] bands = grp.getGroupHeaderSection().getBands();
            k = 0;
            while (bands != null && k < bands.length) {
                heighestGroupHeader = Math.max(heighestGroupHeader, bands[k].getHeight());
                ++k;
            }
            bands = grp.getGroupFooterSection().getBands();
            k = 0;
            while (bands != null && k < bands.length) {
                heighestGroupFooter = Math.max(heighestGroupFooter, bands[k].getHeight());
                ++k;
            }
            ++i;
        }
        if (b.getOrigin().getBandTypeValue() == BandTypeEnum.TITLE) {
            return jd.getPageHeight() - basicBandsHeight - Math.max(heighestGroupFooter, heighestGroupHeader);
        }
        if (b.getOrigin().getBandTypeValue() == BandTypeEnum.DETAIL) {
            return jd.getPageHeight() - basicBandsHeight;
        }
        int n = titleHeight = jd.getTitle() != null ? jd.getTitle().getHeight() : 0;
        if (jd.isTitleNewPage()) {
            titleHeight = 0;
        }
        if (origin.getBandTypeValue() == BandTypeEnum.GROUP_FOOTER || origin.getBandTypeValue() == BandTypeEnum.GROUP_HEADER) {
            return jd.getPageHeight() - basicBandsHeight - titleHeight;
        }
        int detailHeight = 0;
        if (jd.getDetailSection() != null) {
            JRBand[] bandsList = jd.getDetailSection().getBands();
            k = 0;
            while (bandsList != null && k < bandsList.length) {
                detailHeight = Math.max(detailHeight, bandsList[k].getHeight());
                ++k;
            }
        }
        int maxAlternativeSection = Math.max(detailHeight, Math.max(heighestGroupFooter, heighestGroupHeader) + titleHeight);
        int res = jd.getPageHeight() - (basicBandsHeight += maxAlternativeSection) + b.getHeight();
        res = Math.min(res, jd.getPageHeight() - topBottomMargins);
        res = Math.max(res, 0);
        return res;
    }

    public static String getDefaultName(Map<?, ?> map, String name) {
        int i = 1;
        while (i < 100000) {
            String iname = String.valueOf(name) + i;
            if (map.get(iname) == null) {
                return iname;
            }
            ++i;
        }
        return name;
    }

    public static String getDefaultName(JRDesignCrosstab c, String name) {
        if (!(c.getMeasureIndicesMap().containsKey(name) || c.getColumnGroupIndicesMap().containsKey(name) || c.getRowGroupIndicesMap().containsKey(name))) {
            return name;
        }
        int i = 1;
        while (i < 100000) {
            String iname = String.valueOf(name) + i;
            if (!(c.getMeasureIndicesMap().containsKey(iname) || c.getColumnGroupIndicesMap().containsKey(iname) || c.getRowGroupIndicesMap().containsKey(iname))) {
                return iname;
            }
            ++i;
        }
        return name;
    }

    public static String getNameFormat(String name, int index) {
        return String.valueOf(name) + "_" + index;
    }

    public static String[] getQueryLanguages(JasperReportsConfiguration context) {
        if (context == null) {
            context = JasperReportsConfiguration.getDefaultInstance();
        }
        String[] langs = ModelUtils.getQueryLanguagesOnly(context);
        String[] res = new String[langs.length + 1];
        res[0] = "";
        System.arraycopy(langs, 0, res, 1, langs.length);
        return res;
    }

    public static String getLanguage(String lang) {
        if (lang != null && lang.contains(",")) {
            return lang.substring(0, lang.indexOf(","));
        }
        return lang;
    }

    public static String[] getQueryLanguagesOnly(JasperReportsConfiguration context) {
        HashSet<String> langs = new HashSet<String>();
        List<JRQueryExecuterFactoryBundle> bundles = context.getExtensions(JRQueryExecuterFactoryBundle.class);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            int n;
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            for (JRQueryExecuterFactoryBundle bundle : bundles) {
                String[] languages;
                String[] stringArray = languages = bundle.getLanguages();
                n = languages.length;
                int n2 = 0;
                while (n2 < n) {
                    String l = stringArray[n2];
                    if (!deprecatedLanguages.contains(l.toLowerCase()) && !langs.contains(l)) {
                        boolean exists = false;
                        for (String item : langs) {
                            if (!item.equalsIgnoreCase(l.trim())) continue;
                            exists = true;
                            break;
                        }
                        if (!exists) {
                            langs.add(l);
                        }
                    }
                    ++n2;
                }
            }
            List<QueryExecuterFactoryBundle> oldbundles = context.getExtensions(QueryExecuterFactoryBundle.class);
            for (QueryExecuterFactoryBundle bundle : oldbundles) {
                String[] languages;
                String[] stringArray = languages = bundle.getLanguages();
                int n3 = languages.length;
                n = 0;
                while (n < n3) {
                    String l = stringArray[n];
                    if (!deprecatedLanguages.contains(l.toLowerCase()) && !langs.contains(l)) {
                        boolean exists = false;
                        for (String item : langs) {
                            if (!item.equalsIgnoreCase(l.trim())) continue;
                            exists = true;
                            break;
                        }
                        if (!exists) {
                            langs.add(l);
                        }
                    }
                    ++n;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        String[] languages = langs.toArray(new String[langs.size()]);
        Arrays.sort(languages, Collator.getInstance());
        return languages;
    }

    public static String[] getExpressionLanguages(JasperReportsConfiguration jconfig) {
        HashSet<String> compilers = new HashSet<String>();
        compilers.add("java");
        Map<String, String> params = jconfig.getProperties();
        for (String key : params.keySet()) {
            if (!key.startsWith("net.sf.jasperreports.compiler.")) continue;
            try {
                Class<?> clazz;
                if (jconfig.getClassLoader() == null || !JRCompiler.class.isAssignableFrom(clazz = jconfig.getClassLoader().loadClass(params.get(key)))) continue;
                compilers.add(key.substring("net.sf.jasperreports.compiler.".length()).toLowerCase());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        String[] langs = new String[compilers.size() + 1];
        langs[0] = "";
        int i = 1;
        for (String lang : compilers) {
            langs[i++] = lang;
        }
        return langs;
    }

    public static String[] getMarkups(JasperReportsConfiguration jrContext) {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("");
        lst.add("none");
        lst.add("styled");
        List props = JRPropertiesUtil.getInstance((JasperReportsContext)jrContext).getProperties("net.sf.jasperreports.markup.processor.factory.");
        for (JRPropertiesUtil.PropertySuffix p : props) {
            lst.add(p.getSuffix());
        }
        return lst.toArray(new String[lst.size()]);
    }

    public static List<String[]> getFontNames(JasperReportsConfiguration jContext) {
        ArrayList<String[]> classes = new ArrayList<String[]>();
        ArrayList<String> elements = new ArrayList<String>();
        Collection extensionFonts = FontUtil.getInstance((JasperReportsContext)jContext).getFontNames();
        for (String fname : extensionFonts) {
            elements.add(fname);
        }
        classes.add(elements.toArray(new String[elements.size()]));
        elements = new ArrayList();
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            elements.add(name);
            ++i;
        }
        classes.add(elements.toArray(new String[elements.size()]));
        return classes;
    }

    public static String[][] getPDFFontNames2() {
        String[] str = ModelUtils.getPDFFontNames();
        String[][] res = new String[str.length][2];
        int i = 0;
        while (i < str.length) {
            res[i][0] = str[i];
            res[i][1] = str[i];
            ++i;
        }
        return res;
    }

    public static String[][] getPdfEncodings2() {
        if (mp.keySet().isEmpty()) {
            ModelUtils.fillPDFEncodingMap();
        }
        String[] keySet = mp.keySet().toArray(new String[mp.keySet().size()]);
        String[][] res = new String[keySet.length][2];
        int i = 0;
        while (i < keySet.length) {
            res[i][0] = mp.get(keySet[i]);
            res[i][1] = keySet[i];
            ++i;
        }
        return res;
    }

    public static String[] getPDFFontNames() {
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("");
        classes.add("Helvetica");
        classes.add("Helvetica-Bold");
        classes.add("Helvetica-BoldOblique");
        classes.add("Helvetica-Oblique");
        classes.add("Courier");
        classes.add("Courier-Bold");
        classes.add("Courier-BoldOblique");
        classes.add("Courier-Oblique");
        classes.add("Symbol");
        classes.add("Times-Roman");
        classes.add("Times-Bold");
        classes.add("Times-BoldItalic");
        classes.add("Times-Italic");
        classes.add("ZapfDingbats");
        classes.add("STSong-Light");
        classes.add("MHei-Medium");
        classes.add("MSung-Light");
        classes.add("HeiseiKakuGo-W5");
        classes.add("HeiseiMin-W3");
        classes.add("HYGoThic-Medium");
        classes.add("HYSMyeongJo-Medium");
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] getPDFEncodings() {
        if (pdfencodings == null) {
            pdfencodings = new ArrayList<String>();
            pdfencodings.add("");
            ModelUtils.fillPDFEncodingMap();
            pdfencodings.addAll(mp.values());
        }
        return pdfencodings.toArray(new String[pdfencodings.size()]);
    }

    public static int getPDFEncodingIndex(String key) {
        return pdfencodings.indexOf(key);
    }

    private static void fillPDFEncodingMap() {
        mp.put("Cp1250", "CP1250 (Central European)");
        mp.put("Cp1251", "CP1251 (Cyrillic)");
        mp.put("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)");
        mp.put("Cp1253", "CP1253 (Greek)");
        mp.put("Cp1254", "CP1254 (Turkish)");
        mp.put("Cp1255", "CP1255 (Hebrew)");
        mp.put("Cp1256", "CP1256 (Arabic)");
        mp.put("Cp1257", "CP1257 (Baltic)");
        mp.put("Cp1258", "CP1258 (Vietnamese)");
        mp.put("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)");
        mp.put("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)");
        mp.put("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)");
        mp.put("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)");
        mp.put("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)");
        mp.put("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)");
        mp.put("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)");
        mp.put("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)");
        mp.put("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)");
        mp.put("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)");
        mp.put("Identity-H", "Identity-H (Unicode with horizontal writing)");
        mp.put("Identity-V", "Identity-V (Unicode with vertical writing)");
    }

    public static String getKey4PDFEncoding(String enc) {
        String res;
        if (enc != null && (res = mp.get(enc)) != null) {
            return res;
        }
        return enc;
    }

    public static String getPDFEncoding2key(String key) {
        if (key != null) {
            for (String k : mp.keySet()) {
                String v = mp.get(k);
                if (!v.equals(key)) continue;
                return k;
            }
        }
        return key;
    }

    public static MReport getReport(ANode node) {
        ANode parent = node.getParent();
        MReport reportNode = null;
        while (reportNode == null && parent != null) {
            if (parent instanceof MReport) {
                reportNode = (MReport)parent;
                continue;
            }
            parent = parent instanceof MPage ? ((MPage)parent).getRealParent() : parent.getParent();
        }
        return reportNode;
    }

    public static JRDesignDataset getDesignDatasetByName(JasperDesign jd, String datasetName) {
        Assert.isNotNull((Object)jd);
        Assert.isNotNull((Object)datasetName);
        JRDataset jrDataset = (JRDataset)jd.getDatasetMap().get(datasetName);
        if (jrDataset instanceof JRDesignDataset) {
            return (JRDesignDataset)jrDataset;
        }
        return jd.getMainDesignDataset();
    }

    public static JRDesignDataset getDesignDatasetForDatasetRun(JasperDesign jd, JRDatasetRun datasetRun) {
        Assert.isNotNull((Object)jd);
        if (datasetRun != null && datasetRun.getDatasetName() != null) {
            return ModelUtils.getDesignDatasetByName(jd, datasetRun.getDatasetName());
        }
        return jd.getMainDesignDataset();
    }

    public static JRElementGroup getTopElementGroup(JRDesignElement element) {
        JRElementGroup g1 = element.getElementGroup();
        while (g1 != null) {
            if (g1 instanceof JRDesignBand || g1 instanceof JRDesignCellContents) {
                return g1;
            }
            g1 = g1.getElementGroup();
        }
        return null;
    }

    public static ExpressionContext getElementExpressionContext(JRDesignElement element, ANode node) {
        if (element == null && node != null && node.getValue() instanceof JRDesignElement) {
            element = (JRDesignElement)node.getValue();
        }
        if (element != null) {
            ExpressionContext ec;
            ExpressionContext ec2;
            if (element instanceof JRDesignComponentElement && (ec2 = ModelUtils.getExpressionContext4Component(node)) != null) {
                return ec2;
            }
            JRElementGroup group = ModelUtils.getTopElementGroup(element);
            if (group instanceof JRDesignCellContents) {
                JRDesignCellContents contents = (JRDesignCellContents)ModelUtils.getTopElementGroup(element);
                return new ExpressionContext(contents.getOrigin().getCrosstab(), node.getJasperConfiguration());
            }
            if (!(group instanceof JRBand) && (ec = ModelUtils.getExpressionContext4Component(node)) != null) {
                return ec;
            }
        } else {
            ExpressionContext ec = ModelUtils.getExpressionContext4Component(node);
            if (ec != null) {
                return ec;
            }
            if (node != null) {
                JRDesignDataset dataset = ModelUtils.getDataset(node);
                JasperReportsConfiguration jconfig = node.getJasperConfiguration();
                if (dataset != null && jconfig != null) {
                    return new ExpressionContext(dataset, jconfig);
                }
            }
        }
        return ExpressionEditorSupportUtil.getReportExpressionContext();
    }

    private static ExpressionContext getExpressionContext4Component(ANode node) {
        ANode cursorNode = node;
        while (cursorNode != null) {
            ExpressionContext ec;
            if (cursorNode.getValue() instanceof JRDesignComponentElement && (ec = JaspersoftStudioPlugin.getExtensionManager().getExpressionContext4Element(cursorNode)) != null) {
                return ec;
            }
            cursorNode = cursorNode.getParent();
        }
        return null;
    }

    public static ExpressionContext getExpressionContext(ANode node) {
        if (node instanceof APropertyNode) {
            return ((APropertyNode)node).getExpressionContext();
        }
        return ModelUtils.getElementExpressionContext(null, node);
    }

    public static String getNameForField(List<JRDesignField> fields, String namePrefix) {
        boolean match = false;
        String tmp = namePrefix;
        int i = 0;
        while (i < 100000) {
            if (i != 0) {
                tmp = ModelUtils.getNameFormat(namePrefix, i);
            }
            for (JRField jRField : fields) {
                match = jRField.getName().equals(tmp);
                if (match) break;
            }
            if (!match) break;
            ++i;
        }
        return tmp;
    }

    public static void replacePropertiesMap(JRPropertiesMap sourceMap, JRPropertiesMap destMap) {
        int i;
        String[] propertyNames = sourceMap.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            i = 0;
            while (i < propertyNames.length) {
                destMap.setProperty(propertyNames[i], sourceMap.getProperty(propertyNames[i]));
                ++i;
            }
        }
        if ((propertyNames = destMap.getPropertyNames()) != null && propertyNames.length > 0) {
            i = 0;
            while (i < propertyNames.length) {
                if (!sourceMap.containsProperty(propertyNames[i])) {
                    destMap.removeProperty(propertyNames[i]);
                }
                ++i;
            }
        }
    }

    public static String getCurrentReportLanguage(JasperReportsConfiguration jconfig) {
        Assert.isNotNull((Object)((Object)jconfig));
        JasperDesign jd = jconfig.getJasperDesign();
        if (jd != null) {
            return jd.getLanguage();
        }
        return null;
    }

    public static List<String> getHyperlinkTypeNames4Widget(List<HyperlinkTypeEnum> filteredTypes) {
        ArrayList<String> alltypes = new ArrayList<String>();
        HyperlinkTypeEnum[] hyperlinkTypeEnumArray = HyperlinkTypeEnum.values();
        int n = hyperlinkTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            HyperlinkTypeEnum type = hyperlinkTypeEnumArray[n2];
            alltypes.add(type.getName());
            ++n2;
        }
        alltypes.addAll(JaspersoftStudioPlugin.getExtensionManager().getContributedHyperlinkTypes());
        for (HyperlinkTypeEnum t : filteredTypes) {
            alltypes.remove(t.getName());
        }
        return alltypes;
    }

    public static ItemData safeGetMarkerData(MapComponent mapComponent, boolean update) {
        StandardMapComponent map = (StandardMapComponent)mapComponent;
        ItemData markerData = ModelUtils.getSingleMarkerData((MapComponent)map);
        if (markerData == null) {
            markerData = new StandardItemData();
            if (update) {
                map.addMarkerData(markerData);
            }
        }
        return markerData;
    }

    public static List<INode> getSortFields(ANode node) {
        ANode n = node.getParent();
        while (n != null) {
            if (n instanceof MDataset || n instanceof MReport) {
                return ModelUtils.findSortFieldsNode(n);
            }
            n = n.getParent();
        }
        return null;
    }

    private static List<INode> findSortFieldsNode(ANode parent) {
        for (INode node : parent.getChildren()) {
            if (!(node instanceof MSortFields)) continue;
            return node.getChildren();
        }
        return new ArrayList<INode>();
    }

    public static boolean checkTypesForAllEditParModels(List<?> editParts, boolean allowed, Class<?> ... classes) {
        if (editParts.size() == 0) {
            return false;
        }
        for (Object o : editParts) {
            boolean result = ModelUtils.checkTypesForSingleEditPartModel(o, allowed, classes);
            if (result) continue;
            return false;
        }
        return true;
    }

    public static boolean checkTypesForSingleEditPartModel(Object editPart, boolean allowed, Class<?> ... classes) {
        if (editPart instanceof EditPart) {
            Object node = ((EditPart)editPart).getModel();
            Class<?>[] classArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                if (clazz.isInstance(node)) {
                    return allowed;
                }
                ++n2;
            }
        }
        return !allowed;
    }

    public static ItemData getSingleMarkerData(MapComponent map) {
        List markerDataList = map.getMarkerDataList();
        if (markerDataList != null && !markerDataList.isEmpty()) {
            return (ItemData)markerDataList.get(0);
        }
        return null;
    }

    public static String[] getDefaultReportLanguages() {
        return DEFAULT_LANGUAGES;
    }

    public static boolean belongsToDataset(APropertyNode element, String datasetName) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)datasetName);
        if (datasetName != null) {
            ANode upperParent = element.getParent().getParent();
            if (upperParent instanceof MDataset) {
                JRDesignDataset value = ((MDataset)upperParent).getValue();
                String fDsName = value.getName();
                return datasetName.equals(fDsName);
            }
            if (upperParent instanceof MReport) {
                MDataset mainDS = (MDataset)((MReport)upperParent).getPropertyValue("mainDataset");
                String mainDSName = (String)mainDS.getPropertyValue("name");
                return datasetName.equals(mainDSName);
            }
        }
        return false;
    }

    public static String getReportPropertyValue(JasperDesign jd, String key, String defaultValue) {
        String value = jd.getProperty(key);
        return value != null ? value : defaultValue;
    }

    public static boolean safeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public static boolean jrPropertiesMapEquals(JRPropertiesMap map1, JRPropertiesMap map2) {
        if (map1 == null || map2 == null) {
            return map2 == null && map1 == null;
        }
        String[] names1 = map1.getPropertyNames();
        if (names1.length != map2.getPropertyNames().length) {
            return false;
        }
        String[] stringArray = names1;
        int n = names1.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!map2.containsProperty(name) || !ModelUtils.safeEquals(map1.getProperty(name), map2.getProperty(name))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String getGroupNameForProperty(Object value) {
        if (value instanceof JRGroup) {
            return ((JRGroup)value).getName();
        }
        if (value instanceof String) {
            if (((String)value).trim().isEmpty()) {
                return null;
            }
            return (String)value;
        }
        return null;
    }

    public static JRGroup getGroupForProperty(Object value, JRDesignDataset dataset) {
        if (value instanceof JRGroup) {
            return (JRGroup)value;
        }
        if (value instanceof String) {
            if (((String)value).trim().isEmpty() || dataset == null) {
                return null;
            }
            return (JRGroup)dataset.getGroupsMap().get(value);
        }
        return null;
    }

    public static INode getNode(final Object obj, INode parent) {
        ModelVisitor<INode> mv = new ModelVisitor<INode>(parent){

            @Override
            public boolean visit(INode n) {
                if (n.getValue() == obj) {
                    this.setObject(n);
                }
                return true;
            }
        };
        return (INode)mv.getObject();
    }

    public static String list2string(String[][] items) {
        String str = "";
        int i = 0;
        while (i < items.length) {
            int j = 0;
            while (j < items[i].length) {
                str = String.valueOf(str) + items[i][j];
                if (j < items[i].length - 1) {
                    str = String.valueOf(str) + ";";
                }
                ++j;
            }
            str = String.valueOf(str) + "\n";
            ++i;
        }
        return str;
    }

    public static boolean isEmpty(ANode n) {
        return n == null || Misc.isNullOrEmpty(n.getChildren()) || n.getChildren().get(0) instanceof MDummy;
    }

    public static boolean areFieldsEquals(JRField field1, JRField field2) {
        Assert.isNotNull((Object)field1);
        Assert.isNotNull((Object)field2);
        if (!ObjectUtils.equals((Object)field1.getName(), (Object)field2.getName())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)field1.getDescription(), (Object)field2.getDescription())) {
            return false;
        }
        return ObjectUtils.equals((Object)field1.getValueClassName(), (Object)field2.getValueClassName());
    }

    public static boolean areParametersEquals(JRParameter param1, JRParameter param2) {
        Assert.isNotNull((Object)param1);
        Assert.isNotNull((Object)param2);
        if (!ObjectUtils.equals((Object)param1.getName(), (Object)param2.getName())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)param1.getDescription(), (Object)param2.getDescription())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)param1.getValueClassName(), (Object)param2.getValueClassName())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)param1.getNestedTypeName(), (Object)param2.getNestedTypeName())) {
            return false;
        }
        return param1.isForPrompting() == param2.isForPrompting();
    }

    public static boolean areSortFieldsEquals(JRSortField sfield1, JRSortField sfield2) {
        Assert.isNotNull((Object)sfield1);
        Assert.isNotNull((Object)sfield2);
        if (!ObjectUtils.equals((Object)sfield1.getName(), (Object)sfield2.getName())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)sfield1.getOrderValue(), (Object)sfield2.getOrderValue())) {
            return false;
        }
        return ObjectUtils.equals((Object)sfield1.getType(), (Object)sfield2.getType());
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isFloat(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isBoolean(String value) {
        if (value != null) {
            String lowerCase = value.trim().toLowerCase();
            return Boolean.FALSE.toString().equals(lowerCase) || Boolean.TRUE.toString().equals(lowerCase);
        }
        return false;
    }

    public static Integer getInteger(Object value) {
        if (value instanceof String && ModelUtils.isInteger((String)value)) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public static Long getLong(Object value) {
        if (value instanceof String && ModelUtils.isLong((String)value)) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    public static Float getFloat(Object value) {
        if (value instanceof String && ModelUtils.isFloat((String)value)) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return null;
    }

    public static Double getDouble(Object value) {
        if (value instanceof String && ModelUtils.isDouble((String)value)) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public static Boolean getBoolean(Object value) {
        if (value instanceof String && ModelUtils.isBoolean((String)value)) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    public static String getNameAsField(String name) {
        Assert.isNotNull((Object)name);
        return "$F{" + name + "}";
    }

    public static String getNameAsParameter(String name) {
        Assert.isNotNull((Object)name);
        return "$P{" + name + "}";
    }

    public static String getNameAsVariable(String name) {
        Assert.isNotNull((Object)name);
        return "$V{" + name + "}";
    }

    public static String getNameAsResourceKey(String name) {
        Assert.isNotNull((Object)name);
        return "$R{" + name + "}";
    }

    public static boolean isClassAssignableFrom(Class<?> clazz, String className) {
        try {
            Class<?> forName = Class.forName(className);
            return clazz.isAssignableFrom(forName);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

