/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.JRXMLUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SubreportsUtil {
    private SubreportsUtil() {
    }

    public static Map<File, IFile> getSubreportFiles(JasperReportsConfiguration jConfig, IFile file, JasperDesign jd, IProgressMonitor monitor) {
        HashMap<File, IFile> fmap = new HashMap<File, IFile>();
        try {
            List<JRDesignElement> elements = ModelUtils.getAllElements(jd);
            SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)elements.size());
            for (JRDesignElement ele : elements) {
                if (!(ele instanceof JRDesignSubreport)) continue;
                SubreportsUtil.addSubreport(jConfig, fmap, (IProgressMonitor)submon.split(1), file, jd, (JRDesignSubreport)ele);
            }
        }
        finally {
            jConfig.init(file);
        }
        return fmap;
    }

    private static File getSubreportFileItem(IFile file, JRExpression expression, JasperReportsConfiguration jConfig, JasperDesign parent, boolean simpleMode) {
        File f;
        String expr;
        String string = expr = simpleMode ? JRExpressionUtil.getSimpleExpressionText((JRExpression)expression) : ExpressionUtil.eval(expression, jConfig, parent);
        if (expr == null || expr.isEmpty()) {
            return null;
        }
        if (expr.endsWith(".jasper")) {
            expr = StringUtils.replaceAllIns((String)expr, (String)".jasper$", (String)".jrxml");
        }
        if ((f = FileUtils.findFile((IFile)file, (String)(expr = expr.replaceFirst("repo:", "")))) == null) {
            try {
                f = SubreportsUtil.fallbackFindFile(file, expr);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return f;
    }

    private static void addSubreport(JasperReportsConfiguration jConfig, Map<File, IFile> fmap, IProgressMonitor monitor, IFile file, JasperDesign parent, JRDesignSubreport ele) {
        SubMonitor submon;
        block10: {
            jConfig.init(file);
            JRExpression expression = ele.getExpression();
            submon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            File f = SubreportsUtil.getSubreportFileItem(file, expression, jConfig, parent, true);
            if (f == null && (f = SubreportsUtil.getSubreportFileItem(file, expression, jConfig, parent, false)) == null) {
                return;
            }
            submon.setWorkRemaining(10);
            if (fmap.containsKey(f)) {
                return;
            }
            if (f != null && f.exists()) {
                IFile[] fs = JDTUtils.WS_ROOT.findFilesForLocationURI(f.toURI());
                if (fs != null && fs.length > 0) {
                    IFile ifile = fs[0];
                    fmap.put(f, ifile);
                    try {
                        JasperDesign jd = JRXMLUtils.getJasperDesign(jConfig, ifile.getContents(), ifile.getFileExtension());
                        if (jd == null) break block10;
                        for (JRDesignElement el : ModelUtils.getAllElements(jd)) {
                            if (el instanceof JRDesignSubreport) {
                                SubreportsUtil.addSubreport(jConfig, fmap, monitor, ifile, jd, (JRDesignSubreport)el);
                            }
                            if (!monitor.isCanceled()) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    fmap.put(f, null);
                }
            }
        }
        submon.setWorkRemaining(0);
    }

    private static File fallbackFindFile(IFile file, String expression) {
        File f;
        try {
            f = new File(expression);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            f = new File(file.getRawLocationURI().getPath(), expression);
        }
        return f;
    }
}

