/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.jasper;

import java.util.List;

public class ExtensionCache<T> {
    private boolean needRefresh = true;
    private boolean avoidInvalidation = false;
    private List<T> cache = null;

    public void invalidate() {
        if (!this.avoidInvalidation) {
            this.cache = null;
            this.needRefresh = true;
        }
    }

    public boolean isValid() {
        if (this.avoidInvalidation) {
            return this.cache != null;
        }
        return this.cache != null && !this.needRefresh;
    }

    public void setValue(List<T> value) {
        this.cache = value;
        this.needRefresh = false;
    }

    public List<T> getValue() {
        return this.cache;
    }

    public void setAvoidInvalidation(boolean value) {
        this.avoidInvalidation = value;
    }
}

