/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.jasper;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.repo.DefaultRepositoryService;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.OutputStreamResource;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class JSSFileRepositoryService
implements RepositoryService {
    private List<RepositoryService> list;
    private JasperReportsConfiguration jConfig;

    public JSSFileRepositoryService(JasperReportsConfiguration jConfig, List<RepositoryService> list) {
        this.list = list;
        this.jConfig = jConfig;
    }

    public List<RepositoryService> getRepositoryServices() {
        return this.list;
    }

    public Resource getResource(String uri) {
        for (RepositoryService rs : this.list) {
            Resource r = rs.getResource(uri);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public void saveResource(String uri, Resource resource) {
        for (RepositoryService rs : this.list) {
            rs.saveResource(uri, resource);
        }
    }

    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        return this.getResource((RepositoryContext)SimpleRepositoryContext.of((JasperReportsContext)this.jConfig), uri, resourceType);
    }

    public <K extends Resource> K getResource(RepositoryContext context, String uri, Class<K> resourceType) {
        for (RepositoryService rs : new ArrayList<RepositoryService>(this.list)) {
            K r = this.doGetResource(context, uri, resourceType, rs);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <K extends Resource> K doGetResource(RepositoryContext context, String uri, Class<K> resourceType, RepositoryService rs) {
        try {
            Resource r = rs.getResource(context, uri, resourceType);
            if (r != null) {
                return (K)r;
            }
        }
        catch (JRRuntimeException e) {
            JaspersoftStudioPlugin.getInstance().logError("Problem occurred when trying to load the resource: " + uri, e);
        }
        try {
            if (ReportResource.class.equals(resourceType) && uri.endsWith(".jrxml")) {
                return this.doGetResource(context, StringUtils.replaceAllIns((String)uri, (String)".jrxml$", (String)".jasper"), resourceType, rs);
            }
            if (ReportResource.class.equals(resourceType) && uri.endsWith(".jasper")) {
                String nuri = StringUtils.replaceAllIns((String)uri, (String)".jasper$", (String)".jrxml");
                File jrxmlFile = JRResourcesUtil.resolveFile((RepositoryContext)context, (String)nuri);
                if (!jrxmlFile.exists()) {
                    return null;
                }
                if (rs instanceof DefaultRepositoryService) {
                    String destinationPath = uri;
                    if (!new File(uri).isAbsolute()) {
                        destinationPath = jrxmlFile.getParent().concat("/" + uri);
                    }
                    JasperCompileManager.getInstance((JasperReportsContext)this.jConfig).compileToFile(jrxmlFile.getAbsolutePath(), destinationPath);
                } else {
                    OutputStreamResource or = new OutputStreamResource();
                    if (rs instanceof FileRepositoryService) {
                        or.setOutputStream(((FileRepositoryService)rs).getOutputStream(uri));
                    } else {
                        or.setOutputStream((OutputStream)new ByteArrayOutputStream());
                    }
                    JasperCompileManager.getInstance((JasperReportsContext)this.jConfig).compileToStream((InputStream)new FileInputStream(jrxmlFile), or.getOutputStream());
                    rs.saveResource(uri, (Resource)or);
                }
                this.refreshFile(rs, jrxmlFile.getAbsolutePath());
                return (K)rs.getResource(uri, resourceType);
            }
            if (!ReportResource.class.equals(resourceType)) return null;
            InputStreamResource inr = (InputStreamResource)rs.getResource(uri, InputStreamResource.class);
            if (inr == null) {
                return null;
            }
            String jruri = String.valueOf(uri) + ".jasper";
            if (rs instanceof DefaultRepositoryService) {
                URI dUri = new URI(jruri);
                JasperCompileManager.getInstance((JasperReportsContext)this.jConfig).compileToFile(new URI(uri).getRawPath(), dUri.getRawPath());
            } else {
                OutputStreamResource or = new OutputStreamResource();
                if (rs instanceof FileRepositoryService) {
                    or.setOutputStream(((FileRepositoryService)rs).getOutputStream(jruri));
                } else {
                    or.setOutputStream((OutputStream)new ByteArrayOutputStream());
                }
                JasperCompileManager.getInstance((JasperReportsContext)this.jConfig).compileToStream(inr.getInputStream(), or.getOutputStream());
                rs.saveResource(jruri, (Resource)or);
            }
            this.refreshFile(rs, jruri);
            return (K)rs.getResource(jruri, resourceType);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public ResourceInfo getResourceInfo(RepositoryContext context, String location) {
        for (RepositoryService rs : new ArrayList<RepositoryService>(this.list)) {
            ResourceInfo r = rs.getResourceInfo(context, location);
            if (r == null) continue;
            return r;
        }
        return super.getResourceInfo(context, location);
    }

    private void refreshFile(final RepositoryService rs, final String uri) {
        Job job = new Job(Messages.CompileAction_jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IFile[] fs;
                    if (rs instanceof DefaultRepositoryService) {
                        IFile[] fs2 = JDTUtils.WS_ROOT.findFilesForLocationURI(new File(uri).toURI());
                        if (fs2 != null && fs2.length > 0) {
                            fs2[0].getParent().refreshLocal(1, monitor);
                        }
                    } else if (rs instanceof FileRepositoryService && (fs = JDTUtils.WS_ROOT.findFilesForLocationURI(new File(((FileRepositoryService)rs).getRoot(), uri).toURI())) != null && fs.length > 0) {
                        fs[0].refreshLocal(1, monitor);
                    }
                }
                catch (CoreException coreException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }
}

