/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedEvent;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedListener;
import com.jaspersoft.studio.widgets.framework.manager.ItemPropertyLayout;
import com.jaspersoft.studio.widgets.framework.manager.ItemPropertyLayoutData;
import com.jaspersoft.studio.widgets.framework.manager.LazyExpressionLabel;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.IDialogProvider;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.dialog.ItemPropertyElementDialog;
import com.jaspersoft.studio.widgets.framework.ui.menu.IMenuProvider;
import com.jaspersoft.studio.widgets.framework.ui.menu.StandardContextualMenu;
import com.jaspersoft.studio.widgets.framework.ui.providers.BaseLabelProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class WItemProperty
extends Composite
implements IExpressionContextSetter,
IWItemProperty {
    public static final int FORCE_EXPRESSION_DIALOG = 2;
    public static final int FORCE_SIMPLE_MODE = 4;
    public static final String CUSTOM_SIMPLE_MODE_SUFFIX = "_customSimpleMode";
    public static final String BUTTON_ICON_PATH = "icons/resources/expressionedit-16.png";
    private ExpressionContext expContext;
    private Control editorControl;
    private Button btnEditExpression;
    private BaseLabelProvider lprovider = null;
    private LazyExpressionLabel expressionEditLabel;
    private boolean isRefresh = false;
    private boolean isUpdating = false;
    private ItemPropertyDescription<?> ipDesc;
    private IPropertyEditor editor;
    private Label titleLabel = null;
    private ItemPropertyLayoutData contentLayoutData = new ItemPropertyLayoutData();
    private List<ItemPropertyModifiedListener> listeners = new ArrayList<ItemPropertyModifiedListener>();
    private Image resizedImageForExprBtn;
    private Image disabledImageForExprBtn;

    public WItemProperty(Composite parent, int style, ItemPropertyDescription<?> widgetDescriptor, IPropertyEditor editor) {
        this(parent, style, null, widgetDescriptor, editor);
    }

    public WItemProperty(Composite parent, int style, WidgetPropertyDescriptor descriptor, ItemPropertyDescription<?> widgetDescriptor, IPropertyEditor editor) {
        super(parent, style);
        Assert.isNotNull((Object)editor);
        this.ipDesc = widgetDescriptor;
        this.editor = editor;
        if (descriptor != null) {
            this.titleLabel = new Label((Composite)this, 0);
            this.titleLabel.setText(descriptor.getLabel());
            this.titleLabel.setToolTipText(descriptor.getDescription());
        }
        this.expressionEditLabel = new LazyExpressionLabel(this);
        this.expressionEditLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    wizard.setValue((JRDesignExpression)WItemProperty.this.getPropertyEditor().getPropertyValueExpression(WItemProperty.this.ipDesc.getName()));
                    wizard.setExpressionContext(WItemProperty.this.expContext);
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(Display.getDefault().getActiveShell(), wizard);
                    if (dialog.open() == 0) {
                        JRDesignExpression exprTmp = wizard.getValue();
                        WItemProperty.this.setValue(null, (JRExpression)exprTmp);
                    }
                }
            }
        });
        this.editorControl = this.ipDesc.createControl(this, this);
        this.btnEditExpression = new Button((Composite)this, 0x800000);
        if (this.contentLayoutData != null) {
            this.btnEditExpression.setImage(this.getResizedImageForExprButton());
        } else {
            this.btnEditExpression.setImage(this.getDisabledImageForExprButton());
        }
        this.btnEditExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WItemProperty.this.handleEditButton();
            }
        });
        if (widgetDescriptor != null) {
            UIUtils.getDisplay().asyncExec(() -> {
                if (!this.editorControl.isDisposed()) {
                    String tmp = this.getToolTip();
                    String tt = tmp != null ? tmp : widgetDescriptor.getToolTip();
                    this.expressionEditLabel.setToolTipText(tt);
                    this.editorControl.setToolTipText(tt);
                    this.btnEditExpression.setToolTipText(tt);
                }
            });
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object[] listenersArray;
                Object[] objectArray = listenersArray = WItemProperty.this.listeners.toArray();
                int n = listenersArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object l = objectArray[n2];
                    WItemProperty.this.removeModifyListener((ItemPropertyModifiedListener)l);
                    ++n2;
                }
                WItemProperty.this.listeners.clear();
                WItemProperty.this.listeners = null;
                if (WItemProperty.this.resizedImageForExprBtn != null) {
                    WItemProperty.this.resizedImageForExprBtn.dispose();
                    WItemProperty.this.resizedImageForExprBtn = null;
                }
                if (WItemProperty.this.disabledImageForExprBtn != null) {
                    WItemProperty.this.disabledImageForExprBtn.dispose();
                    WItemProperty.this.disabledImageForExprBtn = null;
                }
            }
        });
        this.setLayout(new ItemPropertyLayout(this, this.titleLabel, this.expressionEditLabel, this.editorControl, this.btnEditExpression));
    }

    private Image getResizedImageForExprButton() {
        if (this.resizedImageForExprBtn != null) {
            this.resizedImageForExprBtn.dispose();
        }
        Point buttonSize = this.contentLayoutData.getButtonSize();
        Image loadedImage = JaspersoftStudioPlugin.getInstance().getImage(BUTTON_ICON_PATH);
        this.resizedImageForExprBtn = ImageUtils.resize(loadedImage, buttonSize.x / 2, buttonSize.y / 2);
        return this.resizedImageForExprBtn;
    }

    private Image getDisabledImageForExprButton() {
        if (this.disabledImageForExprBtn == null) {
            Image loadedImage = JaspersoftStudioPlugin.getInstance().getImage(BUTTON_ICON_PATH);
            this.disabledImageForExprBtn = new Image(loadedImage.getDevice(), loadedImage.getImageData());
        }
        return this.disabledImageForExprBtn;
    }

    @Override
    public void setRefresh(boolean refreshing) {
        this.isRefresh = refreshing;
    }

    @Override
    public boolean isRefresh() {
        return this.isRefresh || this.isUpdating;
    }

    private void configureWidgetsLayoutData() {
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                WItemProperty.this.layout(true, true);
            }
        });
    }

    @Override
    public void setValue(String staticValue, JRExpression expressionValue) {
        this.setRefresh(true);
        try {
            this.getPropertyEditor().createUpdateProperty(this.ipDesc.getName(), staticValue, expressionValue);
            this.updateWidget();
            this.fireModifyEvent(staticValue, expressionValue);
        }
        finally {
            this.setRefresh(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editorControl.setEnabled(enabled);
        this.btnEditExpression.setEnabled(enabled);
    }

    public BaseLabelProvider getLabelProvider() {
        if (this.lprovider == null) {
            return BaseLabelProvider.INSTANCE;
        }
        return this.lprovider;
    }

    public void setLabelProvider(BaseLabelProvider lprovider) {
        this.lprovider = lprovider;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public ExpressionContext getExpressionContext() {
        return this.expContext;
    }

    @Override
    public void addModifyListener(ItemPropertyModifiedListener ml) {
        this.listeners.add(ml);
    }

    @Override
    public void removeModifyListener(ItemPropertyModifiedListener ml) {
        this.listeners.remove(ml);
    }

    @Override
    public Control getControl() {
        return this.editorControl;
    }

    protected void fireModifyEvent(String staticValue, JRExpression expressionValue) {
        ItemPropertyModifiedEvent event = new ItemPropertyModifiedEvent(this);
        event.staticValue = staticValue;
        event.expressionValue = expressionValue;
        event.propertyName = this.ipDesc.getName();
        for (ItemPropertyModifiedListener ml : this.listeners) {
            ml.itemModified(event);
        }
    }

    protected void handleEditButton() {
        ItemPropertyElementDialog dialog = null;
        if (this.ipDesc instanceof IDialogProvider) {
            dialog = ((IDialogProvider)((Object)this.ipDesc)).getDialog(this);
        } else {
            dialog = new ItemPropertyElementDialog(UIUtils.getShell(), this.ipDesc, this);
            dialog.setHelpAvailable(false);
            dialog.setForceExpressionMode(this.hasForcedExpression());
        }
        if (dialog.open() == 0) {
            this.setValue(dialog.getStaticValue(), dialog.getExpressionValue());
        }
    }

    @Override
    public String getStaticValue() {
        return this.getPropertyEditor().getPropertyValue(this.ipDesc.getName());
    }

    @Override
    public JRExpression getExpressionValue() {
        return this.getPropertyEditor().getPropertyValueExpression(this.ipDesc.getName());
    }

    @Override
    public String getPropertyName() {
        return this.ipDesc.getName();
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public boolean isExpressionMode() {
        return !this.hasForcedSimpleMode() && this.getPropertyEditor().getPropertyValueExpression(this.ipDesc.getName()) != null;
    }

    @Override
    public IMenuProvider getContextualMenuProvider() {
        return StandardContextualMenu.INSTANCE;
    }

    @Override
    public void updateWidget(boolean refreshLayout) {
        this.isUpdating = true;
        try {
            this.ipDesc.update(this.editorControl, this);
            if (this.isExpressionMode()) {
                this.expressionEditLabel.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/functions_icon.png"));
                this.layout(true, true);
            } else {
                this.expressionEditLabel.setImage(null);
                if (refreshLayout) {
                    this.layout(true, true);
                }
            }
        }
        finally {
            this.isUpdating = false;
        }
    }

    @Override
    public void updateWidget() {
        this.updateWidget(true);
    }

    @Override
    public IPropertyEditor getPropertyEditor() {
        return this.editor;
    }

    @Override
    public void setPropertyEditor(IPropertyEditor editor) {
        Assert.isNotNull((Object)editor);
        this.editor = editor;
    }

    @Override
    public Object getFallbackValue() {
        return this.ipDesc.getFallbackValue();
    }

    public String getPropertyLabel() {
        return this.ipDesc.getLabel();
    }

    public List<String> isValueValid() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.ipDesc != null && this.editor != null && this.ipDesc.isMandatory()) {
            String staticValue = this.getStaticValue();
            boolean hasStaticValue = true;
            if (staticValue == null || staticValue.isEmpty()) {
                hasStaticValue = false;
            }
            JRExpression expValue = this.getExpressionValue();
            boolean hasExpValue = true;
            if (expValue == null) {
                hasExpValue = false;
            }
            if (!hasStaticValue && !hasExpValue) {
                String message = "Property {0} is mandatory";
                result.add(MessageFormat.format(message, this.getPropertyLabel()));
            }
        }
        return result;
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        this.layout(true, true);
    }

    public boolean isVisible() {
        if (!this.isDisposed()) {
            return this.getVisible();
        }
        return false;
    }

    public void setContentLayoutData(ItemPropertyLayoutData data) {
        Assert.isNotNull((Object)data);
        this.contentLayoutData = data;
        Image oldImage = this.btnEditExpression.getImage();
        if (oldImage != null && !oldImage.isDisposed()) {
            oldImage.dispose();
        }
        this.btnEditExpression.setImage(this.getResizedImageForExprButton());
        this.layout();
    }

    public ItemPropertyLayoutData getContentLayoutData() {
        return this.contentLayoutData;
    }

    public boolean hasForcedExpression() {
        return (this.getStyle() & 2) == 2;
    }

    public boolean hasForcedSimpleMode() {
        return (this.getStyle() & 4) == 4;
    }
}

