/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.widgets.framework.manager.panel.IPanelManager;
import com.jaspersoft.studio.widgets.framework.model.SectionPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class WidgetsDescriptor {
    private String label;
    private String description;
    private String panelManagerClass;
    private List<SectionPropertyDescriptor> sections;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<SectionPropertyDescriptor> getSections() {
        if (this.sections == null) {
            this.sections = new ArrayList<SectionPropertyDescriptor>();
        }
        return this.sections;
    }

    public void setSections(List<SectionPropertyDescriptor> sections) {
        this.sections = sections;
    }

    public String getPanelManagerClass() {
        return this.panelManagerClass;
    }

    public void setPanelManagerClass(String className) {
        this.panelManagerClass = className;
    }

    public String getLocalizedString(String key) {
        return key;
    }

    public List<WidgetPropertyDescriptor> getPlainWidgets() {
        ArrayList<WidgetPropertyDescriptor> result = new ArrayList<WidgetPropertyDescriptor>();
        for (SectionPropertyDescriptor section : this.getSections()) {
            for (WidgetPropertyDescriptor widget : section.getProperties()) {
                result.add(widget);
            }
        }
        return result;
    }

    public boolean hasWidgets() {
        for (SectionPropertyDescriptor section : this.getSections()) {
            if (section.getProperties().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public IPanelManager getPanelManager(Composite parent) {
        if (this.panelManagerClass != null) {
            try {
                Class<?> panelManager = Class.forName(this.panelManagerClass);
                if (IPanelManager.class.isAssignableFrom(panelManager)) {
                    IPanelManager result = (IPanelManager)panelManager.getConstructor(Composite.class).newInstance(parent);
                    return result;
                }
            }
            catch (Error err) {
                JaspersoftStudioPlugin.getInstance().logError(err);
            }
            catch (Exception ex) {
                JaspersoftStudioPlugin.getInstance().logError(ex);
            }
        }
        return null;
    }
}

