/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class CheckboxItemPropertyDescription
extends AbstractExpressionPropertyDescription<Boolean> {
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";

    public CheckboxItemPropertyDescription() {
    }

    public CheckboxItemPropertyDescription(String name, String label, String description, boolean mandatory, boolean defaultValue) {
        super(name, label, description, mandatory, defaultValue);
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wProp) {
        super.handleEdit(txt, wProp);
        if (txt instanceof Button) {
            boolean selected = ((Button)txt).getSelection();
            String tvalue = String.valueOf(selected);
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            wProp.setValue(tvalue, null);
        }
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        final Button simpleControl = new Button(cmp.getSecondContainer(), 32);
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        simpleControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                CheckboxItemPropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
            }
        });
        this.setupContextMenu((Control)simpleControl, wiProp);
        cmp.switchToSecondContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        boolean isFallback = false;
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text txt = (Text)cmp.getFirstContainer().getData();
            super.update((Control)txt, wip);
            cmp.switchToFirstContainer();
            txt.setToolTipText(this.getToolTip(wip, txt.getToolTipText()));
        } else {
            if (cmp.getParent().getBackground() != null) {
                RGB rgb = cmp.getParent().getBackground().getRGB();
                cmp.getSecondContainer().setBackground(ResourceManager.getColor((RGB)rgb));
            }
            Button button = (Button)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
                isFallback = true;
            }
            button.setSelection(Boolean.parseBoolean(Misc.nvl((String)v)));
            button.setToolTipText(this.getToolTip(wip, Boolean.toString(button.getSelection())));
            this.changeFallbackForeground(isFallback, (Control)button);
            cmp.switchToSecondContainer();
        }
    }

    protected boolean verifyValue(String value) {
        return TRUE_VALUE.equalsIgnoreCase(value) || FALSE_VALUE.equalsIgnoreCase(value);
    }

    @Override
    public CheckboxItemPropertyDescription clone() {
        CheckboxItemPropertyDescription result = new CheckboxItemPropertyDescription();
        result.defaultValue = (Boolean)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.fallbackValue = (Boolean)this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        boolean defaultValue = false;
        boolean fallbackValue = false;
        if (this.verifyValue(cpd.getDefaultValue())) {
            defaultValue = Boolean.parseBoolean(cpd.getDefaultValue());
        }
        if (this.verifyValue(cpd.getFallbackValue())) {
            fallbackValue = Boolean.parseBoolean(cpd.getFallbackValue());
        }
        CheckboxItemPropertyDescription result = new CheckboxItemPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), defaultValue);
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue(fallbackValue);
        return result;
    }
}

