/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.property.section.report.util.Unit;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractMeasurePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.dialog.ItemPropertyElementDialog;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class FixedMeasurePropertyDescription
extends AbstractMeasurePropertyDescription<String> {
    protected Map<String, String> nameKeyUnitsMap = null;
    protected Map<String, List<String>> keyNameUnitsMap = null;
    protected String[] autocompleteValues;
    protected static final DecimalFormat format = new DecimalFormat("0.################");
    private boolean fallbackModified = true;

    public FixedMeasurePropertyDescription() {
    }

    public FixedMeasurePropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue, long min, long max, Map<String, String> unitsMap) {
        super(name, label, description, mandatory, defaultValue, min, max);
        this.nameKeyUnitsMap = unitsMap;
        this.keyNameUnitsMap = this.getInversedUnitsMap();
        this.autocompleteValues = this.buildAutoocompleteValues();
    }

    public FixedMeasurePropertyDescription(String name, String label, String description, boolean mandatory, long min, long max, Map<String, String> unitsMap) {
        super(name, label, description, mandatory, min, max);
        this.nameKeyUnitsMap = unitsMap;
        this.keyNameUnitsMap = this.getInversedUnitsMap();
        this.autocompleteValues = this.buildAutoocompleteValues();
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        final Text simpleControl = new Text(cmp.getSecondContainer(), 2048);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (UIUtil.isMacAndEclipse4()) {
                    if (((Text)e.getSource()).isDisposed()) {
                        return;
                    }
                    wiProp.updateWidget();
                }
            }

            public void focusLost(FocusEvent e) {
                FixedMeasurePropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
            }
        };
        simpleControl.addFocusListener((FocusListener)focusListener);
        simpleControl.setData("focusListener", (Object)focusListener);
        simpleControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FixedMeasurePropertyDescription.this.fallbackModified = true;
            }
        });
        simpleControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    FixedMeasurePropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
                }
            }
        });
        simpleControl.addMouseListener((MouseListener)new MouseClickListener(simpleControl, wiProp));
        if (this.autocompleteValues.length > 1) {
            new AutoCompleteField((Control)simpleControl, (IControlContentAdapter)new AbstractMeasurePropertyDescription.AutoCompleteMeasure(simpleControl), this.autocompleteValues);
        }
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData textData = new GridData(768);
        textData.verticalAlignment = 0x1000000;
        textData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)textData);
        String tt = this.getToolTip();
        simpleControl.setToolTipText(tt);
        this.defaultBackgroundColor = simpleControl.getBackground();
        simpleControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                FixedMeasurePropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
            }
        });
        this.setupContextMenu((Control)simpleControl, wiProp);
        cmp.switchToFirstContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text expressionControl = (Text)cmp.getFirstContainer().getData();
            super.update((Control)expressionControl, wip);
            cmp.switchToFirstContainer();
            expressionControl.setToolTipText(this.getToolTip(wip, expressionControl.getText()));
        } else {
            boolean isFallback = false;
            Text simpleControl = (Text)cmp.getSecondContainer().getData();
            if (!this.hasError(simpleControl)) {
                String v = wip.getStaticValue();
                if (v == null && wip.getFallbackValue() != null) {
                    v = wip.getFallbackValue().toString();
                    isFallback = true;
                }
                this.setDataNumber(v, simpleControl, wip);
                this.fallbackModified = !isFallback;
                this.changeFallbackForeground(isFallback, (Control)simpleControl);
                cmp.switchToSecondContainer();
            }
            simpleControl.setToolTipText(this.getToolTip(wip, simpleControl.getText()));
        }
    }

    private String[] buildAutoocompleteValues() {
        String[] result = new String[this.nameKeyUnitsMap.keySet().size()];
        int index = 0;
        Iterator<String> iterator = this.nameKeyUnitsMap.keySet().iterator();
        while (iterator.hasNext()) {
            String measure;
            result[index] = measure = iterator.next();
            ++index;
        }
        return result;
    }

    protected String searchMeasureNameByKey(String key) {
        List<String> namesForKey = this.keyNameUnitsMap.get(key);
        if (namesForKey != null && !namesForKey.isEmpty()) {
            return namesForKey.get(0);
        }
        return null;
    }

    protected String resolveMeasureUnitText(String text, IWItemProperty wiProp) {
        String measureName;
        String measureUnitName = this.getMeasureUnitFromText(text);
        if (measureUnitName != null && this.nameKeyUnitsMap.containsKey(measureUnitName)) {
            return measureUnitName;
        }
        AbstractMeasurePropertyDescription.MeasureDefinition lastModelMeasure = this.getMeasureUnit(wiProp);
        if (lastModelMeasure != null && lastModelMeasure.getName() != null && this.nameKeyUnitsMap.containsKey(measureName = lastModelMeasure.getName())) {
            return measureName;
        }
        if (lastModelMeasure != null && lastModelMeasure.getKey() != null) {
            if (this.nameKeyUnitsMap.containsKey(lastModelMeasure.getKey())) {
                return lastModelMeasure.getKey();
            }
            return this.searchMeasureNameByKey(lastModelMeasure.getKey());
        }
        if (this.keyNameUnitsMap == null) {
            this.keyNameUnitsMap = this.getInversedUnitsMap();
        }
        if (this.keyNameUnitsMap.size() == 1) {
            Map.Entry<String, List<String>> entry = this.keyNameUnitsMap.entrySet().iterator().next();
            return entry.getValue().get(0);
        }
        if (wiProp.getFallbackValue() != null && (measureUnitName = this.getMeasureUnitFromText(wiProp.getFallbackValue().toString())) != null && this.nameKeyUnitsMap.containsKey(measureUnitName)) {
            return measureUnitName;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractMeasurePropertyDescription.MeasureDefinition resolveMeasureUnit(String text, IWItemProperty wItemProp) {
        AbstractMeasurePropertyDescription.MeasureDefinition loadedDefinition = this.getMeasureUnit(wItemProp);
        if (loadedDefinition != null && !this.nameKeyUnitsMap.containsKey(loadedDefinition.getName())) {
            if (this.nameKeyUnitsMap.containsKey(loadedDefinition.getKey())) {
                loadedDefinition.setName(loadedDefinition.getKey());
                return loadedDefinition;
            } else {
                String resolvedByKey = this.searchMeasureNameByKey(loadedDefinition.getKey());
                if (resolvedByKey == null) return null;
                loadedDefinition.setName(resolvedByKey);
            }
            return loadedDefinition;
        } else {
            if (this.keyNameUnitsMap == null) {
                this.keyNameUnitsMap = this.getInversedUnitsMap();
            }
            if (this.keyNameUnitsMap.size() == 1) {
                Map.Entry<String, List<String>> entry = this.keyNameUnitsMap.entrySet().iterator().next();
                return new AbstractMeasurePropertyDescription.MeasureDefinition(entry.getKey(), entry.getValue().get(0));
            }
            String measureUnitName = this.getMeasureUnitFromText(text);
            if (measureUnitName != null && this.nameKeyUnitsMap.containsKey(measureUnitName)) {
                return new AbstractMeasurePropertyDescription.MeasureDefinition(this.nameKeyUnitsMap.get(measureUnitName), measureUnitName);
            }
            if (wItemProp.getFallbackValue() == null) return loadedDefinition;
            measureUnitName = this.getMeasureUnitFromText(wItemProp.getFallbackValue().toString());
            if (measureUnitName == null) return loadedDefinition;
            if (!this.nameKeyUnitsMap.containsKey(measureUnitName)) return loadedDefinition;
            return new AbstractMeasurePropertyDescription.MeasureDefinition(this.nameKeyUnitsMap.get(measureUnitName), measureUnitName);
        }
    }

    public void setDataNumber(String value, Text insertField, IWItemProperty wiProp) {
        if (value != null) {
            Point oldpos = insertField.getSelection();
            AbstractMeasurePropertyDescription.MeasureDefinition measureUnit = this.resolveMeasureUnit(value, wiProp);
            Double number = null;
            String roundedNumber = null;
            boolean error = false;
            if (measureUnit == null) {
                this.setErrorStatus("Measure Unit not recognized", insertField);
                error = true;
            } else {
                String numberText = this.getNumericValue(value);
                try {
                    number = Double.valueOf(numberText);
                    roundedNumber = this.getRoundedValue(measureUnit.getKey(), number);
                }
                catch (Exception exception) {
                    this.setErrorStatus("The number is not valid", insertField);
                    error = true;
                }
            }
            if (error) {
                insertField.setText(value);
            } else {
                this.setErrorStatus(null, insertField);
                insertField.setText(String.valueOf(roundedNumber) + " " + measureUnit.getName());
            }
            if (insertField.getText().length() >= oldpos.y) {
                insertField.setSelection(oldpos);
            }
        } else {
            insertField.setText("");
        }
    }

    @Override
    public String getToolTip() {
        String tt = super.getToolTip();
        if (this.getMin() != null) {
            tt = String.valueOf(tt) + "\nmin: " + this.getMin();
        }
        if (this.getMax() != null) {
            tt = String.valueOf(tt) + "\nmax: " + this.getMax();
        }
        return tt;
    }

    protected String getNumericValue(String textualValue) {
        String value;
        String text = textualValue.trim().toLowerCase();
        String key = this.getMeasureUnitFromText(text);
        if (key != null && (value = text.substring(0, text.indexOf(key))) != null) {
            return value;
        }
        return text;
    }

    protected String getRoundedValue(String measureUnitKey, Double value) {
        if (value == null) {
            return null;
        }
        if (measureUnitKey.trim().toLowerCase().equals("px")) {
            return String.valueOf(value.intValue());
        }
        return format.format(value);
    }

    protected String getWrittenValue(String measureUnitKey, String measureUnitName, Double value) {
        if (value == null) {
            return null;
        }
        String roundedValue = this.getRoundedValue(measureUnitKey, value);
        return String.valueOf(roundedValue) + measureUnitKey;
    }

    @Override
    protected Menu createPopupMenu(Text insertField, IWItemProperty wItemProp) {
        final Menu popUpMenu = new Menu((Control)insertField);
        insertField.setData("measureUnitMenu", (Object)popUpMenu);
        insertField.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                popUpMenu.dispose();
            }
        });
        int i = 0;
        while (i < this.autocompleteValues.length) {
            MenuItem item = new MenuItem(popUpMenu, 8);
            item.setText(this.autocompleteValues[i]);
            item.addSelectionListener((SelectionListener)new MenuAction(this.autocompleteValues[i], insertField, wItemProp));
            ++i;
        }
        return popUpMenu;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (!wiProp.isExpressionMode() && txt instanceof Text) {
            Text insertField = (Text)txt;
            String text = insertField.getText().trim().toLowerCase();
            if (!text.isEmpty() && this.fallbackModified) {
                String measureUnitName = this.resolveMeasureUnitText(text, wiProp);
                String measureUnitKey = this.nameKeyUnitsMap.get(measureUnitName);
                if (measureUnitKey != null) {
                    try {
                        this.setMeasureUnit(measureUnitKey, measureUnitName, wiProp);
                        Double value = Double.valueOf(this.getNumericValue(text));
                        String writtenValue = this.getWrittenValue(measureUnitKey, measureUnitName, value);
                        wiProp.setValue(writtenValue, null);
                        this.setErrorStatus(null, insertField);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setErrorStatus("The number is not valid", insertField);
                    }
                    catch (Unit.PixelConversionException ex) {
                        this.setErrorStatus(ex.getMessage(), insertField);
                    }
                } else {
                    this.setErrorStatus("Measure Unit not recognized", insertField);
                }
            } else {
                wiProp.setValue(null, null);
                this.removeMeasureUnit(wiProp);
            }
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    protected boolean hasError(Text insertField) {
        return ColorConstants.red.equals((Object)insertField.getBackground());
    }

    @Override
    public ItemPropertyElementDialog getDialog(final WItemProperty wItemProp) {
        ItemPropertyElementDialog result = new ItemPropertyElementDialog(UIUtils.getShell(), this, wItemProp){

            @Override
            public boolean close() {
                if (this.getReturnCode() == 0) {
                    AbstractMeasurePropertyDescription.MeasureDefinition currentDef;
                    String propertyName;
                    String measureUnit;
                    Control focusedControl = this.getShell().getDisplay().getFocusControl();
                    if (focusedControl != null) {
                        focusedControl.setEnabled(false);
                    }
                    if ((measureUnit = (String)this.customPropertiesMap.get(String.valueOf(propertyName = wItemProp.getPropertyName()) + "_measureUnit")) != null && (currentDef = FixedMeasurePropertyDescription.this.decode(measureUnit)) != null) {
                        FixedMeasurePropertyDescription.this.setMeasureUnit(currentDef.getKey(), currentDef.getName(), wItemProp);
                    }
                }
                return super.close();
            }

            @Override
            protected Control createDialogArea(Composite parent) {
                AbstractMeasurePropertyDescription.MeasureDefinition currentMeasureDef = FixedMeasurePropertyDescription.this.getMeasureUnit(wItemProp);
                String propertyName = wItemProp.getPropertyName();
                this.customPropertiesMap.put(String.valueOf(propertyName) + "_measureUnit", FixedMeasurePropertyDescription.this.encode(currentMeasureDef));
                return super.createDialogArea(parent);
            }
        };
        result.setHelpAvailable(false);
        result.setForceExpressionMode(wItemProp.hasForcedExpression());
        return result;
    }

    protected Map<String, List<String>> getInversedUnitsMap() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> unit : this.nameKeyUnitsMap.entrySet()) {
            String key = unit.getValue().toLowerCase();
            ArrayList<String> list = (ArrayList<String>)result.get(key);
            if (list == null) {
                list = new ArrayList<String>();
                list.add(unit.getKey());
                result.put(key, list);
                continue;
            }
            list.add(unit.getKey());
        }
        return result;
    }

    protected Map<String, String> createMesureUnitsMap(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd) {
        HashMap<String, String> i18nOpts = new HashMap<String, String>();
        if (cpd.getComboOptions() != null) {
            String[][] opts = cpd.getComboOptions();
            int i = 0;
            while (i < opts.length) {
                i18nOpts.put(cd.getLocalizedString(opts[i][1]).toLowerCase().trim(), opts[i][0].trim());
                ++i;
            }
        } else {
            i18nOpts.put("pixel", "px");
            i18nOpts.put("pixels", "px");
            i18nOpts.put("px", "px");
            i18nOpts.put("inches", "inch");
            i18nOpts.put("inch", "inch");
            i18nOpts.put("em", "em");
            i18nOpts.put("centimeter", "cm");
            i18nOpts.put("centimeters", "cm");
            i18nOpts.put("cm", "cm");
            i18nOpts.put("millimeter", "mm");
            i18nOpts.put("millimeters", "mm");
            i18nOpts.put("mm", "mm");
            i18nOpts.put("meter", "m");
            i18nOpts.put("meters", "m");
            i18nOpts.put("m", "m");
        }
        return i18nOpts;
    }

    @Override
    protected void setupContextMenu(final Control c, final IWItemProperty wiProp) {
        super.setupContextMenu(c, wiProp);
        Menu controlMenu = c.getMenu();
        if (controlMenu != null && !controlMenu.isDisposed()) {
            MenuItem[] menuItemArray = controlMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem mi = menuItemArray[n2];
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FixedMeasurePropertyDescription.this.setErrorStatus(null, (Text)c);
                        wiProp.updateWidget();
                    }
                });
                ++n2;
            }
        }
    }

    @Override
    protected void setErrorStatus(String message, Text insertField) {
        if (message != null) {
            super.setErrorStatus(message, insertField);
        } else {
            this.updateBackground(this.defaultBackgroundColor, insertField);
            String tt = this.getToolTip();
            if (this.autocompleteValues.length > 1) {
                tt = String.valueOf(tt) + "\nDouble click to switch between different dimensions";
            }
            insertField.setToolTipText(tt);
        }
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        Long min = this.createMin(cpd);
        Long max = this.createMax(cpd);
        Map<String, String> i18nOpts = this.createMesureUnitsMap(cd, cpd);
        FixedMeasurePropertyDescription intDesc = new FixedMeasurePropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue(), min, max, i18nOpts);
        intDesc.setReadOnly(cpd.isReadOnly());
        intDesc.setFallbackValue(cpd.getFallbackValue());
        intDesc.setjConfig(jConfig);
        return intDesc;
    }

    @Override
    public ItemPropertyDescription<String> clone() {
        FixedMeasurePropertyDescription result = new FixedMeasurePropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.min = this.min;
        result.max = this.max;
        result.nameKeyUnitsMap = this.nameKeyUnitsMap;
        result.autocompleteValues = this.autocompleteValues;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    private class MenuAction
    implements SelectionListener {
        private String value;
        private Text insertField;
        private IWItemProperty wItemProperty;

        public MenuAction(String value, Text insertField, IWItemProperty wItemProperty) {
            this.value = value;
            this.insertField = insertField;
            this.wItemProperty = wItemProperty;
        }

        public void widgetSelected(SelectionEvent e) {
            String textValue = this.insertField.getText().trim();
            Point oldpos = this.insertField.getSelection();
            String numberText = FixedMeasurePropertyDescription.this.getNumericValue(textValue);
            this.insertField.setText(String.valueOf(numberText) + this.value);
            if (this.insertField.getText().length() >= oldpos.y) {
                this.insertField.setSelection(oldpos);
            }
            try {
                Double.valueOf(numberText);
                FixedMeasurePropertyDescription.this.handleEdit((Control)this.insertField, this.wItemProperty);
            }
            catch (Exception exception) {
                FixedMeasurePropertyDescription.this.setErrorStatus("The number is not valid", this.insertField);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class MouseClickListener
    implements MouseListener {
        private Text insertField;
        private IWItemProperty wItemProp;

        public MouseClickListener(Text insertField, IWItemProperty wItemProp) {
            this.insertField = insertField;
            this.wItemProp = wItemProp;
        }

        public void mouseDoubleClick(MouseEvent e) {
            FixedMeasurePropertyDescription.this.openPopupMenu(this.insertField, this.wItemProp);
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

