/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MultiCheckBoxPropertyDescription<T>
extends AbstractExpressionPropertyDescription<T> {
    private static final int DEFAULT_CHECKBOXES_COL_NUM = 3;
    private int checkboxesColNum = 3;
    private Map<String, String> valuesMap;
    private Map<String, Button> checkboxesMap;

    public MultiCheckBoxPropertyDescription() {
        this.valuesMap = new HashMap<String, String>();
        this.checkboxesMap = new HashMap<String, Button>();
    }

    public MultiCheckBoxPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue, Map<String, String> valuesMap) {
        super(name, label, description, mandatory, defaultValue);
        this.valuesMap = valuesMap;
        this.checkboxesMap = new HashMap<String, Button>();
    }

    @Override
    public void handleEdit(Control control, IWItemProperty wiProp) {
        super.handleEdit(control, wiProp);
        if (control instanceof Composite) {
            String valueAsText = this.convertToTextValue();
            wiProp.setValue(valueAsText, null);
        }
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(4, 4, true, false));
        this.lazyCreateExpressionControl(wiProp, cmp);
        final Composite checkboxesContainer = new Composite(cmp.getSecondContainer(), 0);
        cmp.getSecondContainer().setData((Object)checkboxesContainer);
        checkboxesContainer.setLayout((Layout)new GridLayout(this.checkboxesColNum, false));
        checkboxesContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        for (Map.Entry<String, String> entry : this.valuesMap.entrySet()) {
            Button btn = new Button(checkboxesContainer, 32);
            btn.setLayoutData((Object)new GridData(4, 4, true, false));
            btn.setData((Object)entry.getKey());
            btn.setText(entry.getValue());
            btn.setToolTipText(entry.getValue());
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (wiProp.isRefresh()) {
                        return;
                    }
                    MultiCheckBoxPropertyDescription.this.handleEdit((Control)checkboxesContainer, wiProp);
                }
            });
            this.checkboxesMap.put(entry.getKey(), btn);
        }
        if (this.isReadOnly()) {
            checkboxesContainer.setEnabled(false);
        } else {
            this.setupContextMenu((Control)checkboxesContainer, wiProp);
        }
        cmp.switchToSecondContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text txt = (Text)cmp.getFirstContainer().getData();
            super.update((Control)txt, wip);
            cmp.switchToFirstContainer();
            txt.setToolTipText(this.getToolTip(wip, txt.getText()));
        } else {
            Composite cfr_ignored_0 = (Composite)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
            }
            this.updateCheckboxesWithValues(Misc.nvl((String)v));
            cmp.switchToSecondContainer();
        }
    }

    private String convertToTextValue() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Button> entry : this.checkboxesMap.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            result.append(entry.getKey()).append(",");
        }
        result.setLength(Math.max(result.length() - 1, 0));
        String textValue = result.toString();
        return textValue.isEmpty() ? null : textValue;
    }

    private void updateCheckboxesWithValues(String textValue) {
        List<String> selectedValues = Arrays.asList(textValue.split(","));
        for (Map.Entry<String, Button> entry : this.checkboxesMap.entrySet()) {
            Button btn = entry.getValue();
            Object data = btn.getData();
            boolean found = data instanceof String && selectedValues.contains(((String)data).trim());
            btn.setSelection(found);
        }
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        if (cpd.getComboOptions() != null) {
            String[][] opts = cpd.getComboOptions();
            HashMap<String, String> i18nOptions = new HashMap<String, String>();
            int i = 0;
            while (i < opts.length) {
                i18nOptions.put(opts[i][0], cd.getLocalizedString(opts[i][1]));
                ++i;
            }
            MultiCheckBoxPropertyDescription<String> result = new MultiCheckBoxPropertyDescription<String>(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue(), i18nOptions);
            result.setReadOnly(cpd.isReadOnly());
            result.setFallbackValue(cpd.getFallbackValue());
            return result;
        }
        return null;
    }

    @Override
    public ItemPropertyDescription<T> clone() {
        MultiCheckBoxPropertyDescription<T> result = new MultiCheckBoxPropertyDescription<T>();
        result.defaultValue = this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.valuesMap = this.valuesMap;
        result.fallbackValue = this.fallbackValue;
        return result;
    }
}

