/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;

public class WizardUtils {
    public static JRDesignDataset createDataset(JasperReportsContext jContext, boolean isMain, Map<String, Object> settings) {
        JRDesignDataset dataset = new JRDesignDataset(jContext, isMain);
        JRDesignQuery query = new JRDesignQuery();
        dataset.setQuery(query);
        if (settings != null) {
            Boolean b;
            if (settings.containsKey("wizard_dataset_name")) {
                dataset.setName((String)settings.get("wizard_dataset_name"));
            }
            if (settings.containsKey("wizard_dataset_empty") && (b = (Boolean)settings.get("wizard_dataset_empty")).booleanValue()) {
                return dataset;
            }
            if (settings.containsKey("query_language")) {
                query.setLanguage((String)settings.get("query_language"));
            }
            if (settings.containsKey("query_text")) {
                query.setText((String)settings.get("query_text"));
            }
            if (settings.containsKey("dataset_properties")) {
                JRPropertiesMap map = (JRPropertiesMap)settings.get("dataset_properties");
                String[] stringArray = map.getPropertyNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String prop = stringArray[n2];
                    dataset.setProperty(prop, map.getProperty(prop));
                    ++n2;
                }
            }
            if (settings.containsKey("discovered_parameters")) {
                List prms = (List)settings.get("discovered_parameters");
                for (JRDesignParameter p : prms) {
                    try {
                        dataset.addParameter((JRParameter)p);
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (settings.containsKey("dataset_fields")) {
                List fields = (List)settings.get("dataset_fields");
                for (JRDesignField f : fields) {
                    try {
                        dataset.addField((JRField)f);
                    }
                    catch (JRException ex) {
                        ex.printStackTrace();
                    }
                }
                if (settings.containsKey("group_fields")) {
                    List groupFields = (List)settings.get("group_fields");
                    for (JRDesignField f : groupFields) {
                        try {
                            String name = f.getName();
                            JRDesignGroup group = new JRDesignGroup();
                            group.setName(name);
                            JRDesignExpression jre = new JRDesignExpression();
                            jre.setText("$F{" + name + "}");
                            group.setExpression((JRExpression)jre);
                            dataset.addGroup(group);
                        }
                        catch (JRException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
        return dataset;
    }
}

