/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards.functions;

import com.jaspersoft.studio.utils.VelocityUtils;
import com.jaspersoft.studio.wizards.functions.AdditionalFunctionsCategoriesPage;
import com.jaspersoft.studio.wizards.functions.FunctionsLibraryGenerationUtil;
import com.jaspersoft.studio.wizards.functions.FunctionsLibraryInformationPage;
import com.jaspersoft.studio.wizards.functions.GenerationInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.apache.velocity.app.VelocityEngine;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewFunctionsLibraryWizard
extends Wizard
implements INewWizard {
    private FunctionsLibraryInformationPage page1;
    private AdditionalFunctionsCategoriesPage page2;
    private List<String> availableCategories;

    public NewFunctionsLibraryWizard() {
        this.setWindowTitle("New Functions Library Wizard");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page1 = new FunctionsLibraryInformationPage();
        this.page1.setWizard((IWizard)this);
        this.page1.init(selection);
        this.page2 = new AdditionalFunctionsCategoriesPage();
        this.page2.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        final String libraryName = this.page1.getLibraryName();
        final String packageName = this.page1.getPackageText();
        final String categoryLabel = this.page1.getCategoryLabel();
        final String categoryDescription = this.page1.getCategoryDescription();
        final String categoryClass = this.page1.getCategoryClass();
        final boolean createSampleMethods = this.page1.isCreateSampleFunctions();
        final boolean createSampleReport = this.page1.isCreateSampleReport();
        final ArrayList<String> allCategoriesCategories = new ArrayList<String>();
        allCategoriesCategories.add(categoryClass);
        allCategoriesCategories.addAll(this.page2.getAdditionalCategories());
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IJavaProject javaProject = NewFunctionsLibraryWizard.this.page1.getJavaProject();
                        IPackageFragmentRoot packageFragmentRoot = NewFunctionsLibraryWizard.this.page1.getPackageFragmentRoot();
                        IPackageFragment pFragment = packageFragmentRoot.createPackageFragment(packageName, true, monitor);
                        VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();
                        GenerationInfo config = new GenerationInfo(javaProject, packageFragmentRoot, pFragment, libraryName, packageName);
                        FunctionsLibraryGenerationUtil generationUtil = new FunctionsLibraryGenerationUtil(config, ve, monitor);
                        generationUtil.createFunctionClass(allCategoriesCategories, createSampleMethods);
                        generationUtil.createCategoryClass(categoryClass, categoryLabel, categoryDescription);
                        generationUtil.createJasperReportsExtensionFile();
                        if (createSampleReport) {
                            generationUtil.createSampleJRXML();
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e, "An error occurred during the functions library creation");
                    }
                }
            });
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
        return true;
    }

    public void setAvailableCategories(List<String> categories) {
        this.availableCategories = categories;
    }

    public List<String> getAvailableCategories() {
        return this.availableCategories;
    }

    public boolean canFinish() {
        return this.page1.isPageComplete();
    }
}

