/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.templates;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.templates.IconedTemplateBundle;
import com.jaspersoft.studio.templates.engine.DefaultTemplateEngine;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.templates.TemplateEngine;
import com.jaspersoft.templates.TemplateLoadingException;
import com.jaspersoft.templates.ValidatedTemplateBundle;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class GenericTemplateBundle
implements IconedTemplateBundle,
ValidatedTemplateBundle {
    public static final String MAIN_REPORT = "MAIN_REPORT";
    public static final String DEFAULT_ICON = "blank_a4.png";
    public static final String DEVELOPMENT_VERSION_MASTER = "master";
    public static final String DEVELOPMENT_VERSION_SNAPSHOT = "SNAPSHOT";
    private String label;
    private JasperDesign jasperDesign = null;
    private boolean isExternal;
    protected TemplateEngine templateEngine = null;
    private URL templateURL = null;
    protected List<String> resourceNames;
    protected Properties propertyFile = null;
    protected Map<String, URL> resourceUrls;
    private ImageDescriptor icon = null;
    private JasperReportsContext jrContext;

    public GenericTemplateBundle(URL url, JasperReportsContext jrContext) throws Exception {
        this(url, false, jrContext);
    }

    public GenericTemplateBundle(URL url, boolean isExternal, JasperReportsContext jrContext) throws Exception {
        if (jrContext == null) {
            jrContext = JasperReportsConfiguration.getDefaultInstance();
        }
        this.jrContext = jrContext;
        this.templateURL = url;
        this.isExternal = isExternal;
        String urlPath = URLDecoder.decode(this.templateURL.toExternalForm(), "utf-8");
        if (urlPath.endsWith(".jrxml")) {
            String propertiesPath = urlPath.substring(0, urlPath.length() - 6).concat("_descriptor.properties");
            URL propertiesFile = new URL(propertiesPath);
            if (!this.isExternal() || new File(propertiesFile.getFile()).exists()) {
                this.propertyFile = new Properties();
                InputStream ioStream = null;
                try {
                    ioStream = propertiesFile.openStream();
                    this.propertyFile.load(ioStream);
                }
                finally {
                    FileUtils.closeStream((Closeable)ioStream);
                }
            }
            this.readProperties();
            String[] imageExtensions = new String[]{".png", ".gif", ".jpg"};
            String baseImageUrl = URLDecoder.decode(this.templateURL.toExternalForm(), "utf-8");
            baseImageUrl = baseImageUrl.substring(0, baseImageUrl.length() - ".jrxml".length());
            String[] stringArray = imageExtensions;
            int n = imageExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                try {
                    URL iconURL = new URL(String.valueOf(baseImageUrl) + extension);
                    this.setIcon(this.getIconFromUrl(iconURL));
                    if (this.getIcon() != null) {
                        break;
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            if (this.getIcon() == null) {
                this.setIcon(JaspersoftStudioPlugin.getInstance().getImageDescriptor("templates/blank_a4.png"));
            }
        }
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Override
    public InputStream getResource(String name) {
        if (!this.getResourceNames().contains(name)) {
            return null;
        }
        String url = this.templateURL.toString();
        String mainFileName = new File(this.templateURL.getFile()).getName();
        url = String.valueOf(url.substring(0, url.length() - mainFileName.length())) + name;
        try {
            URL resourceURL = new URL(url);
            return resourceURL.openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public List<String> getResourceNames() {
        if (this.resourceNames == null) {
            String res;
            this.resourceNames = new ArrayList<String>();
            List<JRDesignElement> list = ModelUtils.getAllGElements(this.getJasperDesign());
            for (JRDesignElement el : list) {
                JRSubreport sr;
                JRImage im;
                if (el instanceof JRImage && (res = this.evalResourceName((im = (JRImage)el).getExpression())) != null) {
                    this.resourceNames.add(res);
                }
                if (!(el instanceof JRSubreport) || (res = this.evalResourceName((sr = (JRSubreport)el).getExpression())) == null || !res.endsWith(".jasper")) continue;
                res = String.valueOf(res.substring(0, res.length() - ".jasper".length())) + ".jrxml";
                this.resourceNames.add(res);
            }
            List templates = this.getJasperDesign().getTemplatesList();
            for (JRReportTemplate t : templates) {
                res = this.evalResourceName(t.getSourceExpression());
                if (res == null) continue;
                this.resourceNames.add(res);
            }
        }
        return this.resourceNames;
    }

    @Override
    public Object getProperty(String properyName) {
        if (this.propertyFile != null) {
            return this.propertyFile.getProperty(properyName);
        }
        return this.getJasperDesign().getProperty(properyName);
    }

    protected String evalResourceName(JRExpression exp) {
        if (exp == null) {
            return null;
        }
        if (exp.getText() == null || exp.getText().length() == 0) {
            return null;
        }
        String text = exp.getText().trim();
        if (text.charAt(0) != '\"') {
            return null;
        }
        if ((text = text.substring(1)).lastIndexOf(34) != text.length() - 1) {
            return null;
        }
        if ((text = text.substring(0, text.length() - 1)).indexOf(34) >= 0) {
            return null;
        }
        File f = new File(text);
        if (f.getParent() != null) {
            return null;
        }
        return text;
    }

    protected void loadJasperDesign() throws TemplateLoadingException {
        InputStream is = null;
        try {
            try {
                is = this.templateURL.openStream();
                this.jasperDesign = JRXmlLoader.load((JasperReportsContext)this.jrContext, (InputStream)is);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TemplateLoadingException("Unble to load the template " + this.templateURL.toExternalForm(), e, this.templateURL);
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(is);
            throw throwable;
        }
        FileUtils.closeStream((Closeable)is);
    }

    private ImageDescriptor getIconFromUrl(URL iconURL) {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)iconURL);
        if (descriptor != null && descriptor.getImageData() != null) {
            return descriptor;
        }
        return null;
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public void setIcon(ImageDescriptor templateIcon) {
        this.icon = templateIcon;
    }

    @Override
    public JasperDesign getJasperDesign() {
        if (this.jasperDesign == null) {
            this.loadJasperDesign();
        }
        return this.jasperDesign;
    }

    public URL getTemplateURL() {
        return this.templateURL;
    }

    protected void setTemplateURL(URL templateURL) {
        this.templateURL = templateURL;
    }

    protected void readProperties() {
        String name = null;
        String engine = null;
        if (this.propertyFile != null) {
            name = this.propertyFile.getProperty("template.name");
            engine = this.propertyFile.getProperty("template.engine");
        }
        if (engine == null || engine.toLowerCase().equals("default")) {
            this.templateEngine = new DefaultTemplateEngine();
        }
        if (name == null) {
            name = this.getJasperDesign().getName();
        }
        this.setLabel(name);
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public List<String> validateConfiguration() {
        Object requestedVersion = this.getProperty("jr.required.version");
        if (requestedVersion != null) {
            boolean validVersion;
            String currentVersion = this.getCurrentVersion();
            if (currentVersion.contains(DEVELOPMENT_VERSION_SNAPSHOT) || currentVersion.contains(DEVELOPMENT_VERSION_MASTER)) {
                return null;
            }
            boolean bl = validVersion = this.versionCompare(currentVersion, (String)requestedVersion) >= 0;
            if (!validVersion) {
                ArrayList<String> errors = new ArrayList<String>();
                errors.add(MessageFormat.format(Messages.GenericTemplateBundle_invalidVersionMessage, requestedVersion, currentVersion));
                return errors;
            }
        }
        return null;
    }

    private String getCurrentVersion() {
        String ver = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("com.jaspersoft.studio.compatibility.version");
        if ("last".equals(ver)) {
            return JasperCompileManager.class.getPackage().getImplementationVersion();
        }
        return ver;
    }

    private Integer versionCompare(String str1, String str2) {
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        int i = 0;
        while (i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i])) {
            ++i;
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }
}

