/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.Activator;
import com.jaspersoft.studio.properties.messages.Messages;
import com.jaspersoft.studio.properties.view.AbstractTabDescriptor;
import com.jaspersoft.studio.properties.view.ISectionDescriptor;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TabDescriptor
extends AbstractTabDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_LABEL = "label";
    private static final String ATT_IMAGE = "image";
    private static final String ATT_INDENTED = "indented";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_AFTER_TAB = "afterTab";
    private static final String ATT_SCROLLABLE = "scrollable";
    private static final String TAB_ERROR = Messages.TabDescriptor_Tab_error;
    private String id;
    private String label;
    private ImageDescriptor image;
    private boolean selected;
    private boolean indented;
    private String category;
    private String afterTab;
    private boolean scrollable;

    public TabDescriptor(IConfigurationElement configurationElement) {
        if (configurationElement != null) {
            String indentedString;
            this.id = configurationElement.getAttribute(ATT_ID);
            this.label = configurationElement.getAttribute(ATT_LABEL);
            String imageString = configurationElement.getAttribute(ATT_IMAGE);
            if (imageString != null) {
                this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier(), (String)imageString);
            }
            this.indented = (indentedString = configurationElement.getAttribute(ATT_INDENTED)) != null && indentedString.equals("true");
            String scrollableString = configurationElement.getAttribute(ATT_SCROLLABLE);
            this.scrollable = scrollableString == null || scrollableString.toLowerCase().equals("true");
            this.category = configurationElement.getAttribute(ATT_CATEGORY);
            this.afterTab = configurationElement.getAttribute(ATT_AFTER_TAB);
            if (this.id == null || this.label == null || this.category == null) {
                this.handleTabError(configurationElement, null);
            }
        }
        this.selected = false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getAfterTab() {
        if (this.afterTab == null) {
            return super.getAfterTab();
        }
        return this.afterTab;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    protected boolean append(ISectionDescriptor target) {
        if (!target.getTargetTab().equals(this.id)) {
            return false;
        }
        if (this.insertSectionDescriptor(target)) {
            return true;
        }
        this.getSectionDescriptors().add(target);
        return true;
    }

    private boolean insertSectionDescriptor(ISectionDescriptor target) {
        if (target.getAfterSection().equals("top")) {
            this.getSectionDescriptors().add(0, target);
            return true;
        }
        int i = 0;
        while (i < this.getSectionDescriptors().size()) {
            ISectionDescriptor descriptor = this.getSectionDescriptors().get(i);
            if (target.getAfterSection().equals(descriptor.getId())) {
                this.getSectionDescriptors().add(i + 1, target);
                return true;
            }
            if (descriptor.getAfterSection().equals(target.getId())) {
                this.getSectionDescriptors().add(i, target);
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    private void handleTabError(IConfigurationElement configurationElement, CoreException exception) {
        String pluginId = configurationElement.getDeclaringExtension().getNamespaceIdentifier();
        String message = MessageFormat.format(TAB_ERROR, pluginId);
        Status status = new Status(4, pluginId, 3, message, (Throwable)exception);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected void setImage(ImageDescriptor image) {
        this.image = image;
    }

    protected void setIndented(boolean indented) {
        this.indented = indented;
    }

    protected void setSelected(boolean selected) {
        this.selected = selected;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    @Override
    public ImageDescriptor getImage() {
        return this.image;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isIndented() {
        return this.indented;
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public boolean getScrollable() {
        return this.scrollable;
    }

    public void dispose() {
        if (this.image != null) {
            this.image = null;
        }
    }
}

