/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.internal.TabbedPropertyList;
import com.jaspersoft.studio.properties.internal.TabbedPropertySearch;
import com.jaspersoft.studio.properties.internal.TabbedPropertyTitle;
import com.jaspersoft.studio.properties.layout.StackLayout;
import com.jaspersoft.studio.properties.view.ITabDescriptor;
import com.jaspersoft.studio.properties.view.TabContents;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetWidgetFactory;
import java.util.HashMap;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TabbedPropertyComposite
extends Composite {
    private TabbedPropertySheetWidgetFactory factory;
    private TabbedPropertySheetPage page;
    private Composite mainComposite;
    private Composite tabComposite;
    private TabbedPropertyTitle title;
    private TabbedPropertySearch searchBar;
    private TabbedPropertyList listComposite;
    private boolean displayTitle;
    private StackLayout cachedLayout;
    private HashMap<ITabDescriptor, Control> cacheMap;

    public TabbedPropertyComposite(Composite parent, TabbedPropertySheetPage page, boolean displayTitle) {
        super(parent, 524288);
        this.page = page;
        this.factory = page.getWidgetFactory();
        this.displayTitle = displayTitle;
        this.createMainComposite();
    }

    protected void createMainComposite() {
        this.mainComposite = this.factory.createComposite(this, 524288);
        this.mainComposite.setBackgroundMode(2);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.mainComposite.setLayoutData((Object)formData);
        this.createMainContents();
    }

    protected void createMainContents() {
        Composite parent = new Composite(this.mainComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        if (this.displayTitle) {
            this.title = new TabbedPropertyTitle(parent, this.factory);
            this.title.setLayoutData(new GridData(768));
        }
        this.searchBar = new TabbedPropertySearch(parent, this.page);
        this.searchBar.setLayoutData(new GridData(1808));
        this.listComposite = new TabbedPropertyList(this.mainComposite);
        this.listComposite.getControl().setLayoutData((Object)new GridData(768));
        new Label(this.mainComposite, 258).setLayoutData((Object)new GridData(768));
        this.tabComposite = this.factory.createComposite(this.mainComposite, 524288);
        this.tabComposite.setLayoutData((Object)new GridData(1808));
        this.cachedLayout = new StackLayout();
        this.tabComposite.setLayout((Layout)this.cachedLayout);
        this.cacheMap = new HashMap();
    }

    public void showEmptyPage(boolean value) {
        if (value) {
            if (this.title != null) {
                this.title.setVisible(false);
            }
            this.searchBar.setVisible(false);
            this.tabComposite.setVisible(false);
        } else {
            if (this.title != null && !this.title.isVisible()) {
                this.title.setVisible(true);
            }
            if (!this.searchBar.isVisible()) {
                this.searchBar.setVisible(true);
            }
            if (!this.tabComposite.isVisible()) {
                this.tabComposite.setVisible(true);
            }
        }
    }

    public TabState showTabContents(ITabDescriptor tab, TabContents contents) {
        Control control;
        if (tab == null) {
            this.showEmptyPage(true);
        }
        if ((control = this.cacheMap.get(tab)) == null || control.isDisposed()) {
            return TabState.TAB_NOT_DEFINED;
        }
        if (this.cachedLayout.setTopControl(control)) {
            return TabState.TAB_SET_VISIBLE;
        }
        if (contents.hasDynamicContent()) {
            return TabState.TAB_DYNAMIC_VISIBLE;
        }
        return TabState.TAB_ALREADY_VISIBLE;
    }

    public TabState getTabState(ITabDescriptor tab) {
        Control control = this.cacheMap.get(tab);
        if (control == null || control.isDisposed()) {
            return TabState.TAB_NOT_DEFINED;
        }
        if (this.cachedLayout.getTopControl() == control) {
            return TabState.TAB_ALREADY_VISIBLE;
        }
        return TabState.TAB_NOT_VISIBLE;
    }

    public void layout() {
        this.tabComposite.layout();
        this.mainComposite.layout();
    }

    public void updatePageMinimumSize() {
        Control topControl = this.cachedLayout.getTopControl();
        if (topControl != null && topControl instanceof ScrolledComposite) {
            ScrolledComposite scrolledComposite = (ScrolledComposite)topControl;
            Point compositeSize = scrolledComposite.getContent().computeSize(-1, -1);
            scrolledComposite.setMinHeight(compositeSize.y);
            scrolledComposite.setMinWidth(compositeSize.x);
        }
    }

    public Composite createTabContents(ITabDescriptor tab) {
        Composite comp = null;
        if (tab.getScrollable()) {
            ScrolledComposite scrolledComposite = this.factory.createScrolledComposite(this.tabComposite, 525056);
            scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            scrolledComposite.setAlwaysShowScrollBars(false);
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setShowFocusedControl(true);
            comp = new Composite((Composite)scrolledComposite, 0);
            GridLayout layout2 = new GridLayout();
            layout2.marginWidth = 0;
            layout2.marginHeight = 0;
            layout2.makeColumnsEqualWidth = true;
            comp.setLayout((Layout)layout2);
            comp.setLayoutData((Object)new GridData(1808));
            scrolledComposite.setContent((Control)comp);
            comp.setData((Object)scrolledComposite);
            this.cacheMap.put(tab, (Control)scrolledComposite);
        } else {
            comp = new Composite(this.tabComposite, 0);
            GridLayout layout2 = new GridLayout();
            layout2.marginWidth = 0;
            layout2.marginHeight = 0;
            layout2.makeColumnsEqualWidth = true;
            comp.setLayout((Layout)layout2);
            comp.setLayoutData((Object)new GridData(1808));
            this.cacheMap.put(tab, (Control)comp);
        }
        return comp;
    }

    public void destroyTabContents(ITabDescriptor tab) {
        Control cont = this.cacheMap.get(tab);
        if (cont != null) {
            cont.dispose();
            this.cacheMap.remove(tab);
        }
    }

    public Rectangle getPropertiesArea() {
        return this.tabComposite.getClientArea();
    }

    public TabbedPropertyList getList() {
        return this.listComposite;
    }

    public TabbedPropertyTitle getTitle() {
        return this.title;
    }

    public TabbedPropertySearch getSearchBar() {
        return this.searchBar;
    }

    protected TabbedPropertySheetWidgetFactory getFactory() {
        return this.factory;
    }

    public void dispose() {
        this.listComposite.getControl().dispose();
        if (this.displayTitle) {
            this.title.dispose();
        }
        super.dispose();
    }

    public static enum TabState {
        TAB_NOT_DEFINED,
        TAB_ALREADY_VISIBLE,
        TAB_SET_VISIBLE,
        TAB_DYNAMIC_VISIBLE,
        TAB_NOT_VISIBLE;

    }
}

