/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.internal.TabbedPropertyRegistry;
import com.jaspersoft.studio.properties.view.ITabbedPropertySheetPageContributor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TabbedPropertyRegistryFactory {
    private static TabbedPropertyRegistryFactory INSTANCE = new TabbedPropertyRegistryFactory();
    protected Map<String, CacheData> idToCacheData = new HashMap<String, CacheData>();

    public static TabbedPropertyRegistryFactory getInstance() {
        return INSTANCE;
    }

    private TabbedPropertyRegistryFactory() {
    }

    public TabbedPropertyRegistry createRegistry(ITabbedPropertySheetPageContributor target) {
        String key = target.getContributorId();
        CacheData data = this.idToCacheData.get(key);
        if (data == null) {
            data = new CacheData();
            data.registry = new TabbedPropertyRegistry(key);
            data.references = new ArrayList<ITabbedPropertySheetPageContributor>(5);
            this.idToCacheData.put(key, data);
        }
        data.references.add(target);
        return data.registry;
    }

    public void disposeRegistry(ITabbedPropertySheetPageContributor target) {
        String key = target.getContributorId();
        CacheData data = this.idToCacheData.get(key);
        if (data != null) {
            data.references.remove(target);
            if (data.references.isEmpty()) {
                data.registry.dispose();
                this.idToCacheData.remove(key);
            }
        }
    }

    class CacheData {
        TabbedPropertyRegistry registry;
        List<ITabbedPropertySheetPageContributor> references;

        CacheData() {
        }
    }
}

