/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.view;

import com.jaspersoft.studio.properties.internal.TabbedPropertySearch;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class ErrorsDialog {
    private Shell shell = null;
    private Region region;
    private boolean ignore = false;
    public static int wof = 10;
    public static int hof = 8;
    public static int hh = 5;

    public void createDialog(final TabbedPropertySheetPage tbsp, Point location, List<ValidationError> errors) {
        this.shell = new Shell(Display.getDefault(), 16396);
        this.shell.setBackground(ColorConstants.tooltipBackground);
        this.shell.setLocation(location);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.shell.setLayout((Layout)layout);
        final Table t = new Table((Composite)this.shell, 32772);
        t.setHeaderVisible(false);
        t.setLinesVisible(false);
        t.setBackground(ColorConstants.tooltipBackground);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.horizontalIndent = 15;
        t.setLayoutData((Object)gd);
        t.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorsDialog.this.ignore = true;
                TableItem ti = t.getSelection()[0];
                if (ti.getData() instanceof ValidationError) {
                    ValidationError ve = (ValidationError)ti.getData();
                    if (ve.getProps().isEmpty()) {
                        return;
                    }
                    if (tbsp == null) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            IViewPart p = page.showView("org.eclipse.ui.views.PropertySheet", null, 2);
                            IPage pg = ((PropertySheet)p).getCurrentPage();
                            if (pg instanceof TabbedPropertySheetPage) {
                                TabbedPropertySearch.selectElement(ve.getProps().get(0), (TabbedPropertySheetPage)pg);
                                ErrorsDialog.this.close();
                                return;
                            }
                        }
                        catch (PartInitException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (tbsp != null) {
                        TabbedPropertySearch.selectElement(ve.getProps().get(0), tbsp);
                    }
                }
                ErrorsDialog.this.close();
            }
        });
        for (ValidationError ve : errors) {
            TableItem item1 = new TableItem(t, 0);
            item1.setText(ve.getMessage());
            item1.setData((Object)ve);
            if (ve.isWarning()) {
                item1.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_WARNING"));
                continue;
            }
            item1.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR"));
        }
        this.shell.pack();
        t.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ErrorsDialog.this.ignore) {
                    return;
                }
                ErrorsDialog.this.close();
            }
        });
        t.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    ErrorsDialog.this.close();
                }
            }
        });
        this.region = new Region();
        this.region.add(this.getPolygon());
        this.shell.setRegion(this.region);
        this.shell.open();
        t.forceFocus();
    }

    protected void close() {
        if (this.shell != null) {
            this.shell.close();
        }
        if (this.region != null) {
            this.region.dispose();
        }
        this.shell = null;
    }

    int[] getPolygon() {
        Point e = this.shell.getSize();
        int[] nArray = new int[16];
        nArray[1] = hof + hh;
        nArray[2] = wof;
        nArray[3] = hof;
        nArray[4] = wof;
        nArray[6] = e.x;
        nArray[8] = e.x;
        nArray[9] = e.y;
        nArray[10] = wof;
        nArray[11] = e.y;
        nArray[12] = wof;
        nArray[13] = hof + 2 * hh;
        nArray[15] = hof + hh;
        return nArray;
    }
}

