/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.view;

import com.jaspersoft.studio.properties.layout.DynamicColumnLayout;
import com.jaspersoft.studio.properties.view.ISection;
import com.jaspersoft.studio.properties.view.SectionContainerComposite;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public final class TabContents {
    private ISection[] sections;
    private boolean controlsCreated = false;
    private boolean dynamicContent = false;

    public int getSectionIndex(ISection section) {
        int i = 0;
        while (i < this.sections.length) {
            if (section == this.sections[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ISection getSectionAtIndex(int i) {
        if (i >= 0 && i < this.sections.length) {
            return this.sections[i];
        }
        return null;
    }

    public ISection[] getSections() {
        return this.sections;
    }

    public void createControls(Composite parent, final TabbedPropertySheetPage page) {
        if (this.sections.length > 1) {
            Composite pageComposite = page.getWidgetFactory().createComposite(parent, 524288);
            DynamicColumnLayout layout = new DynamicColumnLayout(page);
            layout.leftMargin = 0;
            layout.topMargin = 0;
            layout.verticalSpacing = 0;
            pageComposite.setLayout((Layout)layout);
            pageComposite.setLayoutData((Object)new GridData(1808));
            int i = 0;
            while (i < this.sections.length) {
                final ISection section = this.sections[i];
                final SectionContainerComposite sectionComposite = page.getWidgetFactory().createSectionComposite(pageComposite, page, 524288);
                sectionComposite.setLayout((Layout)new GridLayout());
                SafeRunnable runnable = new SafeRunnable(){

                    public void run() throws Exception {
                        if (section.getElement() != null) {
                            section.createControls(sectionComposite, page);
                        }
                    }
                };
                SafeRunnable.run((ISafeRunnable)runnable);
                ++i;
            }
        } else if (this.sections.length > 0) {
            final ISection section = this.sections[0];
            final Composite sectionComposite = parent;
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    if (section.getElement() != null) {
                        section.createControls(sectionComposite, page);
                    }
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        }
        this.controlsCreated = true;
    }

    public void dispose() {
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.dispose();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public void aboutToBeShown() {
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.aboutToBeShown();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public void aboutToBeHidden() {
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.aboutToBeHidden();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public void setInput(final IWorkbenchPart part, final ISelection selection) {
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.setInput(part, selection);
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public void setSections(ISection[] sections) {
        this.sections = sections;
        if (sections != null) {
            ISection[] iSectionArray = sections;
            int n = sections.length;
            int n2 = 0;
            while (n2 < n) {
                ISection section = iSectionArray[n2];
                if (section.hasDynamicContent()) {
                    this.dynamicContent = true;
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean controlsHaveBeenCreated() {
        return this.controlsCreated;
    }

    public void refresh() {
        if (this.controlsCreated) {
            int i = 0;
            while (i < this.sections.length) {
                final ISection section = this.sections[i];
                SafeRunnable runnable = new SafeRunnable(){

                    public void run() throws Exception {
                        section.refresh();
                    }
                };
                SafeRunnable.run((ISafeRunnable)runnable);
                ++i;
            }
        }
    }

    public boolean hasDynamicContent() {
        return this.dynamicContent;
    }
}

