/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal.keys;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEProtectionRemoverFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.gpg.bc.internal.keys.OCBPBEProtectionRemoverFactory;
import org.eclipse.jgit.gpg.bc.internal.keys.SExprParser;
import org.eclipse.jgit.util.RawParseUtils;

public final class SecretKeys {
    private static final byte[] PROTECTED_KEY = "protected-private-key".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] OCB_PROTECTED = "openpgp-s2k3-ocb-aes".getBytes(StandardCharsets.US_ASCII);

    private SecretKeys() {
    }

    /*
     * Loose catch block
     */
    public static PGPSecretKey readSecretKey(InputStream in, PGPDigestCalculatorProvider calculatorProvider, PassphraseSupplier passphraseSupplier, PGPPublicKey publicKey) throws IOException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        byte[] data = Streams.readAll((InputStream)in);
        if (data.length == 0) {
            throw new EOFException();
        }
        if (data.length < 4 + PROTECTED_KEY.length) {
            throw new IOException(MessageFormat.format(BCText.get().secretKeyTooShort, Integer.toUnsignedString(data.length)));
        }
        SExprParser parser = new SExprParser(calculatorProvider);
        byte firstChar = data[0];
        try {
            if (firstChar == 40) {
                JcePBEProtectionRemoverFactory decryptor = null;
                if (SecretKeys.matches(data, 4, PROTECTED_KEY)) {
                    decryptor = new JcePBEProtectionRemoverFactory(passphraseSupplier.getPassphrase(), calculatorProvider);
                }
                Throwable throwable = null;
                Object var9_15 = null;
                try (ByteArrayInputStream sIn = new ByteArrayInputStream(data);){
                    return parser.parseSecretKey((InputStream)sIn, (PBEProtectionRemoverFactory)decryptor, publicKey);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Throwable decryptor = null;
            Object var8_13 = null;
            try {
                PGPSecretKey pGPSecretKey;
                ByteArrayInputStream sIn;
                Throwable throwable;
                ByteArrayInputStream keyIn;
                block46: {
                    keyIn = new ByteArrayInputStream(data);
                    byte[] rawData = SecretKeys.keyFromNameValueFormat(keyIn);
                    if (!SecretKeys.matches(rawData, 1, PROTECTED_KEY)) {
                        PGPSecretKey pGPSecretKey2;
                        ByteArrayInputStream sIn2;
                        Throwable throwable3;
                        block45: {
                            throwable3 = null;
                            Object var12_23 = null;
                            sIn2 = new ByteArrayInputStream(SecretKeys.convertSexpression(rawData));
                            pGPSecretKey2 = parser.parseSecretKey((InputStream)sIn2, null, publicKey);
                            if (sIn2 == null) break block45;
                            ((InputStream)sIn2).close();
                        }
                        return pGPSecretKey2;
                        {
                            catch (Throwable throwable4) {
                                try {
                                    if (sIn2 != null) {
                                        ((InputStream)sIn2).close();
                                    }
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable5;
                                    } else if (throwable3 != throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    boolean[] isOCB = new boolean[1];
                    byte[] sExp = SecretKeys.convertSexpression(rawData, isOCB);
                    Object decryptor2 = isOCB[0] ? new OCBPBEProtectionRemoverFactory(passphraseSupplier.getPassphrase(), calculatorProvider, SecretKeys.getAad(sExp)) : new JcePBEProtectionRemoverFactory(passphraseSupplier.getPassphrase(), calculatorProvider);
                    throwable = null;
                    Object var15_30 = null;
                    sIn = new ByteArrayInputStream(sExp);
                    pGPSecretKey = parser.parseSecretKey((InputStream)sIn, (PBEProtectionRemoverFactory)decryptor2, publicKey);
                    if (sIn == null) break block46;
                    ((InputStream)sIn).close();
                }
                return pGPSecretKey;
                {
                    catch (Throwable throwable6) {
                        try {
                            if (sIn != null) {
                                ((InputStream)sIn).close();
                            }
                            throw throwable6;
                        }
                        catch (Throwable throwable7) {
                            if (throwable == null) {
                                throwable = throwable7;
                            } else if (throwable != throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (keyIn != null) {
                        keyIn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (decryptor == null) {
                    decryptor = throwable;
                } else if (decryptor != throwable) {
                    decryptor.addSuppressed(throwable);
                }
                throw decryptor;
            }
        }
        catch (IOException e) {
            throw new PGPException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private static byte[] getAad(byte[] sExp) {
        int i = 1;
        while (sExp[i] != 40) {
            ++i;
        }
        int aadStart = i++;
        int aadEnd = SecretKeys.skip(sExp, aadStart);
        byte[] protectedPrefix = "(9:protected".getBytes(StandardCharsets.US_ASCII);
        while (!SecretKeys.matches(sExp, i, protectedPrefix)) {
            ++i;
        }
        int protectedStart = i;
        int protectedEnd = SecretKeys.skip(sExp, protectedStart);
        byte[] aadData = new byte[aadEnd - aadStart - (protectedEnd - protectedStart)];
        System.arraycopy(sExp, aadStart, aadData, 0, protectedStart - aadStart);
        System.arraycopy(sExp, protectedEnd, aadData, protectedStart - aadStart, aadEnd - protectedEnd);
        return aadData;
    }

    private static int skip(byte[] sExp, int start) {
        int i = start + 1;
        int depth = 1;
        while (depth > 0) {
            switch (sExp[i]) {
                case 40: {
                    ++depth;
                    break;
                }
                case 41: {
                    --depth;
                    break;
                }
                default: {
                    int j = i;
                    while (sExp[j] >= 48 && sExp[j] <= 57) {
                        ++j;
                    }
                    int length = Integer.parseInt(new String(sExp, i, j - i, StandardCharsets.US_ASCII));
                    i = j + length;
                }
            }
            ++i;
        }
        return i;
    }

    private static boolean matches(byte[] src, int from, byte[] needle) {
        if (from < 0 || from + needle.length > src.length) {
            return false;
        }
        return Arrays.constantTimeAreEqual((int)needle.length, (byte[])src, (int)from, (byte[])needle, (int)0);
    }

    private static byte[] convertSexpression(byte[] humanForm) throws IOException {
        boolean[] isOCB = new boolean[1];
        return SecretKeys.convertSexpression(humanForm, isOCB);
    }

    private static byte[] convertSexpression(byte[] humanForm, boolean[] isOCB) throws IOException {
        int pos = 0;
        Throwable throwable = null;
        Object var4_5 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(humanForm.length);){
            while (pos < humanForm.length) {
                int start;
                int l;
                byte b = humanForm[pos];
                if (b == 40 || b == 41) {
                    out.write(b);
                    ++pos;
                    continue;
                }
                if (SecretKeys.isGpgSpace(b)) {
                    ++pos;
                    continue;
                }
                if (b == 35) {
                    int i = ++pos;
                    while (i < humanForm.length && SecretKeys.isHex(humanForm[i])) {
                        ++i;
                    }
                    if (i == pos || humanForm[i] != 35) {
                        throw new StreamCorruptedException(BCText.get().sexprHexNotClosed);
                    }
                    if ((i - pos) % 2 != 0) {
                        throw new StreamCorruptedException(BCText.get().sexprHexOdd);
                    }
                    l = (i - pos) / 2;
                    out.write(Integer.toString(l).getBytes(StandardCharsets.US_ASCII));
                    out.write(58);
                    while (pos < i) {
                        int x = SecretKeys.nibble(humanForm[pos]) << 4 | SecretKeys.nibble(humanForm[pos + 1]);
                        pos += 2;
                        out.write(x);
                    }
                    pos = i + 1;
                    continue;
                }
                if (SecretKeys.isTokenChar(b)) {
                    start = pos++;
                    while (pos < humanForm.length && SecretKeys.isTokenChar(humanForm[pos])) {
                        ++pos;
                    }
                    l = pos - start;
                    if (pos - start == OCB_PROTECTED.length && SecretKeys.matches(humanForm, start, OCB_PROTECTED)) {
                        isOCB[0] = true;
                    }
                    out.write(Integer.toString(l).getBytes(StandardCharsets.US_ASCII));
                    out.write(58);
                    out.write(humanForm, start, pos - start);
                    continue;
                }
                if (b == 34) {
                    start = ++pos;
                    boolean escaped = false;
                    while (pos < humanForm.length && (escaped || humanForm[pos] != 34)) {
                        byte ch = humanForm[pos++];
                        boolean bl = escaped = !escaped && ch == 92;
                    }
                    if (pos >= humanForm.length) {
                        throw new StreamCorruptedException(BCText.get().sexprStringNotClosed);
                    }
                    byte[] dq = SecretKeys.dequote(humanForm, start, pos);
                    out.write(Integer.toString(dq.length).getBytes(StandardCharsets.US_ASCII));
                    out.write(58);
                    out.write(dq);
                    ++pos;
                    continue;
                }
                throw new StreamCorruptedException(MessageFormat.format(BCText.get().sexprUnhandled, Integer.toHexString(b & 0xFF)));
            }
            return out.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] dequote(byte[] in, int from, int to) throws StreamCorruptedException {
        byte[] out = new byte[to - from];
        int j = 0;
        int i = from;
        block13: while (i < to) {
            byte b;
            if ((b = in[i++]) != 92) {
                out[j++] = b;
                continue;
            }
            if (i == to) {
                throw new StreamCorruptedException(BCText.get().sexprStringInvalidEscapeAtEnd);
            }
            b = in[i++];
            switch (b) {
                case 98: {
                    out[j++] = 8;
                    break;
                }
                case 102: {
                    out[j++] = 12;
                    break;
                }
                case 110: {
                    out[j++] = 10;
                    break;
                }
                case 114: {
                    out[j++] = 13;
                    break;
                }
                case 116: {
                    out[j++] = 9;
                    break;
                }
                case 118: {
                    out[j++] = 11;
                    break;
                }
                case 34: 
                case 39: 
                case 92: {
                    out[j++] = b;
                    break;
                }
                case 13: {
                    if (i >= to || in[i] != 10) continue block13;
                    ++i;
                    break;
                }
                case 10: {
                    if (i >= to || in[i] != 13) continue block13;
                    ++i;
                    break;
                }
                case 120: {
                    if (i + 1 >= to || !SecretKeys.isHex(in[i]) || !SecretKeys.isHex(in[i + 1])) {
                        throw new StreamCorruptedException(BCText.get().sexprStringInvalidHexEscape);
                    }
                    out[j++] = (byte)(SecretKeys.nibble(in[i]) << 4 | SecretKeys.nibble(in[i + 1]));
                    i += 2;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    if (!(i + 2 < to && SecretKeys.isOctal(in[i]) && SecretKeys.isOctal(in[i + 1]) && SecretKeys.isOctal(in[i + 2]))) {
                        throw new StreamCorruptedException(BCText.get().sexprStringInvalidOctalEscape);
                    }
                    out[j++] = (byte)((in[i] - 48 << 3 | in[i + 1] - 48) << 3 | in[i + 2] - 48);
                    i += 3;
                    break;
                }
                default: {
                    throw new StreamCorruptedException(MessageFormat.format(BCText.get().sexprStringInvalidEscape, Integer.toHexString(b & 0xFF)));
                }
            }
        }
        return java.util.Arrays.copyOf(out, j);
    }

    static byte[] keyFromNameValueFormat(InputStream in) throws IOException {
        byte[] rawData;
        ByteArrayOutputStream out;
        int[] nameLow = new int[]{107, 101, 121, 58};
        int[] nameCap = new int[]{75, 69, 89, 58};
        int nameIdx = 0;
        while (true) {
            int next;
            if ((next = in.read()) < 0) {
                throw new EOFException();
            }
            if (next == 10) {
                nameIdx = 0;
                continue;
            }
            if (nameIdx < 0) continue;
            if (nameLow[nameIdx] == next || nameCap[nameIdx] == next) {
                if (++nameIdx != nameLow.length) continue;
                break;
            }
            nameIdx = -1;
        }
        int last = 58;
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            out = new ByteArrayOutputStream(8192);
            try {
                int next;
                while ((next = in.read()) >= 0) {
                    if (last == 10) {
                        if (next != 32 && next != 9) break;
                        last = next;
                        continue;
                    }
                    out.write(next);
                    last = next;
                }
                rawData = out.toByteArray();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_8 = null;
        try {
            out = new ByteArrayOutputStream(rawData.length);
            try {
                int lineStart = 0;
                boolean trimLeading = true;
                while (lineStart < rawData.length) {
                    int nextLineStart = RawParseUtils.nextLF((byte[])rawData, (int)lineStart);
                    if (trimLeading) {
                        while (lineStart < nextLineStart && SecretKeys.isGpgSpace(rawData[lineStart])) {
                            ++lineStart;
                        }
                    }
                    int i = nextLineStart - 1;
                    while (lineStart < i && SecretKeys.isGpgSpace(rawData[i])) {
                        --i;
                    }
                    if (i <= lineStart) {
                        out.write(10);
                        trimLeading = true;
                    } else {
                        out.write(rawData, lineStart, i - lineStart + 1);
                        trimLeading = false;
                    }
                    lineStart = nextLineStart;
                }
                return out.toByteArray();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static boolean isGpgSpace(int ch) {
        return ch == 32 || ch == 9 || ch == 13 || ch == 10;
    }

    private static boolean isTokenChar(int ch) {
        switch (ch) {
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 61: 
            case 95: {
                return true;
            }
        }
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57;
    }

    private static boolean isHex(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
    }

    private static boolean isOctal(int ch) {
        return ch >= 48 && ch <= 55;
    }

    private static int nibble(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static interface PassphraseSupplier {
        public char[] getPassphrase() throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException;
    }
}

