/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model;

import com.jaspersoft.studio.components.chart.ChartNodeIconDescriptor;
import com.jaspersoft.studio.components.chart.model.command.ChartSetValueCommandProvider;
import com.jaspersoft.studio.components.chart.model.plot.MChartPlot;
import com.jaspersoft.studio.components.chart.model.plot.PlotFactory;
import com.jaspersoft.studio.components.chart.property.descriptor.CustomizerPropertyDescriptor;
import com.jaspersoft.studio.components.chart.property.descriptor.CustomizerPropertyExpressionsDTO;
import com.jaspersoft.studio.components.chart.property.descriptor.PlotPropertyDescriptor;
import com.jaspersoft.studio.components.chart.property.widget.ChartThemeComboBoxPropertyDescriptor;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.CategorySerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.GanttSeries;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.PieSerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.TimePeriodSerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.TimeSerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.XySerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.XyzSerie;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.MGraphicElementLineBox;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.text.MFont;
import com.jaspersoft.studio.model.text.MFontUtil;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.ReportFactory;
import com.jaspersoft.studio.property.ISetValueCommandProvider;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.text.FontPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.EdgePropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.SpinnerPropertyDescriptor;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import com.jaspersoft.studio.utils.EnumHelper;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignDataRange;
import net.sf.jasperreports.charts.design.JRDesignGanttDataset;
import net.sf.jasperreports.charts.design.JRDesignGanttSeries;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignItemLabel;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodDataset;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignValueDisplay;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXySeries;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzSeries;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MChart
extends MGraphicElementLineBox
implements IContainer,
IContainerEditPart,
IPastable,
IDatasetContainer {
    public static final long serialVersionUID = 10200L;
    public static final String PLOTPROPERTY = "PLOTPROPERTY";
    public static final String CHART_PROPERTY_CUSTOMIZER = "multiCustomizerProperty";
    private static IIconDescriptor iconDescriptor;
    private static EdgePropertyDescriptor titlePositionD;
    private static EdgePropertyDescriptor legendPositionD;
    private static NamedEnumPropertyDescriptor<EvaluationTimeEnum> evaluationTimeD;
    private IPropertyDescriptor[] descriptors;
    private RComboBoxPropertyDescriptor evaluationGroupD;
    private MChartPlot mChartPlot;
    private MFont tFont;
    private MFont stFont;
    private MFont lFont;
    private MHyperLink mHyperLink;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new ChartNodeIconDescriptor("chart");
        }
        return iconDescriptor;
    }

    public MChart() {
    }

    public MChart(ANode parent, int newIndex) {
        super(parent, newIndex);
    }

    public MChart(ANode parent, JRChart jrChart, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrChart);
    }

    public JRDesignChart getValue() {
        return (JRDesignChart)super.getValue();
    }

    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        titlePositionD = new EdgePropertyDescriptor((Object)"titlePosition", com.jaspersoft.studio.components.chart.messages.Messages.MChart_title_position, NullEnum.NULL);
        titlePositionD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_title_position_description);
        titlePositionD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chartTitle_position"));
        desc.add((IPropertyDescriptor)titlePositionD);
        evaluationTimeD = new NamedEnumPropertyDescriptor((Object)"evaluationTime", com.jaspersoft.studio.components.chart.messages.Messages.MChart_evaluation_time, (Enum)EvaluationTimeEnum.AUTO, NullEnum.NOTNULL);
        evaluationTimeD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_evaluation_time_description);
        desc.add((IPropertyDescriptor)evaluationTimeD);
        CustomizerPropertyDescriptor classD = new CustomizerPropertyDescriptor(CHART_PROPERTY_CUSTOMIZER, com.jaspersoft.studio.components.chart.messages.Messages.MChart_customizer_class);
        classD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_customizer_class_description);
        desc.add((IPropertyDescriptor)classD);
        CheckBoxPropertyDescriptor showLegendD = new CheckBoxPropertyDescriptor((Object)"isShowLegend", com.jaspersoft.studio.components.chart.messages.Messages.MChart_show_legend, NullEnum.NULL);
        showLegendD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_show_legend_description);
        desc.add((IPropertyDescriptor)showLegendD);
        RWComboBoxPropertyDescriptor rendererTypeD = new RWComboBoxPropertyDescriptor((Object)"renderType", com.jaspersoft.studio.components.chart.messages.Messages.MChart_renderer_type, new String[]{"", "draw", "image", "svg"}, NullEnum.NULL);
        rendererTypeD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_renderer_type_description);
        desc.add((IPropertyDescriptor)rendererTypeD);
        ChartThemeComboBoxPropertyDescriptor themeD = new ChartThemeComboBoxPropertyDescriptor("theme", com.jaspersoft.studio.components.chart.messages.Messages.MChart_theme, NullEnum.NULL);
        themeD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_theme_description);
        desc.add((IPropertyDescriptor)themeD);
        this.evaluationGroupD = new RComboBoxPropertyDescriptor((Object)"evaluationGroup", com.jaspersoft.studio.components.chart.messages.Messages.MChart_evaluation_group, new String[]{""});
        this.evaluationGroupD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_evaluation_group_description);
        desc.add((IPropertyDescriptor)this.evaluationGroupD);
        PlotPropertyDescriptor plotD = new PlotPropertyDescriptor(PLOTPROPERTY, com.jaspersoft.studio.components.chart.messages.Messages.MChart_plot);
        plotD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_plot_description);
        desc.add((IPropertyDescriptor)plotD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chart");
        if (this.mHyperLink == null) {
            this.mHyperLink = new MHyperLink(null);
        }
        this.mHyperLink.createPropertyDescriptors(desc);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chart");
        FontPropertyDescriptor titleFontD = new FontPropertyDescriptor((Object)"titleFont", com.jaspersoft.studio.components.chart.messages.Messages.MChart_title_font);
        titleFontD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_title_font_description);
        desc.add((IPropertyDescriptor)titleFontD);
        titleFontD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#font"));
        ColorPropertyDescriptor titleColorD = new ColorPropertyDescriptor((Object)"titleColor", com.jaspersoft.studio.components.chart.messages.Messages.MChart_title_color, NullEnum.INHERITED);
        titleColorD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_title_color_description);
        desc.add((IPropertyDescriptor)titleColorD);
        JRExpressionPropertyDescriptor titleExprD = new JRExpressionPropertyDescriptor((Object)"titleExpression", com.jaspersoft.studio.components.chart.messages.Messages.MChart_title_expression);
        titleExprD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_title_expression_description);
        desc.add((IPropertyDescriptor)titleExprD);
        titleExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#titleExpression"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chartTitle");
        FontPropertyDescriptor subtitleFontD = new FontPropertyDescriptor((Object)"subtitleFont", com.jaspersoft.studio.components.chart.messages.Messages.MChart_subtitle_font);
        subtitleFontD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_subtitle_font_description);
        desc.add((IPropertyDescriptor)subtitleFontD);
        subtitleFontD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#font"));
        ColorPropertyDescriptor subtitleColorD = new ColorPropertyDescriptor((Object)"subtitleColor", com.jaspersoft.studio.components.chart.messages.Messages.MChart_subtitle_color, NullEnum.INHERITED);
        subtitleColorD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_subtitle_color_description);
        desc.add((IPropertyDescriptor)subtitleColorD);
        JRExpressionPropertyDescriptor subtitleExprD = new JRExpressionPropertyDescriptor((Object)"subtitleExpression", com.jaspersoft.studio.components.chart.messages.Messages.MChart_subtitle_expression);
        subtitleExprD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_subtitle_expression_description);
        desc.add((IPropertyDescriptor)subtitleExprD);
        subtitleExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#subtitleExpression"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chartSubtitle");
        FontPropertyDescriptor legendFontD = new FontPropertyDescriptor((Object)"legendFont", com.jaspersoft.studio.components.chart.messages.Messages.MChart_legend_font);
        legendFontD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_legend_font_description);
        desc.add((IPropertyDescriptor)legendFontD);
        legendFontD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#font"));
        ColorPropertyDescriptor legendColorD = new ColorPropertyDescriptor((Object)"legendColor", com.jaspersoft.studio.components.chart.messages.Messages.MChart_legend_color, NullEnum.INHERITED);
        legendColorD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_legend_color_description);
        desc.add((IPropertyDescriptor)legendColorD);
        ColorPropertyDescriptor legendBackColorD = new ColorPropertyDescriptor((Object)"legendBackgroundColor", com.jaspersoft.studio.components.chart.messages.Messages.MChart_legend_background_color, NullEnum.INHERITED);
        legendBackColorD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_legend_background_color_description);
        desc.add((IPropertyDescriptor)legendBackColorD);
        legendPositionD = new EdgePropertyDescriptor((Object)"legendPosition", com.jaspersoft.studio.components.chart.messages.Messages.MChart_legend_position, NullEnum.NULL);
        legendPositionD.setDescription(com.jaspersoft.studio.components.chart.messages.Messages.MChart_legend_position_description);
        legendPositionD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chartLegend_position"));
        desc.add((IPropertyDescriptor)legendPositionD);
        JRExpressionPropertyDescriptor anchorNameExp = new JRExpressionPropertyDescriptor((Object)"anchorNameExpression", Messages.MTextField_anchorNameLabel);
        anchorNameExp.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("http://127.0.0.1:55429/help/topic/net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#anchorNameExpression"));
        anchorNameExp.setDescription(Messages.MTextField_anchorNameDescription);
        desc.add((IPropertyDescriptor)anchorNameExp);
        JRExpressionPropertyDescriptor bookmarkLevelExp = new JRExpressionPropertyDescriptor((Object)"bookmarkLevelExpression", Messages.MTextField_bookmarkLevelExpression);
        bookmarkLevelExp.setDescription(Messages.MTextField_bookmarkLevelExpressionDescription);
        desc.add((IPropertyDescriptor)bookmarkLevelExp);
        SpinnerPropertyDescriptor bookmarkLevel = new SpinnerPropertyDescriptor((Object)"bookmarkLevel", Messages.MTextField_bookmarkLevelLabel);
        bookmarkLevel.setDescription(Messages.MTextField_bookmarkLevelDescription);
        bookmarkLevel.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chart_bookmarkLevel"));
        desc.add((IPropertyDescriptor)bookmarkLevel);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chartLegend");
        titleFontD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_title_category);
        titleColorD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_title_category);
        titlePositionD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_title_category);
        titleExprD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_title_category);
        subtitleFontD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_subtitle_category);
        subtitleExprD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_subtitle_category);
        subtitleColorD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_subtitle_category);
        plotD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_common_chart_properties_category);
        this.evaluationGroupD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_common_chart_properties_category);
        themeD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_common_chart_properties_category);
        classD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_common_chart_properties_category);
        legendFontD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_legend_category);
        legendBackColorD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_legend_category);
        legendColorD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_legend_category);
        legendPositionD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_legend_category);
        showLegendD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_chart_legend_category);
        evaluationTimeD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_common_chart_properties_category);
        rendererTypeD.setCategory(com.jaspersoft.studio.components.chart.messages.Messages.MChart_common_chart_properties_category);
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("theme", new DefaultValue(null, true));
        defaultsMap.put("customizerClass", new DefaultValue(null, true));
        defaultsMap.put("isShowLegend", new DefaultValue((Object)true, true));
        defaultsMap.put("titleColor", new DefaultValue(null, true));
        defaultsMap.put("subtitleColor", new DefaultValue(null, true));
        defaultsMap.put("legendColor", new DefaultValue(null, true));
        defaultsMap.put("legendBackgroundColor", new DefaultValue(null, true));
        defaultsMap.put("titleFont", new DefaultValue(null, true));
        defaultsMap.put("subtitleFont", new DefaultValue(null, true));
        defaultsMap.put("legendFont", new DefaultValue(null, true));
        defaultsMap.put("titlePosition", new DefaultValue(null, true));
        defaultsMap.put("legendPosition", new DefaultValue(null, true));
        defaultsMap.put("evaluationTime", new DefaultValue((Object)EvaluationTimeEnum.NOW, true));
        defaultsMap.putAll(new MHyperLink(null).getDefaultsPropertiesMap());
        return defaultsMap;
    }

    public void setGroupItems(String[] items) {
        super.setGroupItems(items);
        if (this.evaluationGroupD != null) {
            this.evaluationGroupD.setItems(items);
        }
    }

    public Object getPropertyActualValue(Object id) {
        JSSStyleResolver sr = this.getStyleResolver();
        JRDesignChart jrElement = this.getValue();
        if (id.equals("titlePosition")) {
            EdgeEnum position = jrElement.getTitlePositionValue();
            return titlePositionD.getIntValue((Enum)(position != null ? position : EdgeEnum.TOP));
        }
        if (id.equals("legendPosition")) {
            EdgeEnum position = jrElement.getLegendPositionValue();
            return legendPositionD.getIntValue((Enum)(position != null ? position : EdgeEnum.BOTTOM));
        }
        if (id.equals("titleColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)sr.getTitleColor((JRChart)jrElement));
        }
        if (id.equals("subtitleColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)sr.getSubtitleColor((JRChart)jrElement));
        }
        if (id.equals("legendColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)sr.getLegendColor((JRChart)jrElement));
        }
        if (id.equals("legendBackgroundColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)sr.getLegendBackgroundColor((JRChart)jrElement));
        }
        if (id.equals("isShowLegend")) {
            return jrElement.getShowLegend() != null ? jrElement.getShowLegend() : true;
        }
        if (id.equals("titleFont")) {
            this.tFont = MFontUtil.getMFont((MFont)this.tFont, (JRFont)jrElement.getTitleFont(), (JRStyle)jrElement.getStyle(), (APropertyNode)this);
            return this.tFont;
        }
        return super.getPropertyActualValue(id);
    }

    public Object getPropertyValue(Object id) {
        JRDesignChart jrElement = this.getValue();
        if (id.equals(CHART_PROPERTY_CUSTOMIZER)) {
            PropertyExpressionsDTO dto = (PropertyExpressionsDTO)super.getPropertyValue((Object)"propertyExpressions");
            return new CustomizerPropertyExpressionsDTO(dto, this);
        }
        if (id.equals("titlePosition")) {
            return titlePositionD.getIntValue((Enum)jrElement.getTitlePositionValue());
        }
        if (id.equals("legendPosition")) {
            return legendPositionD.getIntValue((Enum)jrElement.getLegendPositionValue());
        }
        if (id.equals("evaluationTime")) {
            return jrElement.getEvaluationTimeValue();
        }
        if (id.equals("renderType")) {
            return jrElement.getRenderType();
        }
        if (id.equals("theme")) {
            return jrElement.getTheme();
        }
        if (id.equals("evaluationGroup")) {
            if (jrElement.getEvaluationGroup() != null) {
                return jrElement.getEvaluationGroup().getName();
            }
            return "";
        }
        if (id.equals("hyperlinkParameters")) {
            return jrElement.getHyperlinkParameters();
        }
        if (id.equals("titleColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getOwnTitleColor());
        }
        if (id.equals("subtitleColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getOwnSubtitleColor());
        }
        if (id.equals("legendColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getOwnLegendColor());
        }
        if (id.equals("legendBackgroundColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getOwnLegendBackgroundColor());
        }
        if (id.equals("isShowLegend")) {
            return jrElement.getShowLegend();
        }
        if (id.equals("customizerClass")) {
            return jrElement.getCustomizerClass();
        }
        if (id.equals("linkTarget")) {
            return jrElement.getLinkTarget();
        }
        if (id.equals("hyperlinkType")) {
            return jrElement.getLinkType();
        }
        if (id.equals("hyperlinkAnchorExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getHyperlinkAnchorExpression());
        }
        if (id.equals("hyperlinkPageExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getHyperlinkPageExpression());
        }
        if (id.equals("hyperlinkReferenceExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getHyperlinkReferenceExpression());
        }
        if (id.equals("hyperlinkTooltipExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getHyperlinkTooltipExpression());
        }
        if (id.equals("hyperlinkWhenExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getHyperlinkWhenExpression());
        }
        if (id.equals("anchorNameExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getAnchorNameExpression());
        }
        if (id.equals("bookmarkLevelExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getBookmarkLevelExpression());
        }
        if (id.equals("bookmarkLevel")) {
            return jrElement.getBookmarkLevel();
        }
        if (id.equals(PLOTPROPERTY)) {
            if (this.mChartPlot == null) {
                this.mChartPlot = PlotFactory.getChartPlot(jrElement.getPlot());
                this.setChildListener((ANode)this.mChartPlot);
            }
            this.mChartPlot.setJasperConfiguration(this.getJasperConfiguration());
            return this.mChartPlot;
        }
        if (id.equals("titleFont")) {
            this.tFont = MFontUtil.getMFont((MFont)this.tFont, (JRFont)jrElement.getTitleFont(), (JRStyle)jrElement.getStyle(), (APropertyNode)this);
            return this.tFont;
        }
        if (id.equals("subtitleFont")) {
            this.stFont = MFontUtil.getMFont((MFont)this.stFont, (JRFont)jrElement.getSubtitleFont(), (JRStyle)jrElement.getStyle(), (APropertyNode)this);
            return this.stFont;
        }
        if (id.equals("legendFont")) {
            this.lFont = MFontUtil.getMFont((MFont)this.lFont, (JRFont)jrElement.getLegendFont(), (JRStyle)jrElement.getStyle(), (APropertyNode)this);
            return this.lFont;
        }
        if (id.equals("titleExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getTitleExpression());
        }
        if (id.equals("subtitleExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getSubtitleExpression());
        }
        return super.getPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignChart jrElement = this.getValue();
        if (id.equals(CHART_PROPERTY_CUSTOMIZER)) {
            super.setPropertyValue((Object)"propertyExpressions", value);
        } else if (id.equals("titleFont")) {
            jrElement.setTitleFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("subtitleFont")) {
            jrElement.setSubtitleFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("legendFont")) {
            jrElement.setLegendFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("titlePosition")) {
            jrElement.setTitlePosition((EdgeEnum)titlePositionD.getEnumValue(value));
        } else if (id.equals("legendPosition")) {
            jrElement.setLegendPosition((EdgeEnum)legendPositionD.getEnumValue(value));
        } else if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            jrElement.setEvaluationTime(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                jrElement.setEvaluationGroup(null);
            }
        } else if (id.equals("isShowLegend")) {
            jrElement.setShowLegend((Boolean)value);
        } else if (id.equals("renderType")) {
            value = Misc.nullValue((String)((String)value));
            jrElement.setRenderType((String)value);
        } else if (id.equals("theme")) {
            value = Misc.nullValue((String)((String)value));
            jrElement.setTheme((String)value);
        } else if (id.equals("evaluationGroup")) {
            if (value != null && !value.equals("")) {
                JRGroup group = (JRGroup)this.getJasperDesign().getGroupsMap().get(value);
                jrElement.setEvaluationGroup(group);
            } else {
                jrElement.setEvaluationGroup(null);
            }
        } else if (id.equals("titleColor")) {
            if (value == null || value instanceof AlfaRGB) {
                jrElement.setTitleColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("subtitleColor")) {
            if (value == null || value instanceof AlfaRGB) {
                jrElement.setSubtitleColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("legendColor")) {
            if (value == null || value instanceof AlfaRGB) {
                jrElement.setLegendColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("legendBackgroundColor")) {
            if (value == null || value instanceof AlfaRGB) {
                jrElement.setLegendBackgroundColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("customizerClass")) {
            value = Misc.nullValue((String)((String)value));
            jrElement.setCustomizerClass((String)value);
        } else if (id.equals("titleExpression")) {
            jrElement.setTitleExpression(ExprUtil.setValues((JRExpression)jrElement.getTitleExpression(), (Object)value));
        } else if (id.equals("subtitleExpression")) {
            jrElement.setSubtitleExpression(ExprUtil.setValues((JRExpression)jrElement.getSubtitleExpression(), (Object)value));
        } else if (id.equals("anchorNameExpression")) {
            jrElement.setAnchorNameExpression(ExprUtil.setValues((JRExpression)jrElement.getAnchorNameExpression(), (Object)value));
        } else if (id.equals("bookmarkLevelExpression")) {
            jrElement.setBookmarkLevelExpression(ExprUtil.setValues((JRExpression)jrElement.getBookmarkLevelExpression(), (Object)value));
        } else if (id.equals("bookmarkLevel")) {
            jrElement.setBookmarkLevel(value != null ? Integer.parseInt(value.toString()) : 0);
        } else if (id.equals("linkTarget")) {
            jrElement.setLinkTarget((String)value);
        } else if (id.equals("hyperlinkType")) {
            jrElement.setLinkType((String)value);
        } else if (id.equals("hyperlinkAnchorExpression")) {
            jrElement.setHyperlinkAnchorExpression(ExprUtil.setValues((JRExpression)jrElement.getHyperlinkAnchorExpression(), (Object)value));
        } else if (id.equals("hyperlinkPageExpression")) {
            jrElement.setHyperlinkPageExpression(ExprUtil.setValues((JRExpression)jrElement.getHyperlinkPageExpression(), (Object)value));
        } else if (id.equals("hyperlinkReferenceExpression")) {
            jrElement.setHyperlinkReferenceExpression(ExprUtil.setValues((JRExpression)jrElement.getHyperlinkReferenceExpression(), (Object)value));
        } else if (id.equals("hyperlinkTooltipExpression")) {
            jrElement.setHyperlinkTooltipExpression(ExprUtil.setValues((JRExpression)jrElement.getHyperlinkTooltipExpression(), (Object)value));
        } else if (id.equals("hyperlinkWhenExpression")) {
            jrElement.setHyperlinkWhenExpression(ExprUtil.setValues((JRExpression)jrElement.getHyperlinkWhenExpression(), (Object)value));
        } else if (id.equals("hyperlinkParameters")) {
            int n;
            int n2;
            JRHyperlinkParameter[] jRHyperlinkParameterArray;
            JRHyperlinkParameter[] oldParameters = jrElement.getHyperlinkParameters();
            JRHyperlinkParameter[] newParameters = (JRHyperlinkParameter[])value;
            if (oldParameters != null) {
                jRHyperlinkParameterArray = oldParameters;
                n2 = oldParameters.length;
                n = 0;
                while (n < n2) {
                    JRHyperlinkParameter prm = jRHyperlinkParameterArray[n];
                    jrElement.removeHyperlinkParameter(prm);
                    ++n;
                }
            }
            jRHyperlinkParameterArray = newParameters;
            n2 = newParameters.length;
            n = 0;
            while (n < n2) {
                JRHyperlinkParameter param = jRHyperlinkParameterArray[n];
                jrElement.addHyperlinkParameter(param);
                ++n;
            }
        } else {
            super.setPropertyValue(id, value);
        }
    }

    public int getDefaultHeight() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(((Object)((Object)this)).getClass(), "height");
        return defaultValue != null ? (Integer)defaultValue : 200;
    }

    public int getDefaultWidth() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(((Object)((Object)this)).getClass(), "width");
        return defaultValue != null ? (Integer)defaultValue : 200;
    }

    public static JRDesignChart createJRElement(JasperDesign jasperDesign, byte chartType, boolean applyDefault) {
        JRDesignChart jrChart = new JRDesignChart((JRDefaultStyleProvider)jasperDesign, chartType);
        MChart.setupChart(jrChart);
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(MChart.class, (JRElement)jrChart);
        }
        return jrChart;
    }

    public static void setupChart(JRDesignChart jrChart) {
        jrChart.setEvaluationTime(EvaluationTimeEnum.REPORT);
        if (jrChart.getChartType() == 14 && jrChart.getDataset() == null) {
            jrChart.setDataset((JRChartDataset)new JRDesignXyDataset(null));
        }
        if (jrChart.getDataset() instanceof JRDesignHighLowDataset) {
            JRDesignHighLowDataset jds = (JRDesignHighLowDataset)jrChart.getDataset();
            if (jds.getCloseExpression() == null) {
                jds.setCloseExpression(ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)"100"));
            }
            if (jds.getOpenExpression() == null) {
                jds.setOpenExpression(ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)"100"));
            }
            if (jds.getVolumeExpression() == null) {
                jds.setVolumeExpression(ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)"100"));
            }
            if (jds.getHighExpression() == null) {
                jds.setHighExpression(ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)"100"));
            }
            if (jds.getLowExpression() == null) {
                jds.setLowExpression(ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)"100"));
            }
            if (jds.getDateExpression() == null) {
                jds.setDateExpression(ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)"new Date()"));
            }
            if (jds.getSeriesExpression() == null) {
                jds.setSeriesExpression((JRExpression)new JRDesignExpression("\"CHANGE_ME\""));
            }
        } else if (jrChart.getDataset() instanceof JRDesignPieDataset) {
            if (Misc.isNullOrEmpty((Collection)((JRDesignPieDataset)jrChart.getDataset()).getSeriesList())) {
                JRDesignPieSeries pieSeries = new PieSerie().createSerie();
                ((JRDesignPieDataset)jrChart.getDataset()).addPieSeries((JRPieSeries)pieSeries);
            }
        } else if (jrChart.getDataset() instanceof JRDesignCategoryDataset) {
            if (Misc.isNullOrEmpty((Collection)((JRDesignCategoryDataset)jrChart.getDataset()).getSeriesList())) {
                JRDesignCategorySeries catSeries = new CategorySerie().createSerie();
                ((JRDesignCategoryDataset)jrChart.getDataset()).addCategorySeries((JRCategorySeries)catSeries);
            }
        } else if (jrChart.getDataset() instanceof JRDesignValueDataset) {
            JRDesignValueDataset valueDataset = (JRDesignValueDataset)jrChart.getDataset();
            if (valueDataset.getValueExpression() == null) {
                if (jrChart.getChartType() == 17) {
                    valueDataset.setValueExpression((JRExpression)new JRDesignExpression("50"));
                } else {
                    valueDataset.setValueExpression((JRExpression)new JRDesignExpression("\"CHANGE_ME\""));
                }
            }
        } else if (jrChart.getDataset() instanceof JRDesignXyDataset) {
            if (Misc.isNullOrEmpty((Collection)((JRDesignXyDataset)jrChart.getDataset()).getSeriesList())) {
                JRDesignXySeries series = new XySerie().createSerie();
                ((JRDesignXyDataset)jrChart.getDataset()).addXySeries((JRXySeries)series);
            }
        } else if (jrChart.getDataset() instanceof JRDesignXyzDataset) {
            if (Misc.isNullOrEmpty((Collection)((JRDesignXyzDataset)jrChart.getDataset()).getSeriesList())) {
                JRDesignXyzSeries series = new XyzSerie().createSerie();
                ((JRDesignXyzDataset)jrChart.getDataset()).addXyzSeries((JRXyzSeries)series);
            }
        } else if (jrChart.getDataset() instanceof JRDesignTimeSeriesDataset) {
            if (Misc.isNullOrEmpty((Collection)((JRDesignTimeSeriesDataset)jrChart.getDataset()).getSeriesList())) {
                JRDesignTimeSeries series = new TimeSerie().createSerie();
                ((JRDesignTimeSeriesDataset)jrChart.getDataset()).addTimeSeries((JRTimeSeries)series);
                ((JRDesignTimeSeriesDataset)jrChart.getDataset()).setTimePeriod(TimePeriodEnum.DAY.getTimePeriod());
            }
        } else if (jrChart.getDataset() instanceof JRDesignTimePeriodDataset) {
            if (Misc.isNullOrEmpty((Collection)((JRDesignTimePeriodDataset)jrChart.getDataset()).getSeriesList())) {
                JRDesignTimePeriodSeries series = new TimePeriodSerie().createSerie();
                ((JRDesignTimePeriodDataset)jrChart.getDataset()).addTimePeriodSeries((JRTimePeriodSeries)series);
            }
        } else if (jrChart.getDataset() instanceof JRDesignGanttDataset && Misc.isNullOrEmpty((Collection)((JRDesignGanttDataset)jrChart.getDataset()).getSeriesList())) {
            JRDesignGanttSeries series = new GanttSeries().createSerie();
            ((JRDesignGanttDataset)jrChart.getDataset()).addGanttSeries((JRGanttSeries)series);
        }
        MChart.setupPlot(jrChart);
    }

    public static void setupPlot(JRDesignChart jrChart) {
        JRChartPlot plot = jrChart.getPlot();
        if (plot instanceof JRDesignBar3DPlot) {
            JRDesignBar3DPlot jrPlot = (JRDesignBar3DPlot)plot;
            if (jrPlot.getItemLabel() == null || !(jrPlot.getItemLabel() instanceof JRDesignItemLabel)) {
                jrPlot.setItemLabel((JRItemLabel)new JRDesignItemLabel(null, (JRChart)jrChart));
            }
        } else if (plot instanceof JRDesignPiePlot) {
            JRDesignPiePlot jrPlot = (JRDesignPiePlot)plot;
            if (jrPlot.getItemLabel() == null || !(jrPlot.getItemLabel() instanceof JRDesignItemLabel)) {
                jrPlot.setItemLabel((JRItemLabel)new JRDesignItemLabel(null, (JRChart)jrChart));
            }
        } else if (plot instanceof JRDesignPie3DPlot) {
            JRDesignPie3DPlot jrPlot = (JRDesignPie3DPlot)plot;
            if (jrPlot.getItemLabel() == null || !(jrPlot.getItemLabel() instanceof JRDesignItemLabel)) {
                jrPlot.setItemLabel((JRItemLabel)new JRDesignItemLabel(null, (JRChart)jrChart));
            }
        } else if (plot instanceof JRDesignBarPlot) {
            JRDesignBarPlot jrPlot = (JRDesignBarPlot)plot;
            if (jrPlot.getItemLabel() == null || !(jrPlot.getItemLabel() instanceof JRDesignItemLabel)) {
                jrPlot.setItemLabel((JRItemLabel)new JRDesignItemLabel(null, (JRChart)jrChart));
            }
        } else if (plot instanceof JRDesignThermometerPlot) {
            JRDesignThermometerPlot tplot = (JRDesignThermometerPlot)plot;
            if (tplot.getHighRange() == null) {
                tplot.setHighRange((JRDataRange)MChart.getDummyDataRange());
            }
            if (tplot.getLowRange() == null) {
                tplot.setLowRange((JRDataRange)MChart.getDummyDataRange());
            }
            if (tplot.getMediumRange() == null) {
                tplot.setMediumRange((JRDataRange)MChart.getDummyDataRange());
            }
            if (tplot.getDataRange() == null) {
                tplot.setDataRange((JRDataRange)MChart.getDummyDataRange());
            }
            if (tplot.getValueLocationValue() == null) {
                tplot.setValueLocation(ValueLocationEnum.LEFT);
            }
            if (tplot.getValueDisplay() == null) {
                tplot.setValueDisplay((JRValueDisplay)new JRDesignValueDisplay(null, (JRChart)jrChart));
            }
        } else if (plot instanceof JRDesignMeterPlot) {
            JRDesignMeterPlot tplot = (JRDesignMeterPlot)plot;
            try {
                if (tplot.getValueDisplay() == null) {
                    tplot.setValueDisplay((JRValueDisplay)new JRDesignValueDisplay(null, (JRChart)jrChart));
                }
                if (tplot.getDataRange() == null) {
                    tplot.setDataRange((JRDataRange)MChart.getDummyDataRange());
                }
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        } else if (plot instanceof JRDesignMultiAxisPlot) {
            ((JRDesignMultiAxisPlot)plot).setChart(jrChart);
        }
    }

    private static JRDesignDataRange getDummyDataRange() {
        JRDesignDataRange dataRange = new JRDesignDataRange(null);
        dataRange.setHighExpression((JRExpression)new JRDesignExpression("100"));
        dataRange.setLowExpression((JRExpression)new JRDesignExpression("1"));
        return dataRange;
    }

    public String getDisplayText() {
        String p = this.getElementNameProperty();
        if (!Misc.isNullOrEmpty((String)p)) {
            return p;
        }
        if (this.getValue() != null) {
            JRDesignChart chart = this.getValue();
            String chartype = "";
            switch (chart.getChartType()) {
                case 1: {
                    chartype = "Area";
                    break;
                }
                case 3: {
                    chartype = "Bar";
                    break;
                }
                case 2: {
                    chartype = "Bar 3D";
                    break;
                }
                case 4: {
                    chartype = "Bubble";
                    break;
                }
                case 5: {
                    chartype = "Candlestick";
                    break;
                }
                case 6: {
                    chartype = "High Low";
                    break;
                }
                case 7: {
                    chartype = "Line";
                    break;
                }
                case 17: {
                    chartype = "Meter";
                    break;
                }
                case 19: {
                    chartype = "Multi Axis";
                    break;
                }
                case 9: {
                    chartype = "Pie";
                    break;
                }
                case 8: {
                    chartype = "Pie 3D";
                    break;
                }
                case 10: {
                    chartype = "Scatter";
                    break;
                }
                case 12: {
                    chartype = "Stacked Bar";
                    break;
                }
                case 11: {
                    chartype = "Stacked Bar 3D";
                    break;
                }
                case 18: {
                    chartype = "Thermometer";
                    break;
                }
                case 16: {
                    chartype = "Time Series";
                    break;
                }
                case 13: {
                    chartype = "XY Area";
                    break;
                }
                case 14: {
                    chartype = "XY Bar";
                    break;
                }
                case 15: {
                    chartype = "XY Line";
                    break;
                }
                case 20: {
                    chartype = "Stacked Area";
                    break;
                }
                case 21: {
                    chartype = "Gantt";
                    break;
                }
                default: {
                    throw new JRRuntimeException("Chart type not supported.");
                }
            }
            return chartype;
        }
        return MChart.getIconDescriptor().getTitle();
    }

    public ImageDescriptor getImagePath() {
        return MChart.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MChart.getIconDescriptor().getToolTip();
    }

    public void setValue(Object value) {
        JRDesignChart oldObject = this.getValue();
        JRChart newObject = (JRChart)value;
        if (oldObject != null) {
            ((JRBaseChartPlot)oldObject.getPlot()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            if (oldObject.getLegendFont() != null) {
                ((JRBaseFont)oldObject.getLegendFont()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            if (oldObject.getSubtitleFont() != null) {
                ((JRBaseFont)oldObject.getSubtitleFont()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            if (oldObject.getTitleFont() != null) {
                ((JRBaseFont)oldObject.getTitleFont()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
        }
        if (newObject != null) {
            ((JRBaseChartPlot)newObject.getPlot()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            if (newObject.getLegendFont() != null) {
                ((JRBaseFont)newObject.getLegendFont()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            if (newObject.getSubtitleFont() != null) {
                ((JRBaseFont)newObject.getSubtitleFont()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            if (newObject.getTitleFont() != null) {
                ((JRBaseFont)newObject.getTitleFont()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
        }
        super.setValue(value);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setChangedProperty(true);
        if (evt.getPropertyName().equals("children")) {
            if (evt.getSource() == this.getValue()) {
                if (evt.getOldValue() == null && evt.getNewValue() != null) {
                    int newIndex = -1;
                    if (evt instanceof CollectionElementAddedEvent) {
                        newIndex = ((CollectionElementAddedEvent)evt).getAddedIndex();
                    }
                    ANode n = ReportFactory.createNode((ANode)this, (Object)evt.getNewValue(), (int)newIndex);
                    if (evt.getNewValue() instanceof JRElementGroup) {
                        JRElementGroup jrFrame = (JRElementGroup)evt.getNewValue();
                        ReportFactory.createElementsForBand((ANode)n, (List)jrFrame.getChildren());
                    }
                } else if (evt.getOldValue() != null && evt.getNewValue() == null) {
                    for (INode n : this.getChildren()) {
                        if (n.getValue() != evt.getOldValue()) continue;
                        this.removeChild((ANode)n);
                        break;
                    }
                } else {
                    for (INode n : this.getChildren()) {
                        if (n.getValue() != evt.getOldValue()) continue;
                        n.setValue(evt.getNewValue());
                    }
                }
            }
        } else if (evt.getPropertyName().equals("axes")) {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                int newIndex = -2;
                if (evt instanceof CollectionElementAddedEvent) {
                    newIndex = ((CollectionElementAddedEvent)evt).getAddedIndex();
                }
                ReportFactory.createNode((ANode)this, (Object)evt.getNewValue(), (int)newIndex);
            } else if (evt.getOldValue() != null && evt.getNewValue() == null) {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    this.removeChild((ANode)n);
                    break;
                }
            } else {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    n.setValue(evt.getNewValue());
                }
            }
        }
        PropertyChangeEvent newEvent = evt;
        if (!(evt.getSource() instanceof ANode)) {
            newEvent = new PropertyChangeEvent((Object)this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
        this.getPropertyChangeSupport().firePropertyChange(newEvent);
    }

    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MChart) {
            return ICopyable.RESULT.COPYABLE;
        }
        return super.isCopyable2(parent);
    }

    public List<MDatasetRun> getDatasetRunList() {
        JRDesignChart oldObject = this.getValue();
        if (oldObject != null && oldObject.getDataset() != null) {
            ArrayList<MDatasetRun> datasetList = new ArrayList<MDatasetRun>();
            MDatasetRun mDatasetRun = new MDatasetRun(oldObject.getDataset().getDatasetRun(), this.getJasperDesign());
            mDatasetRun.setJasperConfiguration(this.getJasperConfiguration());
            datasetList.add(mDatasetRun);
            return datasetList;
        }
        return null;
    }

    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignChart jrSource = this.getValue();
        if (jrSource != null) {
            JRDesignChart jrTarget = (JRDesignChart)target;
            jrTarget.setTitleFont(this.getFontClone(jrSource.getTitleFont()));
            jrTarget.setSubtitleFont(this.getFontClone(jrSource.getSubtitleFont()));
            jrTarget.setLegendFont(this.getFontClone(jrSource.getLegendFont()));
            jrTarget.setTitlePosition(jrSource.getTitlePositionValue());
            jrTarget.setLegendPosition(jrSource.getLegendPositionValue());
            jrTarget.setShowLegend(jrSource.getShowLegend());
            jrTarget.setRenderType(jrSource.getRenderType());
            jrTarget.setTitleColor(this.getColorClone(jrSource.getOwnTitleColor()));
            jrTarget.setSubtitleColor(this.getColorClone(jrSource.getOwnSubtitleColor()));
            jrTarget.setLegendColor(this.getColorClone(jrSource.getOwnLegendColor()));
            jrTarget.setLegendBackgroundColor(this.getColorClone(jrSource.getOwnLegendBackgroundColor()));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISetValueCommandProvider.class) {
            return ChartSetValueCommandProvider.INSTANCE;
        }
        return super.getAdapter(adapter);
    }
}

