/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.chartAxis.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.chartAxis.MChartAxes;
import com.jaspersoft.studio.model.ANode;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.design.JRDesignChartAxis;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.engine.design.JRDesignChart;
import org.eclipse.gef.commands.Command;

public class ReorderChartAxesCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignChartAxis jrElement;
    private JRDesignMultiAxisPlot jrGroup;

    public ReorderChartAxesCommand(MChartAxes child, ANode parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = (JRDesignChartAxis)child.getValue();
        this.jrGroup = (JRDesignMultiAxisPlot)((JRDesignChart)parent.getValue()).getPlot();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getAxes().indexOf(this.jrElement);
        this.jrGroup.removeAxis((JRChartAxis)this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getAxes().size()) {
            this.jrGroup.addAxis(this.newIndex, (JRChartAxis)this.jrElement);
        } else {
            this.jrGroup.addAxis((JRChartAxis)this.jrElement);
        }
    }

    public void undo() {
        this.jrGroup.removeAxis((JRChartAxis)this.jrElement);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getAxes().size()) {
            this.jrGroup.addAxis(this.oldIndex, (JRChartAxis)this.jrElement);
        } else {
            this.jrGroup.addAxis((JRChartAxis)this.jrElement);
        }
    }
}

