/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.enums;

import net.sf.jasperreports.engine.type.JREnum;
import org.jfree.ui.VerticalAlignment;

public enum JFreeChartVerticalAlignmentEnum implements JREnum
{
    TOP(0, "Top"),
    CENTER(1, "Center"),
    BOTTOM(2, "Bottom");

    private static final long serialVersionUID = 10200L;
    private final transient byte value;
    private final transient String name;

    private JFreeChartVerticalAlignmentEnum(byte value, String name) {
        this.value = value;
        this.name = name;
    }

    public static JFreeChartVerticalAlignmentEnum getValue(VerticalAlignment ha) {
        if (ha != null) {
            if (ha.equals((Object)VerticalAlignment.CENTER)) {
                return CENTER;
            }
            if (ha.equals((Object)VerticalAlignment.TOP)) {
                return TOP;
            }
            if (ha.equals((Object)VerticalAlignment.BOTTOM)) {
                return BOTTOM;
            }
        }
        return TOP;
    }

    public VerticalAlignment getJFreeChartValue() {
        if (this.value == 0) {
            return VerticalAlignment.TOP;
        }
        if (this.value == 1) {
            return VerticalAlignment.CENTER;
        }
        if (this.value == 2) {
            return VerticalAlignment.BOTTOM;
        }
        return null;
    }

    public Byte getValueByte() {
        return new Byte(this.value);
    }

    public final byte getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static JFreeChartVerticalAlignmentEnum getByName(String name) {
        if (CENTER.getName().equals(name)) {
            return CENTER;
        }
        if (TOP.getName().equals(name)) {
            return TOP;
        }
        if (BOTTOM.getName().equals(name)) {
            return BOTTOM;
        }
        return null;
    }

    public static JFreeChartVerticalAlignmentEnum getByValue(Byte value) {
        if (CENTER.getValueByte().equals(value)) {
            return CENTER;
        }
        if (TOP.getValueByte().equals(value)) {
            return TOP;
        }
        if (BOTTOM.getValueByte().equals(value)) {
            return BOTTOM;
        }
        return null;
    }

    public static JFreeChartVerticalAlignmentEnum getByValue(byte value) {
        return JFreeChartVerticalAlignmentEnum.getByValue(new Byte(value));
    }
}

