/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.plot;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.plot.MChartPlot;
import com.jaspersoft.studio.components.chart.property.descriptor.MeterIntervalPropertyDescriptor;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.text.MFont;
import com.jaspersoft.studio.model.text.MFontUtil;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.FontPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.DoublePropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.IntegerPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.design.JRDesignDataRange;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDisplay;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MMeterPlot
extends MChartPlot {
    public static final long serialVersionUID = 10200L;
    private static IPropertyDescriptor[] descriptors;
    private MFont tlFont;
    private MFont vdFont;
    private static NamedEnumPropertyDescriptor<MeterShapeEnum> shapeD;

    public MMeterPlot(JRMeterPlot value) {
        super((JRChartPlot)value);
    }

    @Override
    public String getDisplayText() {
        return Messages.MMeterPlot_meter_plot;
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        ColorPropertyDescriptor meterBackgroundColorD = new ColorPropertyDescriptor((Object)"meterBackgroundColor", Messages.MMeterPlot_meter_background_color, NullEnum.NULL);
        meterBackgroundColorD.setDescription(Messages.MMeterPlot_meter_background_color_description);
        desc.add((IPropertyDescriptor)meterBackgroundColorD);
        ColorPropertyDescriptor tickColorD = new ColorPropertyDescriptor((Object)"tickColor", Messages.MMeterPlot_tick_color, NullEnum.NULL);
        tickColorD.setDescription(Messages.MMeterPlot_tick_color_description);
        desc.add((IPropertyDescriptor)tickColorD);
        ColorPropertyDescriptor needleColorD = new ColorPropertyDescriptor((Object)"needleColor", Messages.MMeterPlot_needle_color, NullEnum.NULL);
        needleColorD.setDescription(Messages.MMeterPlot_needle_color_description);
        desc.add((IPropertyDescriptor)needleColorD);
        ColorPropertyDescriptor valueColorD = new ColorPropertyDescriptor((Object)"valueDisplay.color", Messages.common_value_color, NullEnum.NULL);
        valueColorD.setDescription(Messages.MMeterPlot_value_color_description);
        desc.add((IPropertyDescriptor)valueColorD);
        valueColorD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#valueDisplay_color"));
        FontPropertyDescriptor tickLabelFontD = new FontPropertyDescriptor((Object)"tickLabelFont", Messages.MMeterPlot_tick_label_font);
        tickLabelFontD.setDescription(Messages.MMeterPlot_tick_label_font_description);
        desc.add((IPropertyDescriptor)tickLabelFontD);
        FontPropertyDescriptor valueFontD = new FontPropertyDescriptor((Object)"valueDisplay.font", Messages.common_value_font);
        valueFontD.setDescription(Messages.MMeterPlot_value_font_description);
        desc.add((IPropertyDescriptor)valueFontD);
        valueFontD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#font"));
        IntegerPropertyDescriptor meterAngleD = new IntegerPropertyDescriptor((Object)"meterAngle", Messages.MMeterPlot_meter_angle);
        meterAngleD.setDescription(Messages.MMeterPlot_meter_angle_description);
        desc.add((IPropertyDescriptor)meterAngleD);
        DoublePropertyDescriptor tickIntervalD = new DoublePropertyDescriptor((Object)"tickInterval", Messages.MMeterPlot_tick_interval);
        tickIntervalD.setDescription(Messages.MMeterPlot_tick_interval_description);
        desc.add((IPropertyDescriptor)tickIntervalD);
        shapeD = new NamedEnumPropertyDescriptor((Object)"shape", Messages.MMeterPlot_shape, (Enum)MeterShapeEnum.CHORD, NullEnum.NOTNULL);
        shapeD.setDescription(Messages.MMeterPlot_shape_description);
        desc.add((IPropertyDescriptor)shapeD);
        JRExpressionPropertyDescriptor dataRangeHighExprD = new JRExpressionPropertyDescriptor((Object)"dataRange.highExpression", Messages.common_data_range_high_expression);
        dataRangeHighExprD.setDescription(Messages.MMeterPlot_data_range_high_expression_description);
        desc.add((IPropertyDescriptor)dataRangeHighExprD);
        dataRangeHighExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#highExpression"));
        JRExpressionPropertyDescriptor dataRangeLowExprD = new JRExpressionPropertyDescriptor((Object)"dataRange.lowExpression", Messages.common_data_range_low_expression);
        dataRangeLowExprD.setDescription(Messages.MMeterPlot_data_range_low_expression_description);
        desc.add((IPropertyDescriptor)dataRangeLowExprD);
        dataRangeLowExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#lowExpression"));
        NTextPropertyDescriptor unitsD = new NTextPropertyDescriptor((Object)"units", Messages.MMeterPlot_units);
        unitsD.setDescription(Messages.MMeterPlot_units_description);
        desc.add((IPropertyDescriptor)unitsD);
        NTextPropertyDescriptor maskD = new NTextPropertyDescriptor((Object)"valueDisplay.mask", Messages.common_value_mask);
        maskD.setDescription(Messages.MMeterPlot_value_mask_description);
        desc.add((IPropertyDescriptor)maskD);
        maskD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#valueDisplay_mask"));
        MeterIntervalPropertyDescriptor mipd = new MeterIntervalPropertyDescriptor("intervals", "Intervals");
        mipd.setDescription("Meter Intervals");
        desc.add((IPropertyDescriptor)mipd);
        mipd.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#meterInterval"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#meterPlot");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("meterBackgroundColor", new DefaultValue(true));
        defaultsMap.put("needleColor", new DefaultValue(true));
        defaultsMap.put("tickColor", new DefaultValue(true));
        defaultsMap.put("tickInterval", new DefaultValue(true));
        defaultsMap.put("meterAngle", new DefaultValue(true));
        return defaultsMap;
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignMeterPlot jrElement = (JRDesignMeterPlot)this.getValue();
        JRDesignDataRange jrDataRange = (JRDesignDataRange)jrElement.getDataRange();
        if (id.equals("meterBackgroundColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getMeterBackgroundColor());
        }
        if (id.equals("tickColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getTickColor());
        }
        if (id.equals("needleColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getNeedleColor());
        }
        if (id.equals("valueDisplay.color")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getValueDisplay().getColor());
        }
        if (id.equals("meterAngle")) {
            return jrElement.getMeterAngleInteger();
        }
        if (id.equals("tickInterval")) {
            return jrElement.getTickIntervalDouble();
        }
        if (id.equals("shape")) {
            return shapeD.getIntValue((Enum)jrElement.getShapeValue());
        }
        if (id.equals("units")) {
            return jrElement.getUnits();
        }
        if (id.equals("valueDisplay.mask")) {
            return jrElement.getValueDisplay().getMask();
        }
        if (id.equals("dataRange.highExpression")) {
            return jrDataRange != null ? ExprUtil.getExpression((JRExpression)jrDataRange.getHighExpression()) : null;
        }
        if (id.equals("dataRange.lowExpression")) {
            return jrDataRange != null ? ExprUtil.getExpression((JRExpression)jrDataRange.getLowExpression()) : null;
        }
        if (id.equals("tickLabelFont")) {
            this.tlFont = MFontUtil.getMFont((MFont)this.tlFont, (JRFont)jrElement.getTickLabelFont(), null, (APropertyNode)this);
            return this.tlFont;
        }
        if (id.equals("valueDisplay.font")) {
            this.vdFont = MFontUtil.getMFont((MFont)this.vdFont, (JRFont)jrElement.getValueDisplay().getFont(), null, (APropertyNode)this);
            return this.vdFont;
        }
        if (id.equals("intervals")) {
            List lst = jrElement.getIntervals();
            if (lst != null) {
                return new ArrayList(lst);
            }
            return lst;
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignMeterPlot jrElement = (JRDesignMeterPlot)this.getValue();
        JRDesignDataRange jrDataRange = (JRDesignDataRange)jrElement.getDataRange();
        if (id.equals("intervals")) {
            jrElement.setIntervals((Collection)value);
        } else if (id.equals("tickLabelFont")) {
            jrElement.setTickLabelFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("valueDisplay.font")) {
            JRDesignValueDisplay jrDesignValueDisplay = new JRDesignValueDisplay(jrElement.getValueDisplay(), jrElement.getChart());
            jrDesignValueDisplay.setFont(MFontUtil.setMFont((Object)value));
            jrElement.setValueDisplay((JRValueDisplay)jrDesignValueDisplay);
        } else if (id.equals("valueDisplay.color") && (value == null || value instanceof AlfaRGB)) {
            JRDesignValueDisplay jrDesignValueDisplay = new JRDesignValueDisplay(jrElement.getValueDisplay(), jrElement.getChart());
            jrDesignValueDisplay.setColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            jrElement.setValueDisplay((JRValueDisplay)jrDesignValueDisplay);
        } else if (id.equals("valueDisplay.mask")) {
            JRDesignValueDisplay jrDesignValueDisplay = new JRDesignValueDisplay(jrElement.getValueDisplay(), jrElement.getChart());
            jrDesignValueDisplay.setMask((String)value);
            jrElement.setValueDisplay((JRValueDisplay)jrDesignValueDisplay);
        } else if (id.equals("meterBackgroundColor") && (value == null || value instanceof AlfaRGB)) {
            jrElement.setMeterBackgroundColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
        } else if (id.equals("tickColor") && (value == null || value instanceof AlfaRGB)) {
            jrElement.setTickColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
        } else if (id.equals("needleColor") && (value == null || value instanceof AlfaRGB)) {
            jrElement.setNeedleColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
        } else if (id.equals("meterAngle")) {
            jrElement.setMeterAngle((Integer)value);
        } else if (id.equals("tickInterval")) {
            jrElement.setTickInterval((Double)value);
        } else if (id.equals("shape")) {
            try {
                jrElement.setShape((MeterShapeEnum)shapeD.getEnumValue(value));
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        } else if (id.equals("units")) {
            jrElement.setUnits((String)value);
        } else if (id.equals("dataRange.highExpression")) {
            jrDataRange.setHighExpression(ExprUtil.setValues((JRExpression)jrDataRange.getHighExpression(), (Object)value));
        } else if (id.equals("dataRange.lowExpression")) {
            jrDataRange.setLowExpression(ExprUtil.setValues((JRExpression)jrDataRange.getLowExpression(), (Object)value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

