/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.series.timeperiod.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.dataset.MChartDataset;
import com.jaspersoft.studio.components.chart.model.series.timeperiod.MTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodDataset;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodSeries;
import org.eclipse.gef.commands.Command;

public class ReorderTimePeriodSeriesCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignTimePeriodSeries jrElement;
    private JRDesignTimePeriodDataset jrGroup;

    public ReorderTimePeriodSeriesCommand(MTimePeriodSeries child, MChartDataset parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrGroup = (JRDesignTimePeriodDataset)parent.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getSeriesList().indexOf(this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addTimePeriodSeries(this.newIndex, (JRTimePeriodSeries)this.jrElement);
        } else {
            this.jrGroup.addTimePeriodSeries((JRTimePeriodSeries)this.jrElement);
        }
    }

    public void undo() {
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addTimePeriodSeries(this.oldIndex, (JRTimePeriodSeries)this.jrElement);
        } else {
            this.jrGroup.addTimePeriodSeries((JRTimePeriodSeries)this.jrElement);
        }
    }
}

