/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.series.xyzseries.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.dataset.MChartDataset;
import com.jaspersoft.studio.components.chart.model.series.xyzseries.MXYZSeries;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzSeries;
import org.eclipse.gef.commands.Command;

public class ReorderXYZSeriesCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignXyzSeries jrElement;
    private JRDesignXyzDataset jrGroup;

    public ReorderXYZSeriesCommand(MXYZSeries child, MChartDataset parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrGroup = (JRDesignXyzDataset)parent.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getSeriesList().indexOf(this.jrElement);
        this.jrGroup.removeXyzSeries((JRXyzSeries)this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addXyzSeries(this.newIndex, (JRXyzSeries)this.jrElement);
        } else {
            this.jrGroup.addXyzSeries((JRXyzSeries)this.jrElement);
        }
    }

    public void undo() {
        this.jrGroup.removeXyzSeries((JRXyzSeries)this.jrElement);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addXyzSeries(this.oldIndex, (JRXyzSeries)this.jrElement);
        } else {
            this.jrGroup.addXyzSeries((JRXyzSeries)this.jrElement);
        }
    }
}

